﻿(function ($, ns) {
    var addVersionDialog = function (config) {
        config.dialogClass = "manage-versions-dialog";
        config.dialogSize = "medium thin";
        config.loadControllerPath = 'version/addversiondialog';
        config.loadControllerData = {
            mediaItemId: config.mediaItemId
        };
        var self = this;
        config.actions = {
            saveAndUseAsCurrent: {
                text: translate("common.Save"),
                cssClass: "ok-action",
                action: function () {
                    self.saveAndUseAsCurrent();
                },
                disabled: true
            },
            cancel: {
                text: translate("common.Cancel"),
                action: function () {
                    self.cancel();
                },
                noButton: true,
                cssClass: "cancel-action"
            }

        };
        this.init(config);
      
        return this;
    };
    //setup inheritance
    addVersionDialog.prototype = new ImageVaultUi.Dialog;
    addVersionDialog.constructor = addVersionDialog;
    addVersionDialog.prototype.base = ImageVaultUi.Dialog.prototype;

    //own methods
    addVersionDialog.prototype.removeUploadedVersion = function (callback) {
        var self = this;
        if (self.uploadedMediaVersion) {
            var id = self.uploadedMediaVersion.Id;
            // console.log("[Cancel] Removing uploaded version " + id);
            app.json({
                url: "version/deleteversion",
                data: { versionId: id },
                error: function (err) {
                    alert("Failed to remove uploaded media version: " + err);
                    callback();
                },
                success: function () {
                    self.uploadedMediaVersion = null;
                    callback();
                }
            });
        } else {
            callback();
        }

    };
    addVersionDialog.prototype.cancel = function () {
        var self = this;
        self.removeUploadedVersion(function () {
            self.close();
        });
    };

    addVersionDialog.prototype.saveAndUseAsCurrent = function () {
        var self = this;
        var id = this.uploadedMediaVersion.Id;
        app.json({
            url: "version/save",
            data: { versionId: id, setCurrent: true, comment: self.$comment.val() },
            error: function (err) {
                alert("Failed to Save version: " + err);
            },
            success: function () {
                // console.log("Saved new version as current " + id);
                //notify photo-stream of the changes
                app.trigger('media:versionchange');
                self.close();
            }
        });

    },
        //Method updates the uploaded media version thumbnail
        addVersionDialog.prototype.loadUploadedVersionThumbnail = function (mediaVersion) {
            if (!this.isOpened()) return; //don't load thumbs if we have closed the window.
            var self = this;
            self.$nevVersionThumbnail.addClass("loading");
            app.json("version/getmediaversionthumbnail", { versionId: mediaVersion.Id }, function (thumbnail) {
                if (thumbnail) {
                    self.$nevVersionThumbnail.data("background-url", thumbnail.Url);
                    var fin = function () {
                        self.$nevVersionThumbnail.removeClass("loading");
                    };
                    ImageVaultUi.ThumbnailUtil.loadBackgroundImageAsync(self.$nevVersionThumbnail).catch(function (err) {
                        window.app.log("Failed to load image " + thumbnail.Url + "\n" + JSON.stringify(err));
                    }).catch(fin).then(fin);
                } else {
                    self.loadUploadedVersionThumbnailTimeout = setTimeout(function () {
                        self.loadUploadedVersionThumbnailTimeout = null;
                        self.loadUploadedVersionThumbnail(mediaVersion);
                    }, 2000);
                }
            });
        };
    addVersionDialog.prototype.onClose = function () {
        //clear timeouts if dialog is closed
        if (this.loadUploadedVersionThumbnailTimeout) {
            clearTimeout(this.loadUploadedVersionThumbnailTimeout);
        }
    };
    addVersionDialog.prototype.onLoad = function ($dialog) {
        var self = this;
        self.$nevVersionThumbnail = $("#new_version_thumbnail", $dialog);
        self.$comment = $("textarea#Comment", $dialog);

        const upload = document.querySelector("papirfly-upload");
        // Called when a file has finished uploading
        upload.addEventListener("upload-completed", async (e) => {
            let response = e.detail;
            var mediaVersion = await response.json();
            self.$nevVersionThumbnail.show();
            upload.style.display = "none";
            self.uploadedMediaVersion = mediaVersion;
            self.loadUploadedVersionThumbnail(mediaVersion);
            self.enableAction("saveAndUseAsCurrent");
        });
        upload.addEventListener('upload-failed', async (e) => {
            console.log('Upload failed');
            const err = e.detail;
            const response = err.cause.response;
            const body = await response.text();
            console.log(body);
        });
    };

    //export symbol
    ns.AddVersionDialog = addVersionDialog;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});