﻿(function ($, ns, undefined) {
    var agreementDialog = function (config) {
        var self = this;
        this.agreementId = config.agreementId;
        this.completed = false;
        this.submitFunction = function () {
            $("#agreement-form").submit();
        }
        config.dialogSize = "medium thin";
        config.dialogClass = "agreement-dialog";
        config.hideHrBeforeActions = true;

        config.loadControllerPath = "agreement/CreateOrEdit";
        if (config.agreementId) {
            config.loadControllerData = { agreementId: config.agreementId };
        }

        config.actions = {
            ok: {
                text: translate("vaultdialog.Save"),
                action: function () {
                    //self.submitFunction();
                },
                cssClass: "submit-action",
                disabled: config.agreementId ? false : true
            },
            cancel: {
                text: translate("common.Cancel"),
                action: function () {
                    app.trigger(ImageVaultUi.NavigationEvents.agreementDialogClosed);
                    self.close();
                },
                noButton: true,
                cssClass: "cancel-action"
            },
            closeWindow: {
                text: translate("sharedialog.CloseThisWindow"),
                action: function () {
                    app.trigger(ImageVaultUi.NavigationEvents.agreementDialogClosed);
                    self.close();
                },
                cssClass: "cancel-action",
                hidden: true
            },
            delete: {
                text: translate("common.Delete"),
                action: function () {
                    // Confirm dialog
                    var agreementId = config.agreementId;
                    var header = translate("agreementdialog.ConfirmHeader");
                    var message = translate("agreementdialog.ConfirmMessage");

                    var confirm = new ImageVaultUi.ConfirmDialog({
                        templateValues: {
                            confirmHeader: header,
                            confirmMessage: message
                        }
                    });

                    var deleteAgreementPath = app.createPath("Agreement", "Delete");

                    confirm.open(function () {
                        // Handle result
                        switch (confirm.result) {
                            case ImageVaultUi.ConfirmDialog.results.Ok:
                                app.load({
                                    url: deleteAgreementPath,
                                    data: { "agreementId": agreementId },
                                    type: "POST",
                                    success: function (data) {
                                        app.trigger("agreementDialog:agreementDeleted", agreementId);
                                        var notif = new IVNotification(translate("agreementdialog.DeleteSuccess"),
                                            {
                                                duration: 2000
                                            });
                                        app.trigger(ImageVaultUi.NavigationEvents.agreementDialogClosed);
                                        self.close();
                                    },
                                    error: function (error) {
                                        app.showError(translate("agreementdialog.DeleteError"), error);
                                        app.trigger(ImageVaultUi.NavigationEvents.agreementDialogClosed);
                                        self.close();
                                    }
                                });
                                break;
                            case ImageVaultUi.ConfirmDialog.results.Cancel:
                                break;
                        }
                    });
                },
                cssClass: "delete-action",
                hidden: config.agreementId ? false : true
            }
        };
        self.config = config;
        this.init(config);
        return this;
    };

    //setup inheritance
    agreementDialog.prototype = new ImageVaultUi.Dialog;
    agreementDialog.constructor = agreementDialog;
    agreementDialog.prototype.base = ImageVaultUi.Dialog.prototype;

    const getNumberOfExistingFiles = () => {
        return $(".existing-file", $(".existing-files")).length;
    }

    agreementDialog.prototype.onLoad = function ($dialog) {
        var self = this;
        $("#AgreementIdentifier", this.$dialog).focus();

        $("#AgreementIdentifier", this.$dialog).bind("change keyup paste", function (e) {
            if ($(e.currentTarget).val()) {
                $(".actions .submit-action", this.$dialog).removeClass("disabled");
            } else {
                $(".actions .submit-action", this.$dialog).addClass("disabled");
            }
        });

        var userLang = $("body").attr("data-ui-culture");

        var options = $.extend({},
            $.datepicker.regional[userLang],
            {
                showOn: "button",
                buttonText: "",
                dateFormat: "yy-mm-dd",
                changeMonth: true,
                changeYear: true
            });

        $.datepicker.setDefaults(options);

        // Add date picker
        $(".date-picker").datepicker();

        var saveAgreementPath = app.createPath("Agreement", "Save");

        var agreementDropzone = new Dropzone("div#agreementDropzone",
            {
                url: saveAgreementPath,
                autoProcessQueue: false,
                uploadMultiple: true,
                parallelUploads: 3,
                maxFiles: 100,
                maxFilesize: 4,
                addRemoveLinks: true,
                dictRemoveFile: "X",
                dictCancelUpload: "",
                dictCancelUploadConfirmation: "",
                dictDefaultMessage: translate("agreementdialog.UploadFiles"),
                createImageThumbnails: false,

                init: function () {
                    self.dzClosure = this; // Makes sure that 'this' is understood inside the functions below.

                    // for Dropzone to process the queue (instead of default form behavior):
                    $(".submit-action")[0].addEventListener("click", function (e) {
                        if (self.dzClosure.getAcceptedFiles().length > 0) {
                            // Make sure that the form isn't actually being sent.
                            e.preventDefault();
                            e.stopPropagation();

                            self.dzClosure.processQueue();
                        } else {
                            var comment = $('#Comment').val();
                            $('#Comment').val(comment.replace(/</g, '').replace(/>/g, ''));
                            $('#agreement-form').submit();
                        }

                        return false;
                    });

                    //send all the form data along with the files:
                    this.on("sendingmultiple", function (data, xhr, formData) {
                        $("#agreement-form input, #agreement-form textarea, #agreement-form select").each(
                            function (index, el) {
                                var name = $(el).attr("name");
                                var value = $(el).val();

                                formData.append(name, value);
                            });
                    });

                    this.on("success", function (data, response) {
                        self.createAgreementComplete(response);
                    });

                    var errorTimeout;

                    this.on("error", function (file, error) {
                        if (typeof (error) === "string") {
                            //error is a max size/no files error
                            //this occurs before posting so no need to store any error info
                            app.showError(translate("agreementdialog.AddFilesError"), error);
                            self.dzClosure.removeFile(file);
                        } else {
                            //error is an error object from the APi call
                            self.uploadError = error;

                            // Set every failed file to status queued since this exception is due to other problems.
                            file.status = Dropzone.QUEUED;

                            // Added timeout function to prevent error from beeing shown multiple times
                            if (errorTimeout)
                                clearTimeout(errorTimeout);

                            errorTimeout = setTimeout(function () {
                                self.onError();
                            }, 500);
                        }
                    });
                    const checkFileLimitAndUpdateNoOfFiles = function () {
                        //when a file is added using dialog, it gets queued directly
                        var files = self.dzClosure.getQueuedFiles();
                        //when a file is drag'n'dropped, files are added to rejected files
                        //later on they are moved to the queued files but this happens in the background
                        var rejectedFiles = self.dzClosure.getRejectedFiles();
                        var noOfExistingFiles = getNumberOfExistingFiles();
                        var totalFiles = noOfExistingFiles + files.length + rejectedFiles.length;
                        // console.log("addedfile:" + files.length + " noOfExistingFiles:" + noOfExistingFiles + " totalFiles:" + totalFiles + " acceptedFiles:" + self.dzClosure.getAcceptedFiles().length + " rejectedFiles:" + rejectedFiles.length + " uploading files:" + self.dzClosure.getUploadingFiles().length);

                        if (totalFiles > 3) {

                            //on drag'n'drop, addfile are invoked for each file and no "completed" event is called.
                            //need to show the error message on the last call
                            //if we queued a timeout, clear it first, then add it again.
                            if (self.errorMsgTimeout) {
                                clearTimeout(self.errorMsgTimeout);
                            }
                            //a small timeout should be sufficient (100ms)
                            self.errorMsgTimeout = setTimeout(function () {
                                app.showError(translate("agreementdialog.AddFilesError"), null);
                                self.errorMsgTimeout = null;
                            }, 100);

                            if (rejectedFiles.length) {
                                var rejectedFilesToKeep = Math.max(0, 3 - noOfExistingFiles - files.length);
                                for (var i = rejectedFiles.length - 1; i >= rejectedFilesToKeep; i--) {
                                    self.dzClosure.removeFile(rejectedFiles[i]);
                                }
                            }
                            for (var i = 3 - noOfExistingFiles; i < files.length; i++) {
                                self.dzClosure.removeFile(files[i]);
                            }
                            totalFiles = 3;
                        }
                        //keep this attr up to date to keep UI in sync
                        $(".drop-files").attr("data-number-of-files", totalFiles);
                    };
                    this.on("addedfile", function () {
                        // console.log("addedfile")
                        checkFileLimitAndUpdateNoOfFiles();
                    })
                    this.on("addedfiles", function () {
                        // console.log("addedfiles")
                        checkFileLimitAndUpdateNoOfFiles();
                    });
                    this.on("removedfile", function () {
                        // console.log("removedfile")
                        checkFileLimitAndUpdateNoOfFiles();
                    });
                }
            });

        // Search agreements
        $(".delete-agreement-file", this.$domobject).unbind("click").bind("click", function (e) {
            var agreementFileId = $(e.currentTarget).data("agreement-file-id");

            var header = translate("agreementdialog.ConfirmDeleteFileHeader");
            var message = translate("agreementdialog.ConfirmDeleteFileMessage");

            // Confirm dialog
            var confirm = new ImageVaultUi.ConfirmDialog({
                templateValues: {
                    confirmHeader: header,
                    confirmMessage: message
                }
            });

            var deleteAgreementFilePath = app.createPath("Agreement", "DeleteAgreementFile");

            confirm.open(function () {
                // Handle result
                switch (confirm.result) {
                    case ImageVaultUi.ConfirmDialog.results.Ok:
                        app.load({
                            url: deleteAgreementFilePath,
                            data: {
                                "agreementFileId": agreementFileId,
                                "agreementId": self.config.agreementId
                            },
                            type: "POST",
                            success: function () {
                                app.trigger("agreementdialog:AgreementFileDeleted", agreementFileId);
                                var notif = new IVNotification(translate("agreementdialog.DeleteFileSuccess"),
                                    {
                                        duration: 2000
                                    });
                                $(e.currentTarget).closest(".existing-file").remove();
                            },
                            error: function (error) {
                                app.showError(translate("agreementdialog.DeleteError"), error);
                            }
                        });
                        break;
                    case ImageVaultUi.ConfirmDialog.results.Cancel:
                        break;
                }
            });

            return false;
        });
    };

    agreementDialog.prototype.onError = function (data) {
        //error can either occur from the upload function
        let error = this.uploadError;
        this.uploadError = null;
        //or the response itself
        if (!error) {
            if (data.responseText) {
                error = JSON.parse(data.responseText);
            }
        }
        if (error) {
            let message = "";
            let detailedMessage = "";
            let superDetailedMessage = "";
            let errorType = error.message;
            //translate message
            var details = { exception: error };
            ImageVaultUi.ErrorUtil.translateErrorDetails(details);
            error = details.exception;
            if (error.properties?.details) {
                superDetailedMessage = error.properties?.details;
            }

            switch (errorType) {
                case ImageVaultUi.ImageVaultErrorMessage.AgreementSaveError:
                    message = translate("agreementdialog.SaveUnSuccess");
                    break;
                case ImageVaultUi.ImageVaultErrorMessage.FileTypeValidationError:
                default:
                    message = error.message;
                    detailedMessage = superDetailedMessage;
                    superDetailedMessage = null;
            }
            // build message with details
            if (detailedMessage && superDetailedMessage) {
                detailedMessage += "\n" + superDetailedMessage;
            }
            app.showError(message, detailedMessage);
        }
    };

    agreementDialog.prototype.createAgreementComplete = function (data) {
        //This method is called once for each file that is uploaded, so we need to check if we already signalled that we are done
        if (this.completed) return;
        this.completed = true;
        // console.log("createAgreementComplete", JSON.stringify(data))
        app.trigger("agreementDialog:agreementSaved", data);
        app.trigger(ImageVaultUi.NavigationEvents.agreementDialogClosed);
        this.close();
        var notif = new IVNotification(translate("agreementdialog.SaveSuccess"),
            {
                duration: 2000
            });
    };

    ns.AgreementDialog = agreementDialog;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});