﻿(function($, ns, undefined) {
	var collectionDialog = function (config) {
        var self = this;
        this.collectionId = config.collectionId;
	    self.collectionId = config.collectionId;
        config.dialogSize = "small thin";
	    config.dialogClass = "share-dialog";
	    config.hideHrBeforeActions = true;

        config.loadControllerPath = "collection/CreateOrEdit";
        if (config.collectionId) {
            config.loadControllerData = { collectionId: config.collectionId };
        }

	    config.actions = {
	        ok: {
	            text: translate("vaultdialog.Save"),
	            action: function() {
	                $('#collection-form').submit();
	            },
	            cssClass: "submit-action",
	            disabled: config.collectionId ? false : true
	        },
	        cancel: {
	            text: translate("common.Cancel"),
	            action: function() {
                    self.close();
	            },
	            noButton: true,
	            cssClass: "cancel-action"
	        },
            closeWindow: {
                text: translate("sharedialog.CloseThisWindow"),
                action: function() {
                    self.close();
                },
                cssClass: "cancel-action",
                hidden: true
            },
            delete: {
                text: translate("common.Delete"),
                action: function() {
                    // Confirm dialog
                    var collectionId = config.collectionId;
                    var header = translate("collectiondialog.ConfirmHeader");
                    var message = translate("collectiondialog.ConfirmMessage");

                    var confirm = new ImageVaultUi.ConfirmDialog({
                        templateValues: {
                            confirmHeader: header,
                            confirmMessage: message
                        }
                    });

                    confirm.open(function() {
                        // Handle result
                        switch (confirm.result) {
                        case ImageVaultUi.ConfirmDialog.results.Ok:
                            app.load({
                                url: "Collection/Delete",
                                data: {"collectionId": collectionId},
                                type: 'POST',
                                success: function(data) {
                                    app.trigger("collectionDialog:collectionDeleted", collectionId);
                                    var notif = new IVNotification(translate("collectiondialog.DeleteSuccess"),
                                    {
                                        duration: 2000
                                    });
                                    self.close();
                                },
                                error: function(error) {
                                    app.showError(translate("collectiondialog.DeleteError"), error);
                                    self.close();
                                }
                            });
                                break;
                            case ImageVaultUi.ConfirmDialog.results.Cancel:
                                break;
                        }
                    });
                },
                cssClass: "delete-action",
                hidden: config.collectionId ? false : true
            }
	    };

		this.init(config);
		return this;
	};

    //setup inheritance
	collectionDialog.prototype = new ImageVaultUi.Dialog;
	collectionDialog.constructor = collectionDialog;
	collectionDialog.prototype.base = ImageVaultUi.Dialog.prototype;

    collectionDialog.prototype.onLoad = function($dialog) {
        var self = this;
        $("#CollectionName", this.$dialog).focus();

        $("#CollectionName", this.$dialog).bind("change keyup paste", function(e) {
           if ($(e.currentTarget).val()) {
               $(".actions .submit-action", this.$dialog).removeClass("disabled");
           } else {
               $(".actions .submit-action", this.$dialog).addClass("disabled");
           }
        });
    };

    collectionDialog.prototype.onError = function(data) {
        try {
            alert(this.saveErrorMsg + "\n" + data.responseText.substr(data.responseText.indexOf('</html>') + 7));
        } catch (err) {
            alert(this.saveErrorMsg);
        }
    };

    collectionDialog.prototype.createCollectionComplete = function(data, updating) {
        var id = data.id;

        if (updating) {
            app.trigger("collectionDialog:collectionUpdated", id);
        } else {
            app.trigger("collectionDialog:collectionCreated", id);
        }

        app.trigger("collectionDialog:collectionSaved", id);

        this.close();
        var notif = new IVNotification(translate("collectiondialog.SaveSuccess"),
        {
            duration: 2000
        });
    };

    ns.CollectionDialog = collectionDialog;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});
