﻿(function ($, ns) {
    var deleteDialog = function (config) {
        this.init(config);
        return this;
    };

    //static method to open the vault dialog
    deleteDialog.OpenDialog = function (mediaItemIds) {
        var loading = new IVNotification(translate("common.Loading"), { showOverlay: true });
        app.load({
            url: "Library/ShowDeleteDialog",
            data: { mediaItemIds: mediaItemIds },
            success: function (data) {
                loading.remove();
                $("body").append(data);

               // $("#delete-dialog").center(false);
            },
            error: function (error) {
                loading.remove();
                app.showError("Error opening delete dialog", error);
            }
        });
    };

    deleteDialog.prototype = {
        mediaItemIds: [],
        init: function (config) {

            $.extend(this, config);
            var self = this;

            $("#delete-dialog .dialog-footer .delete").click(function () {
                self.deleteFiles($(this));
                return false;
            });

            $("#delete-dialog .dialog-footer .cancel, #delete-dialog .close").click(function () {
                self.closeDialog();
                return false;
            });

            // Remove file from selection
            $(".delete-from-selection").click(function () {

                var mediaItemId = $(this).attr("data-item-id");

                $("#stream li[data-item-id=" + mediaItemId + "]").removeClass("selected");

                app.trigger("deleteDialog:itemsRemoved", [mediaItemId]);

                $(this).closest("li").remove();

                self.mediaItemIds.splice(self.mediaItemIds.indexOf(mediaItemId), 1);

                return false;
            });
        },
        closeDialog: function () {
            $(".dialog").remove();
            $(".overlay").fadeOut("fast", function () {
                $(this).remove();
            });
        },
        deleteFiles: function ($deleteButton) {
            var self = this;

            app.load({
                url: "Library/Delete",
                data: { mediaItemIds: self.mediaItemIds },
                dataType: "JSON",
                success: function () {
                    $.bbq.removeState("items");
                    self.closeDialog();

                    for (var i = 0; i < self.mediaItemIds.length; i++) {
                        $("#stream li[data-item-id=" + self.mediaItemIds[i] + "]").remove();
                    }
                    app.trigger("deleteDialog:fileDeleted", self.mediaItemIds);
                },
                $buttonsToDisable: $deleteButton
            });
        },
        deleteFromCollection: function(collectionId, mediaItemIds) {
            app.load({
                url: "Collection/RemoveFromCollection",
                type: "POST",
                data: { collectionId: collectionId, mediaItemIds: mediaItemIds },
                success: function () {
                    $.bbq.removeState("items");
                    //self.closeDialog();

                    for (var i = 0; i < mediaItemIds.length; i++) {
                        $("#stream li[data-item-id=" + mediaItemIds[i] + "]").remove();
                    }

                    var notiMessage = mediaItemIds.length > 1
                        ? translate("collectiondialog.DeleteFromCollectionMultiSuccess")
                        : translate("collectiondialog.DeleteFromCollectionSingleSuccess");

                    var notif = new IVNotification(translate(notiMessage),
                    {
                        duration: 2000
                    });
                    app.trigger("collectionDialog:removedFromCollection", { collectionId: collectionId, mediaItemIds: mediaItemIds });
                }
            });
        }
    };
    ns.DeleteDialog = deleteDialog;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});


