﻿(function($, ns) {
    var externalLinkDialog = function(config) {
        var self = this;
        externalLinkDialog.current = this;
        config.dialogSize = config.externalLinkModel.dialogClass || "large";
        config.dialogClass = "external-link-dialog";
        config.hideHrBeforeActions = true;
        config.$container = $(".step-content-place-holder");

        self.publishedMedia = null;
        self.requirePublishDetails = false;

        // Call action method to get dialog html
        config.loadControllerPath = "media-externallink";
        config.loadControllerData = {
            externalLinkModel: config.externalLinkModel
        };

        // Show external link dialog
        $(".step-content-place-holder").show();

        // Possible actions 
        config.actions = {
            // Area for publish details inputs
            publishDetailArea: {
                htmlText: $("<div class=\"publish-details-wrapper\"><form id=\"publishDetailForm\">" +
                    "<input type=\"text\" name=\"publishDetailText\" placeholder=\"" + translate("externallink.PublishDetailText") + "\" class=\"publish-details-input publish-details-text\"><div class=\"publish-details-between-text\">" +
                    translate("externallink.AndOr") +
                    "</div><input type=\"text\" name=\"publishDetailLink\" placeholder=\"" + translate("externallink.PublishDetailLink") + "\" class=\"publish-details-input publish-details-url\">" +
                    "<input type=\"submit\" style=\"display: none;\" /></form></div>")
            },
            cancel: {
                text: translate("sharedialog.CloseThisWindow"),
                action: function() {
                    self.close();

                    // Close edit window
                    $.fancybox.close();
                },
                noButton: true,
                cssClass: "cancel-action"
            },
            copyLink: {
                text: translate("externallink.CopyLink"),
                action: function() {},
                cssClass: "copy-link-action ok-action copy-action",
                hidden: false
            },
            copyEmbedCode: {
                text: translate("externallink.CopyEmbedCode"),
                action: function() {},
                cssClass: "copy-embed-code-action ok-action copy-action",
                hidden: false
            },
            ...config.actions
        };

        if (config.excludeActions) {
            config.excludeActions.forEach(action => {
                if (config.actions[action]) {
                    delete config.actions[action]
                }
            })
        }

        // Add back button if fancy-box is visible with "step-content-place-holder"
        if ($(".step-content-place-holder").length !== 0) {
            config.actions["back"] = {
                text: "<i class='fa fa-angle-left'></i> " + translate("externallink.Back"),
                action: function() {
                    // Close this window
                    $(".step-content-place-holder").hide();
                },
                cssClass: "back-button",
                noButton: true
            };
        }

        this.config = config;
        this.init(config);

        return this;
    };

    //setup inheritance
    externalLinkDialog.prototype = new ImageVaultUi.Dialog;
    externalLinkDialog.constructor = externalLinkDialog;
    externalLinkDialog.prototype.base = ImageVaultUi.Dialog.prototype;

    externalLinkDialog.prototype.getPublishedMedia = function(callback) {
        var self = this;

        // If publish details i required validate fields first
        if (self.requirePublishDetails) {
            $("#publishDetailForm").find(":submit").click();

            // Validate text fields for file usage
            if (!$(".publish-details-text")[0].checkValidity() || !$(".publish-details-url")[0].checkValidity()) {
                callback(false);
                return;
            }
        }

        app.json({
            url: "media-get-externallink",
            method: "POST",
            data: {
                MediaItemId: self.config.externalLinkModel.MediaId,
                MediaFormatId: self.config.externalLinkModel.MediaFormatId,
                Url: $(".publish-details-url").val(),
                Text: $(".publish-details-text").val()
            },
            success: function(x) {

                // Values for copy
                var urlToCopy = x.link;
                var embedCodeToCopy = x.embedCode;

                // Colorize embed code
                var coloredEmbedCode =
                    ImageVaultUi.Common.colorEncodeHtml(ImageVaultUi.Common.htmlEncode(embedCodeToCopy));

                // Set html in link and embed code dialog
                $(".external-link").html(urlToCopy);
                $(".external-link-embed-code").html(coloredEmbedCode);
                $(".copy-link-input").val(urlToCopy);
                $(".copy-embed-code-input").val(embedCodeToCopy);
                $("a[data-action-name='copy-text']").click(function() {
                    var copyLink = $(this).data("copy-text-class") === "copy-link-input";
                    self.copyLinkOrEmbed(copyLink);
                    self.updateLibraryAndInfoPanel();
                    return false;
                });
                
                self.updateLibraryAndInfoPanel();
                callback(true);
                return;
            },
            error: function (e) {
                alert("error retrieving link and embed code " + e);
                callback(false);
            }
        });

    };

    externalLinkDialog.prototype.updateLibraryAndInfoPanel = function() {
        // Update library information
        var $selectedListItem = $("#stream li.selected");
        var id = $selectedListItem.attr("data-item-id");

        var infoPanel = new ImageVaultUi.InfoPanel({ $domobject: $("#details") });

        //update info panel
        infoPanel.show(id);
    };

    externalLinkDialog.prototype.copyLinkOrEmbed = function(copyLink) {
        var $chosenInputToCopy = copyLink ? $(".copy-link-input") : $(".copy-embed-code-input");

        // Link or embed code depending on which button is clicked
        var chosenTextToCopy = copyLink ? "external-link" : "external-link-embed-code";

        // Perform copy to clipboard
        $chosenInputToCopy[0].select();

        if ($chosenInputToCopy.val() === "") {

            // Could not copy, do it manually
            self.toggleLinkAndEmbedCode(true);

            // Add text for temporary problem (If Api call took more than 1 sek)
            $(".external-link-and-embed-code").prepend($("<strong class=\"text-was-not-copied-to-clipboard\">" + translate("externallink.TextWasNotCopiedToClipboard") + "<br/><br/></strong>"));

            // Select text to copy (timeout to make sure link and embed code is shown before selecting text)
            setTimeout(function() {
                ImageVaultUi.Common.selectTextByClassName(chosenTextToCopy);
            }, 1000);

            return false;
        }

        try {
            // copy text
            var successful = document.execCommand("copy");

            if (successful) {
                // Show successful message
                ImageVaultUi.Common.showMessage(translate("externallink.TextWasCopiedToClipboard"));

                // Remove error text
                $(".text-was-not-copied-to-clipboard").remove();
                return false;

            }
            // Could not copy, do it manually
            self.toggleLinkAndEmbedCode(true);

            // Select text to copy (timeout to make sure link and embed code is shown before selecting text)
            setTimeout(function() {
                ImageVaultUi.Common.selectTextByClassName(chosenTextToCopy);
            }, 300);
            return false;


        } catch (err) {
            $(".link-text").click();
        }
        return false;
    };
    // Get published image and copy link or embed code
    externalLinkDialog.prototype.copyButtonClicked = function($clickedLink) {
        var self = this;

        self.getPublishedMedia(function(success) {
            if (!success) return;

            var copyLink = $clickedLink.hasClass("copy-link-action");
            if (self.copyLinkOrEmbed(copyLink)) {
                // Hide embed code
                self.toggleLinkAndEmbedCode(false);
            }
        });
    };


    // When dialog has loaded
    externalLinkDialog.prototype.onLoad = function() {
        var self = this;

        // Click event for copy buttons
        $(".copy-action").click(function() {
            self.copyButtonClicked($(this));
            return false;
        });

        self.requirePublishDetails = JSON.parse(self.config.externalLinkModel.RequirePublishDetails);

        // Set HTML 5 validation
        if (self.requirePublishDetails) {

            var textInput = $(".publish-details-text")[0];
            var urlInput = $(".publish-details-url")[0];

            var textValidationMessage = translate("externallink.PublishDetailValidationMessage");
            var urlValidationMessage = translate("externallink.PublishDetailValidationMessage");

            // Set custom validation at initiation
            textInput.setCustomValidity(textValidationMessage);
            urlInput.setCustomValidity(urlValidationMessage);

            // When user writes in input, check if any of inputs has value else add custom validation
            var $inputs = $("input[name=publishDetailLink],input[name=publishDetailText]");
            $inputs.bind("input",
                function() {
                    // Reset custom validation at key down (input)
                    textInput.setCustomValidity("");
                    urlInput.setCustomValidity("");

                    var textInputValue = $(".publish-details-text").val();
                    var urlInputValue = $(".publish-details-url").val();
                  
                    if (textInputValue === "" && urlInputValue === "") {
                        textInput.setCustomValidity(translate("externallink.PublishDetailValidationMessage"));
                    } else if (urlInputValue !== "" && !window.ImageVaultUi.Common.isValidUrl(urlInputValue)) {
                        urlInput.setCustomValidity(translate("externallink.PublishDetailUrlValidationMessage"));
                    }
                });

            // Do not submit form on submit
            $("#publishDetailForm").bind("submit",
                function() {
                    return false;
            });
        }
 

        // Show loader
        $(".load-media").show();

        // Append dialog
        $(".step-content-place-holder").append($(".external-link-dialog"));

        // Close on escape key
        $(document).bind('keydown.fb',
            function(e) {
                if (e.keyCode === 27) {
                    e.preventDefault();
                    $(".cancel-action").click();
                }
            });

        var previewVideo = $(".external-link-preview-image video");
        var previewImage = $(".external-link-preview-image img");

        if (previewImage.length) {
            // Hide image until loaded
            $(".external-link-preview-image img").css("visibility", "hidden");

            $(".external-link-preview-image img").bind("load",
                function() {

                    $(".load-media").hide();
                    $(".external-link-preview-image img").css({
                        "width": "auto",
                        "height": "auto",
                        "visibility": "visible"
                    });
                });
        }
        // When video has loaded
        else if (previewVideo.length) {
            $(".external-link-preview-image video").bind("loadeddata",
                function() {
                    $(".load-media").hide();
                    $(".external-link-preview-image img").css({
                        "width": "auto",
                        "height": "auto",
                        "visibility": "visible"
                    });
                });

            // If Video or image not loaded in 10 seconds remove loader
            // TODO: Find out why loadeddata not triggers sometime
            setTimeout(function() {
                    $(".load-media").hide();
                },
                10000);
        } else {
            $(".load-media").hide();
        }

        // Event for toggle link and embed code
        $(".toggle-link-and-embed-code").click(function() {
            self.toggleLinkAndEmbedCode();

            return false;
        });
    };

    // Show or hide link and embed code
    externalLinkDialog.prototype.toggleLinkAndEmbedCode = function(show) {
        var self = this;
        var $toggleLink = $(".toggle-link-and-embed-code");
        var $toggleLinkText = $(".toggle-link-and-embed-code .link-text");

        if (show === true) {
            self.getPublishedMedia(function(success) {
                if (!success) return;
                $toggleLinkText.text($toggleLink.data("hide-text"));
                $(".external-link-and-embed-code").show();
            });

        } else if (show === false) {
            $(".external-link-and-embed-code").hide();
            $toggleLinkText.text($toggleLink.data("show-text"));
        } else {
            self.getPublishedMedia(function(success) {
                if (!success) return;
                $(".external-link-and-embed-code").toggle();

                if ($(".external-link-and-embed-code").is(":visible")) {
                    $toggleLinkText.text($toggleLink.data("hide-text"));
                } else {
                    $toggleLinkText.text($toggleLink.data("show-text"));
                }
            });
        }
    };

    ns.ExternalLinkDialog = externalLinkDialog;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});