﻿(function($, ns) {

	var importView = function(config) {
		this.init(config);
		return this;
	};
	importView.prototype = {
		destinationControl:null,
		vaultsControl:null,
		init:function (config) {
			$.extend(this, config);

			if (document.location.href.indexOf("device") > -1) {
				$("body").addClass("touchDevice");
			}
			var self = this;
			app.bind("vaultDialog:vaultDeleted", this.vaultDeleted, this);
			app.bind("vaultDialog:vaultSaved", this.vaultSaved, this);

			//locate components
			this.destinationControl = $('#import-dest');
			this.vaultsControl = $("#import-vaults");
			//hookup events
			//toggle destination list
			this.destinationControl.click(function(e) { self.destinationClicked(e); });
			//destination select events...
			$('#import-vaults li a:not(.edit)').live('click', function () {
				if ($(this).hasClass('inactive')) {
					return false;
				}
				var name = $(this).find('span.title').text();
				var vaultId = $(this).attr('data-vault-id');
				self.setDestination(name, vaultId);
				return false;
			});
			//edit buttons
			this.vaultsControl.find("li a.edit").live('click', function (e) {
    			self.editVault($(this).attr('data-vault-id'));
				e.stopPropagation();
				return false;
			});
			//create button
			this.vaultsControl.find("a.create").live('click',function (e) {
    			self.editVault(-1);
				e.stopPropagation();
				return false;
			});
			

		},
		//Opens the edit vault dialog
		editVault: function(vaultId) {
	    	ImageVaultUi.VaultDialog.OpenDialog(vaultId);
		},
		//callback method for when a vault is edited (Saved/created)
		//vault is the Vault json object that was edited
		vaultSaved:function(vault) {
			//reload vault list
			var self = this;
			this.reloadVaultList(function() {
				//make the saved vault the selected one.
				self.selectVaultByIdOrDefault(vault.Id);
			});
		},
		//callback method for when a vault was deleted...
		//gives the id of the vault that was deleted
		vaultDeleted:function(vaultId) {
			//reload vault list
			var self = this;
			var previousVaultId = -1;
			
			//find the previous vault in the list
			var currentSelectedLi = this.getVaultListItemByVaultId(vaultId);
			if(currentSelectedLi) {
				var prevLi = currentSelectedLi.prev();
				if(prevLi) {
					previousVaultId = prevLi.find("a").attr("data-vault-id");
				}
			}
			this.reloadVaultList(function() {
				self.selectVaultByIdOrDefault(previousVaultId);
			});
		},
		//reloads the vault list and then calls the callback function
		reloadVaultList:function(callback) {
			var self = this;
			app.load({
				controller: 'Import',
				action:"RefreshVaultList",
				success: function (data) {
					//update vault list
					self.vaultsControl.html(data);
					if(callback)
						callback();
				}
			});
		},
		//Gets the list item for the vault with the given id
		getVaultListItemByVaultId:function(vaultId) {
			return this.vaultsControl.find("a[data-vault-id='" + vaultId + "']").parent("li");
		},
		//Will try to make the supplied vault the selected one if it is present in the list. 
		//If not it selects the first vault in the list
		selectVaultByIdOrDefault:function(vaultId) {
			var li;
			//make sure that the vault exists
			if(vaultId>0) {
				li = this.getVaultListItemByVaultId(vaultId);
			}
			//unless, select the first item
			if(!li) {
				li = this.vaultsControl.find("li").first();
			}
			//if we find an item
			if(li) {
				var name = li.find("span.title").text();
				var id = li.find("a").first().attr("data-vault-id");
				this.setDestination(name, id);
			}
			
		},
		//Sets the destination description and value
		setDestination:function(name, vaultId) {
			$('span.dest').text(name);
			$('span.dest').attr('data-vault-id', vaultId);
			document.querySelector("papirfly-queue-upload").setAttribute("data-upload-parameter-vaultid", vaultId);
		},
		//function that handles when the destination box is clicked
		destinationClicked : function (e) {
			var self = this;
			//if inactive, skip processing
			if (self.destinationControl.hasClass('inactive')) {
	            return false;
		    }
			e.stopPropagation();

			//close if it is open
			if (self.destinationControl.hasClass('active')) {
				self.destinationControl.removeClass('active');
				self.vaultsControl.fadeOut('fast', function () {
					$(this).hide();
				});
				$('html').unbind('click');
				return false;
			}
			//show it 
			self.destinationControl.addClass('active');
			self.vaultsControl.show();
			$('html').click(function () {
				self.destinationControl.removeClass('active');
				self.vaultsControl.fadeOut('fast', function () {
					$(this).hide();
				});
			});
			return false;
		}
	};
	//export to namespace
	ns.ImportView = importView;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi|| { });