﻿(function($, ns, undefined) {
    var publishesDialog = function(config) {
        var self = this;
        //fill in with some default configurations
        config.dialogSize = "medium";
        config.dialogClass = "list-publishes-dialog";
        config.loadControllerPath = "publish/listpublishes";
        config.loadControllerData = publishesDialog.currentOptions;
        config.loadControllerData.mediaItemId = config.mediaItemId;

        config.actions = {
            cancel: {
                text: translate("common.Close"),
                action: function() {
                    //Reset the default options before leaving.
                    publishesDialog.currentOptions.sortField = publishesDialog.sortFieldOption.PublishingSource;
                    publishesDialog.currentOptions.sortDirection = publishesDialog.sortDirectionOption.Descending;
                    publishesDialog.currentOptions.searchString = "";
                    self.close();
                },
                cssClass: "cancel-action"
            }
        };
        this.init(config);
        return this;
    };

    // Enumeration: Sortable fields
    publishesDialog.sortFieldOption = {
        PublishingSource: 1,
        TextAndLink: 2,
        Link: 3,
        Format: 4,
        Size: 5,
        Date: 6,
        User: 7
    };

    // Enumeration: Sort direction
    publishesDialog.sortDirectionOption = {
        Descending: 0,
        Ascending: 1
    };

    // Current options
    publishesDialog.currentOptions = {
        mediaItemId: 0,
        sortField: publishesDialog.sortFieldOption.PublishingSource,
        sortDirection: publishesDialog.sortDirectionOption.Descending,
        searchString: ""
    };

    //setup inheritance
    publishesDialog.prototype = new ImageVaultUi.Dialog;
    publishesDialog.constructor = publishesDialog;
    publishesDialog.prototype.base = ImageVaultUi.Dialog.prototype;

    //Performs a search
    publishesDialog.prototype._performSearch = function() {
        publishesDialog.currentOptions.searchString = $("input.search-text").val();
        this.reload();
    };

    publishesDialog.prototype.onLoad = function($dialog) {
        var self = this;

        publishesDialog.currentOptions.mediaItemId = self.mediaItemId;

        $('#publishes-table span[data-toggle="tooltip"]').tooltip();

        self.isPublished = MeridiumUtil.parseBool($("#list-publishes-header").attr("data-is-published"));
        //make sure that each thumbnail handles any temporary errors
        $("img", $dialog).each(function() {
            ImageVaultUi.ThumbnailUtil.handleError($(this));
        });

        // Handlers for header fields, managing column sorting
        $("th.sortable", $dialog).click(function() {
            if ($(this).hasClass("date-column")) {
                self._prepareSort(publishesDialog.sortFieldOption.Date,
                    publishesDialog.sortDirectionOption.Descending);
            }
            if ($(this).hasClass("text-column")) {
                self._prepareSort(publishesDialog.sortFieldOption.PublishingSource,
                    publishesDialog.sortDirectionOption.Ascending);
            }
            if ($(this).hasClass("link-column")) {
                self._prepareSort(publishesDialog.sortFieldOption.TextAndLink,
                    publishesDialog.sortDirectionOption.Ascending);
            }

            if ($(this).hasClass("format-column")) {
                self._prepareSort(publishesDialog.sortFieldOption.Format,
                    publishesDialog.sortDirectionOption.Ascending);
            }

            if ($(this).hasClass("user-column")) {
                self._prepareSort(publishesDialog.sortFieldOption.User,
                    publishesDialog.sortDirectionOption.Ascending);
            }

            if ($(this).hasClass("size-column")) {
                self._prepareSort(publishesDialog.sortFieldOption.Size,
                    publishesDialog.sortDirectionOption.Ascending);
            }
            self.reload();
            return false;
        });

        //Handlers for managing search
        $("a.search-button")
            .bind("click",
                function() {
                    self._performSearch();
                    return false;
                });

        //Set current search string
        $("input.search-text").val(publishesDialog.currentOptions.searchString);

        // Event for group publish details button
        $(".toggle-publish-details-group-link").bind("click",
            function() {
                var groupId = $(this).closest("tr.product-details-group-row").data("group-id");

                var $linkElement = $(this);
                var $linkTextElement = $linkElement.find(".toggle-publish-details-group-text");

                $("tr.group-" + groupId).toggleClass("active");

                if ($("tr.group-" + groupId).eq(0).css("display") !== "none") {
                    $linkTextElement.html($linkElement.attr("data-hide-group-link-text"));
                } else {
                    $linkTextElement.html($linkElement.attr("data-show-group-link-text"));
                }
                return false;
            });
    };

    publishesDialog.prototype._prepareSort = function(field, defaultDir) {
        if (this.loadControllerData.sortField === field) {
            this.loadControllerData.sortDirection = (this.loadControllerData.sortDirection + 1) % 2;
        } else {
            this.loadControllerData.sortField = field;
            this.loadControllerData.sortDirection = defaultDir;
        }
    };


    ns.PublishesDialog = publishesDialog;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});