﻿(function ($, ns) {
    var scope = function (config) {
        this.init(config);
        return this;
    };
    scope.prototype = {
        test: null,
        init: function (config) {
            var self = this;
            //Event on hash change
            $(window).bind("hashchange", function () {
                self.initScope();
            });
            //Trigger hashchange event on load.
            $(window).trigger("hashchange");
            //Event for removing filter
            $("#scope a.remove").live("click", function () {
                self.removeFilter($(this).closest("li"));
                $("details").removeAttr("open");
                return false;
            });
            $("#scope a.remove-all").live("click", function () {
                $.bbq.removeState("categories");
                $.bbq.removeState("vaults");
                $.bbq.removeState("collections");
                $.bbq.removeState("agreements");
                $.bbq.removeState("search");

                $.bbq.removeState("mediaTypeGroups");
                $.bbq.removeState("mediaSizeGroups");
                $.bbq.removeState("mediaOrientations");
                $.bbq.removeState("mediaMetadataOptions");
                $.bbq.removeState(ImageVaultUi.NavigationEvents.hash.consentStatusFilter);
                $.bbq.removeState(ImageVaultUi.NavigationEvents.hash.isPublishedFilter);
                $.bbq.removeState(ImageVaultUi.NavigationEvents.hash.consentUserId)

                $(".search-filter-tag").remove();
                $("details").removeAttr("open");
                return false;
            });

            app.bind("navAgreementTab:agreementsListLoaded", this.updateAgreements, this);
        },
        initScope: function () {
            var self = this;
            self.updateLocation($.bbq.getState("vaults"), $.bbq.getState("collections"), $.bbq.getState("agreements"));
            self.updateCategories($.bbq.getState("categories"));
            self.updateCollections($.bbq.getState("collections"));
            self.updateVaults($.bbq.getState("vaults"));
            self.updateAgreements();
            self.updateConsentFilter();
            self.updateIsPublishedFilter();

            self.updateFilter("search");

            self.updateFilter("mediaTypeGroups");
            self.updateFilter("mediaSizeGroups");
            self.updateFilter("mediaOrientations");
            self.updateMediaMetadataOptions($.bbq.getState("mediaMetadataOptions"));

            // Don't show scope bar if nothing is in it
            if ($("#scope ul li").length === 0) {
                $("#scope").addClass("hidden");
            } else {
                $("#scope").removeClass("hidden");
            }

            if ($("#scope ul li").length > 1 && $("#scope a.remove-all").length == 0) {
                $("#scope-clear-anchor").tmpl().appendTo($("#scope"));
            }
            if ($("#scope ul li").length <= 1) {
                $("#scope a.remove-all").remove();
            }

            // Clear search term
            $(".clear-button").click(function (e) {
                self.removeFilterByType("search", "");
                $(".search.search-filter-tag").remove();
                $(".query").val("");
                return false;
            });
        },
        updateLocation: function (vaultId, collectionId, agreementId) {
            //Update current location (vault, collection etc)
            var location;
            var currentTab = $.bbq.getState("tab");

            if (currentTab === ImageVaultUi.NavigationEvents.tabs.agreement) {
                location = $("#agreements a[data-agreement-id=" + agreementId + "]").text();
            } else if (vaultId) {
                location = $("#vaults a[data-vault-id=" + vaultId + "]").text();
            } else {
                location = $("#collections a[data-collection-id=" + collectionId + "]").text();
            }
            $("#scope h1").html(location);
        },
        updateCategories: function (categoriesAsString) {
            var $categoryCounter = $("#nav-tabs .categories .count");
            //Rebuild list of categories in current scope
            //Remove current
            $("#scope ul li[data-type=categories]").remove();
            if (typeof categoriesAsString === "undefined" || categoriesAsString.length === 0) {

                $categoryCounter.removeClass("has-selected");
                return;
            }

            var categories = categoriesAsString.split(",");
            $categoryCounter.addClass("has-selected");
            $categoryCounter.html(categories.length);

            //If scope is empty create new list
            if ($('#scope ul').length === 0) {
                $('#scope').append('<ul></ul>');
            }

            //Iterate categories from url fragment
            for (var i in categories) {
                //Get category name from list of categories based on id
                var categoryName = $('#categories li[data-category-id="' + categories[i] + '"] > label').text();
                //Add category to scope
                var data = {
                    filter: [
                        {
                            name: categoryName,
                            classname: "categories",
                            value: categories[i]
                        }
                    ]
                };
                $("#scope-template").tmpl(data).appendTo($("#scope ul"));
            }
        },
        updateCollections: function (collectionsAsString) {
            //var $collectionCounter = $("#nav-tabs .collections .count");
            // Rebuild list of collections in current scope
            // Remove current
            $("#scope ul li[data-type=collections]").remove();
            if (typeof collectionsAsString === "undefined" || collectionsAsString.length === 0) {
                return;
            }

            var collections = collectionsAsString.split(",");

            // If scope is empty create a new list
            for (var i in collections) {
                if (collections[i] != "0") {
                    var collectionName = $('#collections li[data-collection-id="' +
                        collections[i] +
                        '"] .checkbox-input-label-text').text();

                    var data = {
                        filter: [
                            {
                                name: collectionName,
                                classname: "collections",
                                value: collections[i]
                            }
                        ]
                    }

                    $("#scope-template").tmpl(data).appendTo("#scope ul");
                }
            }

        },

        updateVaults: function (vaultsAsString) {
            var $vaultCounter = $("#nav-tabs .vaults .count");
            // Rebuild list of vaults in current scope
            //Remove current
            $("#scope ul li[data-type=vaults]").remove();

            var vaults = vaultsAsString ? vaultsAsString.split(",") : [];
            var totalVaultsAndCollections = vaults;

            // Add collections to counter
            var collectionsAsString = $.bbq.getState("collections");

            if (collectionsAsString) {
                totalVaultsAndCollections = totalVaultsAndCollections.concat(collectionsAsString.split(","));
            }

            var totalIdsArray = totalVaultsAndCollections.filter(function (id) {
                return id !== "0";
            });

            if (totalIdsArray.length === 0) {
                $vaultCounter.removeClass("has-selected");
                return;
            } else {
                $vaultCounter.addClass("has-selected");
            }

            $vaultCounter.html(totalIdsArray.length);

            // If scope is empty create a new list
            for (var i in vaults) {
                if (vaults[i] != "0") {
                    var vaultName = $('#vaults li[data-vault-id="' + vaults[i] + '"] .checkbox-input-label-text')
                        .text();

                    var data = {
                        filter: [
                            {
                                name: vaultName,
                                classname: "vaults",
                                value: vaults[i]
                            }
                        ]
                    }

                    $("#scope-template").tmpl(data).appendTo("#scope ul");
                }
            }

        },

        /**
         * Update agreements
         * @returns {} 
         */
        updateAgreements: function () {
            var agreementsAsString = $.bbq.getState("agreements");
            var $agreementCounter = $("#nav-tabs .agreements .count");
            // Rebuild list of agreements in current scope
            // Remove current
            $("#scope ul li[data-type=agreements]").remove();
            if (typeof agreementsAsString === "undefined" || agreementsAsString === "0") {
                $agreementCounter.removeClass("has-selected");
                return;
            }

            var agreements = agreementsAsString.split(",");

            $agreementCounter.addClass("has-selected");

            $agreementCounter.html(agreements.length);

            // If scope is empty create a new list

            for (var i in agreements) {
                if (agreements[i] != "0") {
                    var agreementName = $('#agreements li[data-agreement-id="' + agreements[i] + '"] .checkbox-input-label-text')
                        .text();

                    var data = {
                        filter: [
                            {
                                name: agreementName,
                                classname: "agreements",
                                value: agreements[i]
                            }
                        ]
                    }

                    $("#scope-template").tmpl(data).appendTo("#scope ul");
                }
            }

        },
        updateIsPublishedFilter: function () {
            var isPublishedFilter = $.bbq.getState(ImageVaultUi.NavigationEvents.hash.isPublishedFilter);
            $("#scope ul li[data-type=isPublishedFilter]").remove();
            if (!isPublishedFilter) {
                return;
            }
            var data = {
                filter: [
                    {
                        name: translate("library.IsPublishedFilter"),
                        classname: "isPublishedFilter",
                        value: "true"
                    }
                ]
            }
            $("#scope-template").tmpl(data).appendTo("#scope ul");
        },
        updateConsentFilter: function () {
            var consentStatusFilter = $.bbq.getState(ImageVaultUi.NavigationEvents.hash.consentStatusFilter);
            var isPublishedFilter = $.bbq.getState(ImageVaultUi.NavigationEvents.hash.isPublishedFilter);
            var consentUserId = $.bbq.getState(ImageVaultUi.NavigationEvents.hash.consentUserId);
            var $consentCounter = $("#nav-tabs .consents .count");
            // Rebuild list of agreements in current scope
            // Remove current
            $("#scope ul li[data-type=consentStatusFilter]").remove();
            $("#scope ul li[data-type=consentUserId]").remove();

            if (!consentStatusFilter && !consentUserId) {
                $consentCounter.removeClass("has-selected");
                return;
            }

            $consentCounter.addClass("has-selected");
            //is published belongs as counter on the consent filter tab counter
            $consentCounter.html((consentStatusFilter ? 1 : 0) + (consentUserId ? 1 : 0) + (isPublishedFilter ? 1 : 0));

            var data = {
                filter: []
            }
            if (consentUserId) {
                var consentUserName = $('#consent-users li[data-consent-user-id="' + consentUserId + '"] .name')
                    .text();
                data.filter.push(
                    {
                        name: consentUserName,
                        classname: "consentUserId",
                        value: consentUserId
                    }
                );
            }
            if (consentStatusFilter) {
                data.filter.push(
                    {
                        name: translate("consent.ConsentStatusFilter" + consentStatusFilter),
                        classname: "consentStatusFilter",
                        value: consentStatusFilter
                    }
                );
            }
            $("#scope-template").tmpl(data).appendTo("#scope ul");
        },
        updateFilter: function (type) {
            var values = $.bbq.getState(type);

            var valuesArray = [];

            if (values) {
                valuesArray = type === "search" ? values.indexOf("\"") !== -1 ? [values.replace("\"", "").replace("\"", "")] : values.split(" ") : values.split(",");
            }

            //Remove current
            $("#scope ul li[data-type=" + type + "]").remove();

            for (var i = 0; i < valuesArray.length; i++) {

                // Ignore search all files option
                var translationKey = "library." + valuesArray[i];
                var translatedValue = translate(translationKey);

                // Use translation if there is one in library
                if (translatedValue == translationKey) {

                    // Try translate with type as prefix
                    translationKey = "library." + type + valuesArray[i];
                    translatedValue = translate(translationKey);

                    if (translatedValue == translationKey) {
                        // Try translate with Search as prefix
                        translationKey = "library.Search" + valuesArray[i];
                        translatedValue = translate(translationKey);

                        // If key is still the same use the value as is
                        if (translatedValue == translationKey)
                            translatedValue = valuesArray[i];
                    }
                }

                var data = {
                    filter: [
                        {
                            name: type == "search" ? values : translatedValue,
                            classname: type,
                            value: type == "search" ? values : valuesArray[i]
                        }
                    ]
                }

                //Add filter to scope
                $("#scope-template").tmpl(data).appendTo($("#scope ul"));
                if (type == "search")
                    return;
            }
        },

        updateMediaMetadataOptions: function (mediaMetadataOptionsAsString) {
            $("#scope ul li[data-type=mediaMetadataOptions]").remove();
            if (typeof mediaMetadataOptionsAsString === "undefined" || mediaMetadataOptionsAsString.length === 0) {
                return;
            }

            var mediaMetadataOptions = mediaMetadataOptionsAsString.split(",");

            if ($('#scope ul').length === 0) {
                $('#scope').append('<ul></ul>');
            }

            var searchMetadata = document.getElementsByTagName("search-metadata")[0];

            for (var i in mediaMetadataOptions) {
                var valueArray = mediaMetadataOptions[i].split(':');
                var label = searchMetadata.fieldNames[valueArray[0]];
                var value = valueArray[1];
                if (value.toLowerCase() == "true" || value.toLowerCase() == "false") {
                    value = translate("library.SearchBoolean" + value.toLowerCase());
                }
                var data = {
                    filter: [
                        {
                            name: label + ":" + value,
                            classname: "mediaMetadataOptions",
                            value: mediaMetadataOptions[i]
                        }
                    ]
                };
                $("#scope-template").tmpl(data).appendTo($("#scope ul"));
            }
        },

        removeFilter: function ($li) {
            //Search, category or filter (future).            
            var type = $li.data("type");
            this.removeFilterByType(type, $li.data("value"));

            $li.remove();

            app.trigger("scope:filterRemoved");
        },

        removeFilterByType: function (type, value) {
            // Remove advanced filters of type                        
            var currentState = $.bbq.getState(type);
            if (currentState) {
                var limiter = ",";

                var currentStateValuesArray = currentState.split(limiter);
                currentStateValuesArray.splice(currentStateValuesArray.indexOf(value.toString()), 1);

                $.bbq.removeState(type);

                if (currentStateValuesArray.length) {
                    var state = {};
                    state[type] = currentStateValuesArray.join(limiter);
                    $.bbq.pushState(state);
                }
            }
        }
    };
    ns.Scope = scope;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});