﻿(function ($, ns, undefined) {
    var shareDialog = function (config) {
        var self = this;
        config.dialogSize = "small thin";
        config.dialogClass = "share-dialog";
        config.hideHrBeforeActions = true;

        config.loadControllerPath = "share/new";
        config.loadControllerData = { mediaFormatId: config.mediaFormatId, mediaItemId: config.mediaItemIds };

        config.actions = {
            next: {
                text: translate("common.Next"),
                action: function () {
                    $('#share-form').submit();
                },
                cssClass: "submit-action",
                disabled: true
            },
            cancel: {
                text: translate("common.Cancel"),
                action: function () {
                    self.close();
                },
                noButton: true,
                cssClass: "cancel-action"
            },
            // Actions for step 2, hidden by default
            closeWindow: {
                text: translate("sharedialog.CloseThisWindow"),
                action: function () {
                    self.close();
                },
                cssClass: "close-action",
                hidden: true
            },
            copyLink: {
                text: translate("sharedialog.CopyLink"),
                action: function () { },
                cssClass: "ok-action clipboard-text",
                hidden: true
            }
        };

        this.init(config);
        return this;
    };

    //setup inheritance
    shareDialog.prototype = new ImageVaultUi.Dialog;
    shareDialog.constructor = shareDialog;
    shareDialog.prototype.base = ImageVaultUi.Dialog.prototype;

    shareDialog.prototype.onLoad = function ($dialog) {
        var self = this;
        $("#general", this.$dialog).focus();
        this.copyLinkManualPopup = new ImageVaultUi.TemplatedPopup({
            templateString: ImageVaultUi.TemplatedPopup.tplCopyLinkManualPopup
        });

        $("#general", this.$dialog).bind("change keyup paste", function (e) {
            var date = $("#ValidToDate").val();
            var name = $("#ShareTitle").val();
            var format = date.charAt(4) === "-" && date.charAt(7) === "-";
            var dateIsZero = date.length === 0;
            var dateLength = date.length === 10;

            if (name) {
                if (dateIsZero || format && dateLength && isValidDate(date)) {
                    $(".actions .submit-action", self.$dialog).removeClass("disabled");
                } else {
                    $(".actions .submit-action", self.$dialog).addClass("disabled");
                }
            } else {
                $(".actions .submit-action", self.$dialog).addClass("disabled");
            }
        });
    };

    function isValidDate(date) {
        var inputDate = date.split("-");
        var inputYear = parseInt(inputDate[0]);
        var inputMonth = parseInt(inputDate[1]);
        var inputDay = parseInt(inputDate[2]);

        var newDate = new Date();
        var year = newDate.getFullYear();
        var month = newDate.getMonth() + 1;
        var today = newDate.getDate();

        var monthsInYear = 12;
        var listOfDays = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        var validDayInMonth = listOfDays[inputMonth - 1];

        if (inputYear < year
            || inputMonth > monthsInYear
            || inputDay > validDayInMonth
            || inputDay < 1) return false;

        if (inputYear === year) {
            if (inputMonth < month) return false;
            if (inputMonth > month) {
                if (inputDay > validDayInMonth || inputDay < 1) return false;
            }
            if (inputMonth === month) {
                if (inputDay > validDayInMonth || inputDay < today) return false;
            }
        }
        return true;
    }

    shareDialog.prototype.onError = function (data) {
        try {
            alert(this.saveErrorMsg + "\n" + data.responseText.substr(data.responseText.indexOf('</html>') + 7));
        } catch (err) {
            alert(this.saveErrorMsg);
        }
    };

    shareDialog.prototype.createShareComplete = function (data) {
        new IVNotification(translate("sharedialog.SaveSuccess"),
            {
                duration: 2000
            });
        $("#edit-details", this.$dialog).hide();
        this.hideAction("next");
        this.hideAction("cancel");
        var jResultDiv = $("#show-result", this.$dialog);
        var jPMessage = $("#message", jResultDiv);
        var msg = data.htmlMessage;
        var absUrl = ImageVault.Client.prototype._makeAbsoluteUrl(data.url);
        msg = msg.replace(/\{AbsoluteUrl\}/, absUrl);
        $('div.actions a.clipboard-text').attr('data-clipboard-text', absUrl);
        jPMessage.html(msg);
        var shareLinkInput = document.getElementById("share-link");
        shareLinkInput.value = absUrl;
        var copyLinkButton = document.getElementById("copy-link-button");
        copyLinkButton.onclick = function (e) {
            e.preventDefault();
            shareLinkInput.select();
            shareLinkInput.setSelectionRange(0, 99999);
            navigator.clipboard.writeText(shareLinkInput.value);
            new IVNotification(translate("sharedialog.LinkWasCopiedToClipboard"),
            {
                duration: 2000
            });
            return false;
        };
        jResultDiv.show();
        this.showAction("closeWindow");
        //notify which images was shared
        app.trigger("share:created", this.mediaItemIds);
    };

    ns.ShareDialog = shareDialog;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});