﻿(function ($, ns, undefined) {
    var onUnloadAction = function (e) {
        var iframe = $("iframe")[0];

        if (iframe.contentWindow.ImageVault.EditVideoText.isContentChanged()) {
            e.preventDefault(); // If you prevent default behavior in Mozilla Firefox prompt will always be shown
            // Chrome requires returnValue to be set
            e.returnValue = "";
        }
    };

    var isAutoSaving = false;

    var autosave = function (e) {
        var iframe = $("iframe")[0];

        if (iframe.contentWindow.ImageVault.EditVideoText.isContentChanged()) {
            if (isAutoSaving) return;
            isAutoSaving = true;

            iframe.contentWindow.ImageVault.EditVideoText.autosaveAsync().then(function () {
                $("#spanAutosaved").show();
                isAutoSaving = false;

                setTimeout(() => {
                    $("#spanAutosaved").hide();
                }, 2000);
            });
        }
    };

    var subtitlesDialog = function(config) {
        var self = this;
        //fill in with some default configurations
        config.dialogSize = "medium";
        config.dialogClass = "edit-texts-dialog";

        config.actions = {
            cancel: {
                text: translate("common.Close"),
                action: function () {
                    window.removeEventListener('beforeunload', onUnloadAction);
                    try {
                        var iframe = $("iframe")[0];
                        iframe.contentWindow.ImageVault.EditVideoText.closeAsync().then(function (closeDialog) {
                            if (closeDialog)
                                self.close();
                        });
                    }
                    catch(e) {
                        console.log(e);
                        self.close();
                    };
                },
                cssClass: "cancel-action"
            },
            ok: {
                text: translate("common.Save"),
                action: function() {
                    self.save();
                },
                cssClass: "submit-action",
            },
        };
        this.init(config);
        return this;
    };

    var isIe = function() {
        // IE 10 and IE 11
        return /Trident\/|MSIE/.test(window.navigator.userAgent);
    };

    //setup inheritance
    subtitlesDialog.prototype = new ImageVaultUi.Dialog;
    subtitlesDialog.constructor = subtitlesDialog;
    subtitlesDialog.prototype.base = ImageVaultUi.Dialog.prototype;

    subtitlesDialog.prototype.save = function() {
        var iframe = $("iframe")[0];
        iframe.contentWindow.ImageVault.EditVideoText.saveAsync();
        // var saveBtn = iframe.contentWindow.document.querySelector('.save-button');
        // saveBtn.click();
    };
    subtitlesDialog.prototype.onLoad = function($dialog) {
        var heading = document.createElement("h1");
        heading.innerText = translate("library.EditSubtitles");
        $(".dialog-inner-wrapper").prepend(heading);
        $(".dialog-inner-wrapper").addClass("subtitles-dialog");

        if (isIe()) {
            $(".dialog-inner-wrapper").addClass("ie11");
        }

        $(".edit-texts-dialog .actions").append("<label class='autosave'><input id='cbAutosave' type='checkbox' title='" + translate("library.AutosaveDescription") +"' checked='checked' />" + translate("library.Autosave") + "</label> <span class='hide success-autosave' id='spanAutosaved'>" + translate("library.Saved") +"</span>");
        
        window.addEventListener('beforeunload', onUnloadAction);
    };

    subtitlesDialog.prototype.getDialogHtml = function(success, error) {
        try {
            if (isIe()) {
                var browserWarning = document.createElement("div");
                browserWarning.id = "browserwarning";
                browserWarning.innerText = translate("common.UnsupportedBrowser");
                success(browserWarning);
            } else {
                var self = this;
                var editTextPath = "Library/EditVideoText/";
                var iframe = document.createElement("iframe");
                iframe.src = editTextPath + self.mediaItemId;

                iframe.onload = function () {
                    iframe.contentWindow.addEventListener('cueChanged', function () {
                        if (document.getElementById('cbAutosave').checked) {
                            autosave();
                        }
                    });
                };
                success(iframe);
            }
        } catch (e) {
            error(e);
        }
    };

    ns.SubtitlesDialog = subtitlesDialog;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});