﻿(function ($, ns) {
    var vaultDialog = function (config) {
        this.init(config);
        return this;
    };

    //static method to open the vault dialog
    vaultDialog.OpenDialog = function (vaultId) {
        var loading = new IVNotification(translate("common.Loading"), { showOverlay: true });

        app.load({
            url: 'Vault/Edit',
            data: { vaultId: vaultId },
            success: function (data) {
                loading.remove();
                $('body').append(data);
                $('input#Vault_Name', $('div#vault-admin.dialog')).focus();
            },
            error: function (error) {
                loading.remove();
                app.showError("Error opening vault dialog", error);
            }
        });
    };

    vaultDialog.prototype = {
        //properties
        vaultId: null,
        emptyNameValidationMsg: null,
        saveErrorMsg: null,
        identityRowHtml: null,
        deleteMsg: null,
        confirmTranslation: null,
        cancelTranslation: null,
        //a counter for giving unique row id:s
        accessListNextId: 0,
        //events
        vaultSaved: null,
        vaultDeleted: null,
        //Methods
        init: function (config) {
            var self = this;

            //Stop form from publishing on enter key.
            $('.dialog').find('form').live("keypress", function (e) {
                //TODO: Bad idea.
                if (e.keyCode == 13) {
                    return false;
                }
                return true;
            });

            //Cancel and close dialog.
            $('.dialog .close').live('click', function () {
                self.closeDialog();
                return false;
            });

            //Click event for tab menu.
            $('.dialog ul.tabs a').click(function () {
                self.switchTab($(this));
                return false;
            });

            //Search user or group autocomplete
            $("#access-user").autocomplete({
                autoFocus: true,
                appendTo: 'div#access',
                source: function (req, resp) { return self.getAutoCompleteSource(req, resp); },
                select: function (event, ui) { return self.handleAutoCompleteSelect(event, ui); },
                focus: function (event) {
                    event.preventDefault();
                    return false;
                }
            });

            //Delete no hits message if textbox is empty
            $("#access-user").keyup(function () {
                if ($(this).val() === "") {
                    $('.nohits').remove();
                }
            });

            //Delete vault confirmation
            $('.delete').click(function () {
                self.showDeleteVaultDialog(config);
                return false;
            });

            //Delete vault
            $('#confirmation-dialog button.yes').click(function () {
                self.deleteVault();
                return false;
            });

            //Delete vault cancel
            $('#confirmation-dialog button.no').click(function () {
                $('.confirmation').fadeOut('fast');
                return false;
            });

            //Remove user from list 
            $('#vault-access-table a.remove').live('click', function () {
                self.removeIdentity($(this).attr('data-vault-id'));
                return false;
            });
        },

        roleDropdownChange: function (sender, id) {
            $('#' + id).val(sender.value);
        },

        removeIdentity: function (id) {
            $('#' + id).remove();
        },

        saveVaultComplete: function (data) {
            this.closeDialog();
            new IVNotification(translate("vaultdialog.VaultSuccessfullySaved"), {
                duration: 2000
            });
            //Update vault list
            app.trigger("vaultDialog:vaultSaved", data);
        },

        showDeleteVaultDialog: function (config) {
            var self = this;
            //Show confirmation
            var $confirm = $(
                '<div id="confirmation-dialog" class="confirmation"><div>' +
                '<p>' + config.deleteMsg + '</p>' +
                '<button class="yes">' + config.confirmTranslation + '</button>' +
                '<button class="no">' + config.cancelTranslation + '</button>' +
                '</div></div>');
            $('div.actions').append($confirm);
            //Yes/no click events
            $confirm.find('.yes').click(function () {
                $(this).attr("disabled", "disabled"); //prevent double clicks
                self.deleteVault(config.vaultId);
                return false;
            });
            $confirm.find('.no').click(function () {
                $confirm.fadeOut('fast');
                return false;
            });
        },

        deleteVault: function (id) {
            var self = this;
            //TODO
            app.load({
                url: 'Vault/Delete',
                data: { vaultId: id },
                success: function () {
                    self.closeDialog();
                    app.trigger("vaultDialog:vaultDeleted", id);
                }
            });
        },

        onError: function (data) {
            try {
                alert(this.saveErrorMsg + "\n" + data.responseText.substr(data.responseText.indexOf('</html>') + 7));
            } catch (err) {
                alert(this.saveErrorMsg);
            }
        },

        closeDialog: function () {
            $('.dialog').remove();
            $('.overlay').fadeOut('fast', function () {
                $(this).remove();
            });

            //förhindra dubbelpostning av formulär om man öppnar dialogen igen
            $("form[data-ajax=true] :submit").die("click");
            $("form[data-ajax=true]").die("submit");
        },

        switchTab: function ($tabAnchor) {
            $('.dialog ul.tabs li').removeClass('selected');
            $tabAnchor.closest('li').addClass('selected');
            $('#general,#access,#metadata').hide();
            $('.dialog').find('#' + $tabAnchor.attr('class')).show();
        },

        addIdentityRow: function (name, claimType, claimValue) {
            var self = this;
            if (self.alreadyExist(claimValue)) return;

            var id = "n" + this.accessListNextId++; //prepend a n to make sure that we have unique numbers
            var rowId = "Vault_AccessList_" + id + "__VaultAccess";
            var claimTypeId = "Vault_AccessList_" + id + "__ClaimType";
            var claimTypeName = "Vault.AccessList[" + id + "].ClaimType";
            var claimValueId = "Vault_AccessList_" + id + "__ClaimValue";
            var claimValueName = "Vault.AccessList[" + id + "].ClaimValue";
            var displayNameId = "Vault_AccessList_" + id + "__DisplayName";
            var displayNameName = "Vault.AccessList[" + id + "].DisplayName";
            var roleId = "Vault_AccessList_" + id + "__Role";
            var roleName = "Vault.AccessList[" + id + "].Role";
            var $tr = $('<tr id="' + rowId + '">' +
                '<td class="VaultUserName" title="'+claimType+":"+claimValue+'"><input id="' + claimTypeId + '" name="' + claimTypeName + '" type="hidden" value="' + claimType + '" />' +
                '<input id="' + claimValueId + '" name="' + claimValueName + '" type="hidden" value="' + claimValue + '" />' +
                '<input id="' + displayNameId + '" name="' + displayNameName + '" type="hidden" value="' + name + '" class="sort-value" />' + name + '</td>' +
                '<td><select id="role-dropdown" onchange="dialog.roleDropdownChange(this, \'' + roleId + '\');" class="sort-value">' +
                '<option value="View" selected="selected">View</option><option value="Contribute">Contribute</option><option value="FullControl">FullControl</option>' +
                '</select><input data-val="true" data-val-required="The Role field is required." id="' + roleId + '" name="' + roleName + '" value="View" type="hidden">' +
                '</td><td><a href="#" data-vault-id="' + rowId + '" class="remove");return false;">' + translate("common.Remove") + '</a></td></tr>');
            $("#access table tbody").prepend($tr);
            $tr.effect("highlight", { color: '#fffed9' }, 1000);
        },

        escapeTerm: function (term) {
            if (term) {
                term = term.replace("\\", "\\\\");
            }
            return term;
        },

        alreadyExist: function (claimValue) {
            var exist = Array.from(document.querySelectorAll('.VaultUserName')).filter(function (e) {
                return e.getAttribute('title').includes(claimValue)
            })
            return exist.length > 0
        },

        getAutoCompleteSource: function (request, response) {

            app.json({
                url: 'Vault/GetIdentities',
                data: { searchString: this.escapeTerm(request.term) + '*' },
                success: function (data) {
                    var matches = $.map(data, function (tag) {
                        //if (tag.DisplayName.toUpperCase().indexOf(request.term.toUpperCase()) === 0) {
                        return { label: tag.DisplayName, value: tag.ClaimValue, type: tag.ClaimType };
                        //}
                        //return null;
                    });
                    //Monkeypatching a no hits message.
                    $('.nohits').remove();
                    if (matches.length === 0) {
                        $('#access-user').parent().after('<div class="nohits"><p>'+ImageVaultUi.StringUtil.formatString(translate("common.IdentitySearch_NoUserOrGroupWithNameXExists"), request.term )+'</p></div>');
                    }
                    response(matches);
                }
            });
        },

        handleAutoCompleteSelect: function (event, ui) {
            var userFound;
            $('div#access table td.VaultUserName input').each(function () {
                //only filter out identity inputs
                if (this.name.indexOf("ClaimValue") === -1)
                    return;
                if (this.value === ui.item.value) {
                    var claimTypeName = this.name.replace("ClaimValue", "ClaimType");
                    var claimTypeValue = $('div#access table td.VaultUserName input[@name=' + claimTypeName + ']').val();
                    if (claimTypeValue === ui.item.type) {
                        userFound = this;
                        return false;
                    }
                }
            });

            if (!userFound) {
                this.addIdentityRow(ui.item.label, ui.item.type, ui.item.value);
                $('div#access tbody').scrollTop(0);
            } else {
                //Scroll to user in table
                $('div#access tr').each(function (i) {
                    if (this == $(userFound).parents('tr')[0]) {
                        $('div#access tbody').scrollTop((i - 1) * 37);
                        $(this).effect("highlight", { color: '#fffed9' }, 1000);
                    }
                });
            }
            $('#access-user').val('');
            return false;
        }
    };
    ns.VaultDialog = vaultDialog;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});


