﻿(function($, ns, undefined) {
    var versionsDialog = function(config) {
        var self = this;
        //fill in with some default configurations
        config.dialogSize = "medium";
        config.dialogClass = "manage-versions-dialog";
        config.loadControllerPath = 'version/manageversions';
        config.loadControllerData = {
            mediaItemId: config.mediaItemId,
            sortField: versionsDialog.sortFieldOption.Date,
            sortDirection: versionsDialog.sortDirectionOption.Descending
        };

        config.actions = {
            cancel: {
                text: translate("common.Close"),
                action: function() {
                    self.close();
                },
                cssClass: "cancel-action"
            }
        };
        this.init(config);
        return this;
    };
    //setup inheritance
    versionsDialog.prototype = new ImageVaultUi.Dialog;
    versionsDialog.constructor = versionsDialog;
    versionsDialog.prototype.base = ImageVaultUi.Dialog.prototype;

    // Enumeration: Sortable fields
    versionsDialog.sortFieldOption = {
        Date: 1,
        FileName: 2,
        Author: 3,
        Comment: 4
    };

    versionsDialog.sortDirectionOption = {
        Descending: 0,
        Ascending: 1
    };


    versionsDialog.prototype.onLoad = function($dialog) {
        var self = this;

        self.isPublished = MeridiumUtil.parseBool($("#manage-versions-header").attr("data-is-published"));
        //make sure that each thumbnail handles any temporary errors
        $("img", $dialog).each(function() {
            ImageVaultUi.ThumbnailUtil.handleError($(this));
        });
        // Add new version
        $('a.button.add-new-version', $dialog).click(function() {
            if ($(this).hasClass("disabled"))
                return false;
            self.addNewVersion();
            return false;
        });

        // No click event on current version button
        $('a.button.current-version', $dialog).click(function() {
            return false;
        });

        // Handlers for header fields, managing column sorting
        $('th.sortable', $dialog).click(function() {
            if ($(this).hasClass('filename-column')) {
                self._prepareSort(versionsDialog.sortFieldOption.FileName,
                    versionsDialog.sortDirectionOption.Ascending);
            }
            if ($(this).hasClass('upload-date-column')) {
                self._prepareSort(versionsDialog.sortFieldOption.Date,
                    versionsDialog.sortDirectionOption.Descending);
            }
            if ($(this).hasClass('uploaded-by-column')) {
                self._prepareSort(versionsDialog.sortFieldOption.Author,
                    versionsDialog.sortDirectionOption.Ascending);
            }
            if ($(this).hasClass('comment-column')) {
                self._prepareSort(versionsDialog.sortFieldOption.Comment,
                    versionsDialog.sortDirectionOption.Ascending);
            }
            self.reload();
            return false;
        });


        // click handler to open confirm dialog
        $('a.button.set-version', $dialog).click(function() {
            if ($(this).hasClass("disabled"))
                return false;
            var versionId = MeridiumUtil.parseInt($(this).attr("data-version-id"));
            self.setCurrentVersion(versionId);
            return false;
        });
    };
    versionsDialog.prototype.waitForAssetQueueToProcess = function(callback, iterations) {
        var self = this;
        if (iterations > 3)
            callback();
        app.getJson({
            url: "api/queuedoperations?$filter=operation eq 'Assets'",
            success: function(data) {
                try {
                    var currentOperations = data["@odata.count"];
                    if (currentOperations) {
                        setTimeout(function() { self.waitForAssetQueueToProcess(callback, iterations + 1); }, 500);
                    } else {
                        callback();
                    }
                } catch (e) {
                    app.log(e);
                    callback();
                }
            },
            error: function(e) {
                callback(e);
            }
        });
    };
    versionsDialog.prototype.addNewVersion = function() {
        var addNewVersionDialog = new ImageVaultUi.AddVersionDialog({ mediaItemId: this.mediaItemId });
        var self = this;
        addNewVersionDialog.open(function() {
            self.reload();
        });
    };
    versionsDialog.prototype.setCurrentVersion = function(versionId) {
        var self = this;
        var confirmDialog = new ImageVaultUi.ConfirmDialog({
            templateValues: {
                confirmHeader: translate("versionsdialog.ConfirmHeader"),
                confirmMessage: translate(self.isPublished ?
                    "versionsdialog.ConfirmMessagePublished" :
                    "versionsdialog.ConfirmMessage")
            },
            versionId: versionId
        });
        confirmDialog.open(function() {
            switch (confirmDialog.result) {
                case ImageVaultUi.ConfirmDialog.results.Ok:
                    // console.log("Set-Version-Ok " + confirmDialog.versionId);
                    var loading = new IVNotification(translate("common.Loading"), { showOverlay: true });

                    app.json({
                        url: "version/save",
                        data: { versionId: versionId, setCurrent: true },
                        success: function() {
                            self.waitForAssetQueueToProcess(function() {
                                //notify photo stream of the changes
                                app.trigger('media:versionchange');
                                self.reload();
                                loading.remove();
                            });
                        },
                        error: function(e) {
                            loading.remove();
                            alert("Failed to set the current media version: " + e);
                        }
                    });
                    break;
                case ImageVaultUi.ConfirmDialog.results.Cancel:
                    // console.log("Set-Version-Cancel " + confirmDialog.versionId);
                    break;
            }
        });
    };
    versionsDialog.prototype._prepareSort = function(field, defaultDir) {
        if (this.loadControllerData.sortField == field) {
            this.loadControllerData.sortDirection = (this.loadControllerData.sortDirection + 1) % 2;
        } else {
            this.loadControllerData.sortField = field;
            this.loadControllerData.sortDirection = defaultDir;
        }
    };


    ns.VersionsDialog = versionsDialog;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});