﻿(function ($, ns, undefined) {
    var viewSharesDialog = function (config) {
        var self = this;
	    config.dialogSize = "medium";
	    config.dialogClass = "view-shares-dialog";
	    config.loadControllerPath = "share/viewsharesformediaitem";
	    config.loadControllerData = viewSharesDialog.currentOptions;
        config.loadControllerData.mediaItemId = config.mediaItemId;
	    config.actions = {
	        ok: {
	            text: translate("sharedialog.RemoveSelectedShares"),
	            action: function() {
	                // Confirm dialog
	                var header = "";
	                var message = "";
	                if ($('#share-delete-form input:checkbox:checked').length > 1) {
	                    header = translate("sharedialog.ConfirmHeaderMulti");
	                    message = translate("sharedialog.ConfirmMessageMulti");
	                } else {
	                    header = translate("sharedialog.ConfirmHeader");
	                    message = translate("sharedialog.ConfirmMessage");
	                }
	                var confirm = new ImageVaultUi.ConfirmDialog({
	                    templateValues: {
	                        confirmHeader: header,
	                        confirmMessage: message
	                    }
	                });

	                confirm.open(function() {
	                    // Handle result
	                    switch (confirm.result) {
	                        case ImageVaultUi.ConfirmDialog.results.Ok:
	                            if (self.prepareDeletion()) {
	                                $('#share-delete-form').submit();
	                            }
	                            break;
	                        case ImageVaultUi.ConfirmDialog.results.Cancel:
	                            break;
	                    }
	                });
	            },
	            cssClass: "ok-action",
	            disabled: true
	        },
	        cancel: {
	            text: translate("common.Cancel"),
	            action: function() {
	                //Reset the default options before leaving.
                    viewSharesDialog.currentOptions.sortField = viewSharesDialog.sortFieldOption.Date;
                    viewSharesDialog.currentOptions.sortDirection = viewSharesDialog.sortDirectionOption.Descending;
                    viewSharesDialog.currentOptions.filterOption = viewSharesDialog.filterOption.My;
                    viewSharesDialog.currentOptions.searchString = '';
                    self.close();
	            },
	            noButton: true,
	            cssClass: "cancel-action"
	        }
	    };
		this.init(config);
		return this;
	};
    //setup inheritance
	viewSharesDialog.prototype = new ImageVaultUi.Dialog;
	viewSharesDialog.constructor = viewSharesDialog;
	viewSharesDialog.prototype.base = ImageVaultUi.Dialog.prototype;

	// Enumeration: Sortable fields
	viewSharesDialog.sortFieldOption = {
		Date: 1,
		Name: 2,
		ItemCount: 3,
        Author: 4,
        ExpiryDate: 5
	};

	// Enumeration: Sorting directions
	viewSharesDialog.sortDirectionOption = {
		Descending: 0,
		Ascending: 1
	};

	// Enumeration: Filtering options
	viewSharesDialog.filterOption = {
		My: 0,
		All: 1
	};

	// Static object, holding the state of sorting and filtering.
	viewSharesDialog.currentOptions = {
		mediaItemId: 0,
		sortField: viewSharesDialog.sortFieldOption.Date,
		sortDirection: viewSharesDialog.sortDirectionOption.Descending,
		filterOption: viewSharesDialog.filterOption.My,
		searchString: ''
	};

	viewSharesDialog.prototype.onLoad = function ($dialog) {
	    viewSharesDialog.currentOptions.mediaItemId = this.mediaItemId;
	    this.$dialog = $dialog;
        var self = this;
        //put initialization code here
        self.jobj = $("#view-shares-dialog");
        //Manage the header-checkbox events
        $('th.select-all-column input[type=checkbox]')
            .bind('click',
                function (evt) {
                    $.each($('input.select-checkbox'),
                        function(idx, cb) {
                            cb.checked = evt.currentTarget.checked;
                        });
                    self.setButtonStatus();
                    
                });
        // Manage single checkbox events
        $('input.select-checkbox').bind('click', function(e) {
            self.setButtonStatus();
        });
        //Handlers for header-fields, managing column sorting.
        $('th.sortable')
            .bind('click',
                function(evt) {
                    if ($(this).hasClass('name-column')) {
                        self._prepareSort(viewSharesDialog.sortFieldOption.Name,
                            viewSharesDialog.sortDirectionOption.Ascending);
                    }
                    if ($(this).hasClass('date-column')) {
                        self._prepareSort(viewSharesDialog.sortFieldOption.Date,
                            viewSharesDialog.sortDirectionOption.Descending);
                    }
                    if ($(this).hasClass('file-count-column')) {
                        self._prepareSort(viewSharesDialog.sortFieldOption.ItemCount,
                            viewSharesDialog.sortDirectionOption.Ascending);
                    }
                    if ($(this).hasClass('created-by-column')) {
                        self._prepareSort(viewSharesDialog.sortFieldOption.Author,
                            viewSharesDialog.sortDirectionOption.Ascending);
                    }
                    if ($(this).hasClass('expiry-column')) {
                        self._prepareSort(viewSharesDialog.sortFieldOption.ExpiryDate,
                            viewSharesDialog.sortDirectionOption.Ascending);
                    }
                    self._performSearch();
                    //self.reload();
                    return false;
                });
        //Handlers for managing filtering
        $('input[name=filterOption]')
            .bind('click',
                function() {
                    var newFilterOption = parseInt($(this).val());
                    if (newFilterOption != viewSharesDialog.currentOptions.filterOption) {
                        viewSharesDialog.currentOptions.filterOption = newFilterOption;
                        self._performSearch();
                        //self.reload();
                    }
                });
        $('#show-all-shares-button')
            .bind('click',
                function() {
                    viewSharesDialog.currentOptions.filterOption = viewSharesDialog.filterOption.All;
                    self._performSearch();
                    //self.reload();
                    return false;
                });
        //Handlers for managing search
        $('a.share-search-button')
            .bind('click',
                function() {
                    self._performSearch();
                    //self.reload();
                    return false;
                });
        $('input#share-search-text')
            .keydown(function(evt) {
                if (evt.keyCode == 13) {
                    self._performSearch();
                    //self.reload();
                    return false;
                }
            });
        //Set current search string
        $('input#share-search-text').val(viewSharesDialog.currentOptions.searchString);

        this.copyLinkManualPopup = new ImageVaultUi.TemplatedPopup({
            templateString: ImageVaultUi.TemplatedPopup.tplCopyLinkManualPopup
        });

        this.initClipboard();
    };

    // Enables or disabled the OK action
    viewSharesDialog.prototype.setButtonStatus = function() {
        if ($('#share-delete-form input:checkbox:checked').length > 0) {
            this.enableAction("ok");
        } else {
            this.disableAction("ok");
        }
    }

    viewSharesDialog.prototype.initClipboard = function() {
        if (!app.hasFlash()) {
            // we do not have flash, fallback to popup instead of zeroclipboard
            $('a.clipboard-text')
                .click($.proxy(function(e) {
                        // Todo: change alert to design
                        var link = $(e.target).attr('data-clipboard-text');

                        copyLinkManualValues = this.copyLinkManualValues || {};
                        copyLinkManualValues.copyLink = translate('sharedialog.CopyLink');
                        copyLinkManualValues.actualLink = $(e.target).attr('data-clipboard-text');
                        copyLinkManualValues.copyLinkManualMessage = translate('sharedialog.CopyLinkManualMessage');
                        copyLinkManualValues.closeThisWindow = translate('sharedialog.CloseThisWindow');

                        this.copyLinkManualPopup.injectAfter('div.overlay',
                            copyLinkManualValues,
                            function(html) {
                                // Hook up the eventhandlers for the popup
                                $('a.cancel-action')
                                    .click(function(e) {
                                        $('div#manual-copy')
                                            .fadeOut('fast',
                                                function() {
                                                    $(this).remove();
                                                });
                                        e.preventDefault();
                                    });
                                $('div#manual-copy').fadeIn('fast');
                                $('div#manual-copy input#share-link-input').focus().select();
                            });
                        e.preventDefault();
                    },
                    this));
        }
        // Load the ZeroClipboard script if it's not loaded
        else if (!window.ZeroClipboard /* && !window.clipboardData //Dont use IE impl.*/) {
            $.getScript('Scripts/ZeroClipboard.min.js',
                $.proxy(function() {
                        ZeroClipboard.config({
                            moviePath: app.createPath("Scripts/ZeroClipboard.swf")
                        });
                        this._attachClipboardHandlers();
                    },
                    this));
        } else {
            this._attachClipboardHandlers();
        }
    };

    viewSharesDialog.prototype._attachClipboardHandlers = function() {
        if (window.clipboardData && clipboardData.setData && false /*Dont use IE impl.*/) {
            $("a.clipboard-text")
                .live("click",
                    $.proxy(function(evt) {
                            clipboardData.setData('text', $(this).attr('data-clipboard-text'));
                            var clipboardMsg = new IVNotification(translate("sharedialog.LinkWasCopiedToClipboard"),
                            { showOverlay: false, duration: 4000 });
                        },
                        this));
        } else {
            // Attach the clipboard-function to all anchors...
            this.clipboardClient = new ZeroClipboard($("a.clipboard-text"));
            // Hook up an eventhandler that shows a tooltip message when the link is copied correctly
            this.clipboardClient.addEventListener('complete',
                $.proxy(function(client, text) {
                        var clipboardMsg = new IVNotification(translate("sharedialog.LinkWasCopiedToClipboard"),
                        { showOverlay: false, duration: 4000 });
                    },
                    this));
        }
    };

    //Performs a search
    viewSharesDialog.prototype._performSearch = function() {
        viewSharesDialog.currentOptions.searchString = $('input#share-search-text').val();
        this.reload();
    };

    //Prepares the options before performing the sorting.
    viewSharesDialog.prototype._prepareSort = function(field, defaultDir) {
        var opts = viewSharesDialog.currentOptions;
        if (opts.sortField == field) {
            opts.sortDirection = (opts.sortDirection + 1) % 2;
        } else {
            opts.sortField = field;
            opts.sortDirection = defaultDir;
        }
    };


    viewSharesDialog.prototype.onError = function(data) {
        try {
            alert(this.saveErrorMsg + "\n" + data.responseText.substr(data.responseText.indexOf('</html>') + 7));
        } catch (err) {
            alert(this.saveErrorMsg);
        }
    };


    //Prepare the form-data before submitting it. Function is called during validation of the form.
    viewSharesDialog.prototype.prepareDeletion = function(data) {
        var shareIds = [];

        $.each($('input.select-checkbox'),
            function(idx, cb) {
                if (cb.checked) {
                    shareIds.push($(this).data('share-id'));
                }
            });
        //Store the array of share ids in the form.
        $('#selectedShareIds').val(shareIds);

        //Return false if no checkbox was checked...
        return (shareIds.length > 0);
    };

    //This function finalizes the dialog after deletion of the share/s.
    //It also makes sure that the UI is updated according to the deletion/s.
    viewSharesDialog.prototype.deleteSelectedSharesComplete = function (data) {
        // we are in wrong scope here so append what we need to this before closing
        this.$dialog = $('.view-shares-dialog');
        this.$overlay = $('.overlay');
        this.close();

        if (data.status > 0) {
            var notif = new IVNotification(data.message,
            {
                duration: 4000
            });
            return;
        }

        var notif = new IVNotification(translate("sharedialog.DeleteSuccess"),
        {
            duration: 4000
        });

        if (data.unsharedMediaIds && data.unsharedMediaIds.length > 0) {
            app.trigger("share:removed", data.unsharedMediaIds);
        }
    };

	ns.ViewSharesDialog = viewSharesDialog;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});
