﻿//TODO:Remove this (since it is not used anywhere?)
(function ($) {
	$.fn.imageVaultUpload = function (settings) {
		//basic configuration
		var config = {};
		//extend basic configuration with the supplied settings
		if (settings) $.extend(config, settings);
		this.each(function (i) {
			new imageVaultUploadClass($(this), config);
		});
		//return self to allow chaining
		return this;
	};
	var imageVaultUploadClass = function (jobj, settings) {
		this.jobj = jobj;
		this.dropArea = jobj.get(0);
		this.config = settings;
		this.init();
	};
	imageVaultUploadClass.prototype = {
		//properties
		jobj: null,
		dropArea: null,
		config: null,
		//methods
		init: function () {
			var self = this;
			this.dropArea.addEventListener("dragleave", function (e) { self.dragLeave(e); }, false);
			this.dropArea.addEventListener("dragenter", function (e) { self.dragEnter(e); }, false);
			this.dropArea.addEventListener("dragover", function (e) { self.dragOver(e); }, false);
			this.dropArea.addEventListener("drop", function (e) { self.drop(e); }, false);
		},
		dragLeave: function (evt) {
			var target = evt.target;
			if (target && target === this.dropArea) {
				this.jobj.css("background-color", "#abcdef");
			}
			evt.preventDefault();
			evt.stopPropagation();
		},
		dragEnter: function (evt) {
			this.jobj.css("background-color","#fedcda");
			evt.preventDefault();
			evt.stopPropagation();
		},
		dragOver: function (evt) {
			evt.preventDefault();
			evt.stopPropagation();
		},
		drop: function (evt) {
			this.traverseFiles(evt.dataTransfer.files);
			this.jobj.css("background-color", "#abcdef");
			evt.preventDefault();
			evt.stopPropagation();
		},
		traverseFiles: function (files) {
			if (typeof files !== "undefined") {
				for (var i = 0, l = files.length; i < l; i++) {
					this.uploadFile(files[i]);
				}
			} else {
				this.jobj.html("No support for the File API in this web browser");
			}
		},
		uploadProgress: function (name, progress) {
			var msg = name;
			if (progress > 0) {
				msg += " " + progress + "%";
			}
			this.jobj.html(msg);
		},
		uploadCompleted: function (name) {
			this.jobj.html(name + " uppladdad");
		},
		uploadAborted: function (name) {
			this.jobj.html("Upload of " + name + " failed");
		},
		uploadError: function (name, message) {
			alert("Error uploading item " + name + ". See server log for more information.");
		},
		uploadFile: function (file) {

			var self = this;
			// Uploading - for Firefox, Google Chrome and Safari
			var xhr = new XMLHttpRequest();

			// Update progress bar
			xhr.upload.addEventListener("progress", function (evt) {
				var progress = 0;
				if (evt.lengthComputable) {
					progress = (evt.loaded / evt.total) * 100;
				}
				self.uploadProgress(file.fileName, progress);
			}, false);

			// File uploaded
			xhr.addEventListener("load", function () {
				if (xhr.status == 200) {
					self.uploadCompleted(file.fileName);
				} else {
					self.uploadError(file.fileName, xhr.responseText);
					self.uploadAborted(file.fileName);
				}
			}, false);

			xhr.open("post", "/ImageVault/media/upload/", true);
			//			xhr.onreadystatechange = function (e) {
			//				if (xhr.readyState != 4) { return; }
			//				if (xhr.status != 200) {
			//					// Handle error, e.g. Display error message on page
			//					self.uploadError(file.fileName, xhr.responseText);
			//					return;
			//				}
			//			};

			// Set appropriate headers
			xhr.setRequestHeader("Content-Type", "multipart/form-data");
			xhr.setRequestHeader("X-File-Name", file.fileName);
			xhr.setRequestHeader("X-File-Size", file.fileSize);
			xhr.setRequestHeader("X-File-Type", file.type);

			// Send the file
			xhr.send(file);

		}
	};
})(jQuery);