﻿(function ($, ns) {
  var editCurrentUserDialog = function (config) {
    self = this;
    config.dialogSize = "medium";
    config.dialogClass = "edit-user-size";

    config.actions = {
      cancel: {
        text: translate("common.Cancel"),
        action: function () {
          self.close();
          $.ajax({
            type: "GET",
            url: "account/reload",
            error: function (XMLHttpRequest, textStatus, errorThrown) {
              console.log("Request: " + XMLHttpRequest.toString() + "\n\nStatus: " + textStatus + "\n\nError: " + errorThrown);
            },
            success: function (result) {
              location.reload();
            }
          });
        },
        noButton: true,
        cssClass: "cancel-action"
      },
    }

    this.init(config);
    return this;
  };

  //setup inheritance
  editCurrentUserDialog.prototype = new ImageVaultUi.Dialog;
  editCurrentUserDialog.constructor = editCurrentUserDialog;
  editCurrentUserDialog.prototype.base = ImageVaultUi.Dialog.prototype;

  editCurrentUserDialog.prototype.getDialogHtml = function (success, error) {
    try {
      var editTextPath = "Account/EditCurrentUser/";
      var iframe = document.createElement("iframe");
      var h1 = document.createElement("h1");
      h1.textContent = translate("common.EditUser");
      $(".dialog-inner-wrapper").prepend(h1);
      iframe.src = editTextPath;
      success(iframe);
    } catch (e) {
      error(e);
    }
  };

  ns.EditCurrentUserDialog = editCurrentUserDialog;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});