﻿(function ($, ns) {

    var categoriesView = function (config) {
        this.init(config);
        return this;
    };

    categoriesView.OpenDialog = function () {
        //TODO:We need a better way of doing this...
        var loading = new IVNotification(translate("common.Loading"));
        app.load({
            url: 'Category',
            success: function (data) {
                loading.remove();
                $('.dialog>div.dialog-content').replaceWith('<div class="dialog-content">' + data + '</div>');
            },
            error: function (error) {
                loading.remove();
                app.showError("Error opening categories", error);
            }
        });
    };

    categoriesView.CloseDialog = function () { };

    categoriesView.prototype = {
    	//Properties
        categoryIsUsedQuestion: "The category is in use, do you really want to delete it?",
        confirmDeleteCategory: "Are you sure you want to delete, [NAME]?",
        //Methods
        init: function (config) {
            $.extend(this, config);
            var self = this;

            // add hover functionality
            self._hover();

            // attach event for appending new category form
            $('#categories-admin').find('.new').click(function () {

                if ($(this).hasClass('disabled')) {
                    return false;
                }

                $(this).addClass('disabled');
                self._new(this);
                return false;
            });

            // attach event for closing form
            $('#categories-admin #category-cancel').die();
            $('#categories-admin #category-cancel').live('click', function () {
                self._cancel();
                return false;
            });

            // attach even for saving a new category
            $('#categories-admin #category-add').die();
            $('#categories-admin #category-add').live('click', function () {
                // TODO handle empty fields
                if ($('#category-form').find('#Name').val() != '') {
                    self._add(this);
                }
                return false;
            });

            // attach event for delete
            $('#category-delete').die();
            $('#category-delete').live('click', function () {
                var id = $(this).attr('data-category-id');
                self._delete(id);
                return false;
            });

            // attach event for editing
            $('#category-edit').die();
            $('#category-edit').live('click', function () {
                self._edit(this);
                return false;
            });

            // attach event for saving
            $('#category-save').die();
            $('#category-save').live('click', function () {
                app.log('fire');
                self._save(this);
                return false;
            });

            // attach event for populating level 2
            $('#categories-admin>div ul#categories-1 a.category').die();
            $('#categories-admin>div ul#categories-1 a.category').live('click', function () {
                self._populate1(this);
                return false;
            });

            // attach event for populating level 3
            $('#categories-admin>div ul#categories-2 a.category').die();
            $('#categories-admin>div ul#categories-2 a.category').live('click', function () {
                self._populate2(this);
                return false;
            });

            // attach event for populating level 3
            $('#categories-admin>div ul#categories-3 a.category').die();
            $('#categories-admin>div ul#categories-3 a.category').live('click', function () {
                return false;
            });
        },
        _new: function (elm) {

            var self = this;
            // locate the parent id
            var parentId = $(elm)
                .parent()
                .siblings()
                .attr('data-parent-id');
            // append form to list
            $(elm)
                .parent()
                .siblings('ul')
                .append($('#newCategoryTemplate')
                        .tmpl());
            // cache the form
            var $form = $('#category-form');
            // set correct parentId to the form
            $form.find('#parentId').val(parentId);
            $form.find('#Name').focus();

            $form.find('#Name').keypress(function (e) {
                if (e.keyCode == '13') {
                    e.preventDefault();
                    self._add(this);
                }
            });

        },
        _cancel: function () {
            // remove disabled class
            $('#categories-admin').find('.new').removeClass('disabled');
            // remove form
            $('#category-form').parent().remove();
        },
        _add: function (elm) {
            var self = this;
            app.form({
                url: 'Category/Add',
                data: $('#category-form').serializeArray(),
                success: function (data) {
                    // remove disabled class
                    $(elm)
                        .parentsUntil('ul')
                        .parent()
                        .siblings('.toolbar')
                        .find('.new')
                        .removeClass('disabled');

                    $('#category-form')
                        .parent()
                        .replaceWith($('#categoryTemplate')
                                .tmpl(data));
                    // add hover functionality
                    self._hover();
                    app.trigger("category:added", data);
                },
                error: function (jqXhr, textStatus, errorThrown) {
                    app.log(error ? error.message : "Category/Add failed");
                }
            });
        },

        _delete: function (id) {
            var $elm = $("a[data-category-id='" + id + "']");
            var isUsed = MeridiumUtil.parseBool($elm.attr("data-category-used"));

            var msg = this.confirmDeleteCategory.replace("[NAME]", $elm.attr("data-title"));

            if (isUsed)
                msg = this.categoryIsUsedQuestion;

            if (confirm($('<div/>').html(msg).text())) {

                var loading = new IVNotification(translate("common.Loading"));

                app.json({
                    url: 'Category/delete',
                    data: { id: id },
                    error: function (error) {
                        loading.remove();
                        alert("Delete category failed: " + error.message);
                    },
                    success: function () {
                        var $list = $elm.closest('ul');
                        //remove children
                        if ($list.attr('id') == 'categories-1') {
                            $('#categories-2').empty();
                            $('#categories-3').empty();
                        }
                        if ($list.attr('id') == 'categories-2') {
                            $('#categories-3').empty();
                        }
                        //remove itself
                        $elm.closest('li').remove();

                        app.trigger("category:deleted", id);
                        loading.remove();
                    }
                });
            }
        },
        _edit: function (elm) {

            var self = this;
            var $item = $(elm).closest('li');

            $(elm).closest('li').replaceWith($('#editCategoryTemplate').tmpl());

            var $form = $('#category-form');

            var parentId = $form.closest('ul').attr('data-parent-id');
            var id = $(elm).attr('data-category-id');

            $form.find('#Name').val($item.find('.category').clone().children().remove().end().text());
            $form.find('#Id').val(id);
            $form.find('#parentId').val(parentId);

            $form.find('#category-cancel').click(function () {
                $form.closest('li').replaceWith($item);
                // register hover indent
                self._hover();
                return false;
            });

            $form.find('#Name').keypress(function (e) {
                if (e.keyCode == '13') {
                    e.preventDefault();
                    self._save();
                }
            });
        },
        _save: function () {
            var self = this;
            app.log('saving');
            app.form({
                url: 'Category/Save',
                data: $('#category-form').serializeArray(),
                success: function (data) {
                    $('#category-form').parent().replaceWith($('#categoryTemplate').tmpl(data));
                    // add hover functionality
                    self._hover();
                    app.trigger("category:edited", data);

                },
                error: function (error) {
                    app.log(error?error.message:"Category/Save failed");
                }
            });
        },
        _hover: function () {
            $('#categories-admin>div ul li').hoverIntent({
                sensitivity: 7, // number = sensitivity threshold (must be 1 or higher)
                interval: 100, // number = milliseconds of polling interval
                over: function () {
                    var data = { categoryId: $(this).find('.category').attr('data-category-id') };
                    $(this).find('a').append($('#hoverTemplate').tmpl(data));
                },
                timeout: 0, // number = milliseconds delay before onMouseOut function call
                out: function () {
                    $('#category-edit').parent().remove();
                }
            });
        },
        _populate1: function (elm) {
            var self = this;
            var loading = new IVNotification(translate("common.Loading"));

            $(elm).parent().siblings().removeClass('selected');
            $(elm).parent().addClass('selected');

            var id = $(elm).attr('data-category-id');

            app.json({
                url: 'Category/PopulateLevel1',
                data: { parentId: id },
                success: function (data) {

                    loading.remove();

                    $('#categories-3')
                        .empty()
                        .removeAttr('data-parent-id')
                        .siblings('.toolbar')
                        .find('.new')
                        .addClass('disabled');

                    $('#categories-2')
                        .html($("#categoryTemplate")
                                .tmpl(data))
                        .attr('data-parent-id', id)
                        .siblings('.toolbar')
                        .find('.new')
                        .removeClass('disabled');

                    // attach hover events
                    self._hover();
                }
            });
        },
        _populate2: function (elm) {
            var self = this;
            var loading = new IVNotification(translate("common.Loading"));

            $(elm).parent().siblings().removeClass('selected');
            $(elm).parent().addClass('selected');

            var id = $(elm).attr('data-category-id');

            app.json({
                url: 'Category/PopulateLevel2',
                data: { parentId: id },
                success: function (data) {
                    loading.remove();

                    $('#categories-3')
                        .html($("#categoryTemplate").tmpl(data))
                        .attr('data-parent-id', id)
                        .siblings('.toolbar')
                        .find('.new')
                        .removeClass('disabled');

                    // attach hover events
                    self._hover();
                }
            });
        }
    };
    //export to namespace
    ns.CategoriesView = categoriesView;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});