﻿(function ($, ns) {

	var adminView = function (config) {
		this.init(config);
		return this;
	};

	adminView.OpenDialog = function () {
		//TODO:We need a better way of doing this...
		var loading = new IVNotification(translate("common.Loading"), { showOverlay: true });

		app.load({
			url: 'Admin',
			//type: 'GET',
			success: function (data) {
				loading.remove();
				$('body').append(data);
			},
			error: function (error) {
				loading.remove();
				app.showError("Error opening admin dialog", error);
			}
		});
	};


	adminView.prototype = {
		currentItem: null,

		init: function (config) {
			$.extend(this, config);
			var self = this;
			//locate components
			this.dialogElement = $('#iv-admin');
			// attach event for editing metadata definitions

			$('#iv-admin #edit-meta-def').click(function () {
				if (!$(this).parent().hasClass("disabled"))
					self.selectTab('meta-def');
				return false;
			});
			// attach event for editing conversion formats
			$('#iv-admin #edit-conversions').click(function () {
				if (!$(this).parent().hasClass("disabled"))
					self.selectTab('conversions');
				return false;
			});
			// attach event for editing global categories
			$('#iv-admin #edit-categories').click(function () {
				if (!$(this).parent().hasClass("disabled"))
					self.selectTab('categories');
				return false;
			});
			// attach event for editing global categories
			$('#iv-admin #edit-global-rights').click(function () {
				if (!$(this).parent().hasClass("disabled"))
					self.selectTab('rights');
				return false;
			});
			// attach event for editing global categories
			$('#iv-admin #edit-consent').click(function () {
				if (!$(this).parent().hasClass("disabled"))
					self.selectTab('consent');
				return false;
			});
			// attach event for closing the dialog
			$('#iv-admin .close').click(async function () {
				// Close current tab before closing the dialog
				if (self.currentItem)
					await self.currentItem.onClose();

				$('#iv-admin').die();
				$('.overlay').fadeOut('fast', function () {
					$(this).remove();
				});
				return false;
			});
		},
		setSelectedTab: function (id) {
			$('.dialog ul.tabs li').removeClass('selected');
			$('#' + id).parent('li').addClass('selected');
		},
		trySelectTab: async function (item) {
			var $li = $('#' + item.id).parent('li');
			if ($li.hasClass("disabled")) {
				return false;
			}
			// Close current tab before opening a new...
			if (this.currentItem)
				await this.currentItem.onClose();

			$('.dialog ul.tabs li').removeClass('selected');
			$li.addClass('selected');
			item.open();
			this.currentItem = item;
			return true;
		},
		selectTab: function (state) {
			var items = [
				{ state: 'meta-def', id: 'edit-meta-def',
					open: ImageVaultUi.MetadataDefinitionView.OpenDialog,
					onClose: ImageVaultUi.MetadataDefinitionView.CloseDialog },
				{ state: 'conversions', id: 'edit-conversions',
					open: ImageVaultUi.MediaFormatView.OpenDialog,
					onClose: ImageVaultUi.MediaFormatView.CloseDialog },
				{ state: 'categories', id: 'edit-categories',
					open: ImageVaultUi.CategoriesView.OpenDialog,
					onClose: ImageVaultUi.CategoriesView.CloseDialog },
				{ state: 'rights', id: 'edit-global-rights',
					open: ImageVaultUi.GlobalRightsView.OpenDialog,
					onClose: ImageVaultUi.GlobalRightsView.CloseDialog },
				{ state: 'consent', id: 'edit-consent',
					open: ImageVaultUi.ConsentView.OpenDialog,
					onClose: ImageVaultUi.ConsentView.CloseDialog }
			];
			var selectedItem = null;

			var i;
			for (i = 0; i < items.length; i++) {
				if (items[i].state == state) {
					selectedItem = items[i];
					break;
				}
			}
			//no item with that name was found
			if (selectedItem == null)
				return;
			//try to open the requested tab.
			if (this.trySelectTab(selectedItem))
				return;
			//if that fails, try to open the first available tab
			for (i = 0; i < items.length; i++) {
				this.trySelectTab(items[i]);
			}
		}
	};

	// Custom event-methods (for synchronizing with React components)
	ns.bindEvent = function(evtid, cb) {
	//	console.log(`binding event: ${evtid}@${document.title}`);
		window.addEventListener(evtid, function _hdlr(e) {
			cb(e);
			window.removeEventListener(evtid, _hdlr);
		});
	};

	ns.triggerEvent = function(evtid) {
	//	console.log(`triggering event: ${evtid}@${document.title}`);
		var evt = new Event(evtid, {bubbles: false, cancelable: false});
		window.dispatchEvent(evt);
	};

	//export to namespace
	ns.AdminView = adminView;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});
