﻿(function ($, ns) {

	var globalRightsView = function (config) {
		this.init(config);
		return this;
	};

	globalRightsView.OpenDialog = function () {
		var loading = new IVNotification(translate("common.Loading"));
		//TODO:We need a better way of doing this...
		app.load({
			url: 'GlobalRights',
			success: function (data) {
				loading.remove();
				$('.dialog>div.dialog-content').replaceWith('<div class="dialog-content">' + data + '</div>');
			},
			error: function (error) {
				loading.remove();
				app.showError("Error opening global rights", error);
			}
		});
	};

    globalRightsView.CloseDialog = function () { };

	globalRightsView.prototype = {
		//Properties
		adminUrl: null,
		$identityTableBody: null,
		deleteQuestion: "Delete user???",
		cancelEditQuestion: "Cancel edit???",
		coreExceptionMsg: "Core exception!!",
		selectedIdentity: null,
		//Methods
		init: function (config) {

			var self = this;
			$.extend(this, config);

			this.$identityTableBody = $("#access-table table tbody");
			//hook up event on add definition button
			$('#GlobalRightsAddButton').die('click');
			$('#GlobalRightsAddButton').live('click', function () {
				self.showEditIdentityForm();
				return false;
			});

			$('#global-rights-admin .save').die('click');
			$('#global-rights-admin .save').live('click', function () {
				if (!$(this).hasClass("disabled")) {
					self.saveIdentity();
				}
				return false;
			});
			$('#global-rights-admin .edit').die('click');
			$('#global-rights-admin .edit').live('click', function () {
				if (!$(this).hasClass("disabled")) {
					var $row = $(this).closest('tr');
					self.showEditIdentityForm($row);
				}
				return false;
			});
			$('#global-rights-admin .addRole').die('click');
			$('#global-rights-admin .addRole').live('click', function () {
				var $row = $(this).closest('tr');
				self.addRole($row);
				return false;
			});
			$('#global-rights-admin div.addedRole a').die('click');
			$('#global-rights-admin div.addedRole a').live('click', function () {
				var $div = $(this).closest('div');
				self.removeRole($div);
				return false;
			});

			$('#EditIdentityForm .cancel').die('click');
			$('#EditIdentityForm .cancel').live('click', function () {
				self.removeEditIdentityForm();
				return false;
			});
			// hook up event for deleting an identity
			$('#EditIdentityForm .delete').die('click');
			$('#EditIdentityForm .delete').live('click', function () {
				var $row = $(this).closest('tr');
				self.deleteIdentity($row);
				return false;

			});

		},
		//toggles the new definition form
		toggleAddUserGroupForm: function () {
			if ($('#EditIdentityForm').length == 0) {
				this.showEditIdentityForm();
			} else {
				//$('#access-table').find('a.edit').unbind('click');
				this.removeEditIdentityForm();
			}
		},
		deleteIdentity: function ($row) {
			var self = this;
			var claimValue = $("td", $row).attr('data-claimValue');
			var claimType = $("td", $row).attr('data-claimType');
			if (!confirm($('<div/>').html(this.deleteQuestion).text())) {
				return;
			}
			app.json({
				url: 'GlobalRights/Delete',
				data: { claimType: claimType, claimValue: claimValue },
				success: function () {
					//					$('#EditIdentityForm .delete').removeAttr('disabled');
					$row.remove();
					//remove any hidden rows (the edited row for example)
					$("tr:hidden", self.$identityTableBody).remove();
				},
				error: function (xhr) {
					var msg = $('<div/>').html(self.coreExceptionMsg).text();
					msg = msg.replace("{0}", xhr.message);
					alert(msg);
				}
			});
		},
		//displays the edit identity form.
		//@param $row The row to edit or undefined if a new identity should be added
		showEditIdentityForm: function ($row) {
			if ($("#UserGroupFormContainer").length > 0 && !confirm($('<div/>').html(this.cancelEditQuestion).text()))
				return;
			this.removeEditIdentityForm();
			var self = this;
			var isNewIdentity = true;
			var identity = { ClaimValue: "", ClaimType: "", DisplayName: "", Roles: 0 };
			//if we pass a row to the method, we get the identity from that row
			if ($row != undefined) {
				identity = { ClaimValue: $row.attr("data-claimValue"), ClaimType: $row.attr("data-claimType"), DisplayName: $row.attr("data-displayName"), Roles: MeridiumUtil.parseInt($row.attr("data-roles")) };
				isNewIdentity = false;
			}
			this.selectedIdentity = identity;
			var $template = $('#addUserGroupFormTemplate').tmpl(identity);
			if (isNewIdentity) {
				//hide delete button for new items
				$("a.delete", $template).hide();
			} else {
				//disable name textbox for edit
				var $input = $("input[name='DisplayName']", $template);
				$input.attr("disabled", "disabled");
				$input.addClass("disabled");
			}
			//sort the select box 
			this.sortSelect($("select", $template));
			//populate the roles
			$("option", $template).each(function (index, option) {
				var i = MeridiumUtil.parseInt($(option).attr("value"));
				if ((i & identity.Roles) > 0) {
					self.addRole($template, i, $(option).text());
				}
			});
			//new identities are edited at the top of the table
			if (isNewIdentity) {
				$template.prependTo(this.$identityTableBody);
				//add autocomplete
				$("#access-displayName", $template).autocomplete({
					autoFocus: true,
					appendTo: 'div#access-search span.search',
					source: function (req, resp) { return self.getAutoCompleteSource(req, resp); },
					select: function (event, ui) {
						$("#access-displayName").val(ui.item.label);
						$("#access-claimValue").val(ui.item.value);
						$("#access-claimType").val(ui.item.type);
						self.selectedIdentity = { ClaimType: ui.item.type, ClaimValue: ui.item.value, DisplayName: ui.item.label };
						self.formChanged();
						return false;
					},
					focus: function (event, ui) {//keep label as auto complete when stepping between items in the dropdown
						event.preventDefault();
						return false;
					}
				});
				//Delete no hits message if textbox is empty
				$("#access-displayName", $template).keyup(function () {
					if ($(this).val() === "") {
						$(".nohits").remove();
					}
					self.formChanged();
				});
				//don't submit form on enter in name textbox
				$("#access-displayName", $template).keydown(function (event) {
					if (event.keyCode == '13') {
						event.preventDefault();
					}
				});
			} else {
				$row.after($template);
				$row.hide();
			}
			this.scrollInSight($('#global-rights-admin #access #access-table'), $template);
			this.formChanged();
		},
		//closes the edit identity form
		removeEditIdentityForm: function () {
			var self = this;
			// activate all edit links
			$('#global-rights-admin .edit').die('click');
			$('#global-rights-admin .edit').live('click', function () {
				var $row = $(this).closest('tr');
				self.showEditIdentityForm($row);
				return false;
			});
			$('#UserGroupFormContainer').closest("tr").remove();
			//show any hidden rows
			$("#global-rights-admin tr:hidden").show();
		},
		//adds a role to the edit form (and removes it from the select box)
		addRole: function ($row, roleId, roleName) {

			var $rolesDiv = $("div div", $row);
			var $select = $("select", $rolesDiv);
			//Get info about role to add
			if (roleId == undefined) {
				roleId = parseInt($select.val());
			}
			if (roleName == undefined) {
				roleName = $(":selected", $select).text();
			}
			if (roleId == NaN)
				return;
			//add item
			var addNewRoleDiv = $select.closest("div");
			addNewRoleDiv.before("<div class=\"addedRole\" data-role-id=\"" + roleId + "\" data-role-name=\"" + roleName + "\">" + roleName + " <a href=\"#\">x</a></div>");
			//remove option from select
			$("option[value='" + roleId + "']", $select).remove();

			//hide dropdown if empty
			if ($('option', $select).length == 0)
				addNewRoleDiv.hide();
			this.formChanged();
		},

		//removes a role (not the select box role)
		removeRole: function ($div) {
			//get info about the role to remove
			var roleId = parseInt($div.attr("data-role-id"));
			var roleName = $div.attr("data-role-name");
			//add option to select
			var $rolesDiv = $div.parent().closest("div");
			var $select = $("select", $rolesDiv);
			$select.append("<option value='" + roleId + "'>" + roleName + "</option>");
			//sort options
			this.sortSelect($select);
			//show selectbox (it can be hidden)
			var addNewRoleDiv = $select.closest("div");
			addNewRoleDiv.show();
			//remove item
			$div.remove();
			$(".addRole", $rolesDiv).show();
			this.formChanged();
		},
		//sorts a selectbox according to its values (not text)
		sortSelect: function ($select) {
			// save the selected value
			var selectedVal = $select.val();

			// get the options and loop through them
			var $options = $('option', $select);
			var arrVals = [];
			$options.each(function () {
				// push each option value and text into an array
				arrVals.push({
					val: $(this).val(),
					text: $(this).text()
				});
			});

			// sort the array by the text
			arrVals.sort(function (a, b) {
				//return a.val - b.val;
				if (a.text < b.text)
					return -1;
				if (a.text > b.text)
					return 1;
				return 0;
			});

			// loop through the sorted array and set the text/values to the options
			for (var i = 0, l = arrVals.length; i < l; i++) {
				$($options[i]).val(arrVals[i].val).text(arrVals[i].text);
			}

			// set the selected value back
			$select.val(selectedVal);
		},
		//This method is called when the form is changed and the UI should be updated to reflect the changes
		formChanged: function () {
			var valid = this.isFormValid();
			if (valid) {
				$('#global-rights-admin .save').removeClass("disabled");
			} else {
				$('#global-rights-admin .save').addClass("disabled");
			}
		},
		isFormValid: function () {
			var identity = this.parseForm();
			if (!identity.ClaimValue)
				return false;
			if (!this.selectedIdentity || identity.ClaimValue != this.selectedIdentity.ClaimValue || identity.ClaimType != this.selectedIdentity.ClaimType)
				return false;
			if (identity.Roles == "0")
				return false;
			return true;
		},
		parseForm: function () {
			var claimValue = $("#EditIdentityForm input[name='ClaimValue']").val();
			var claimType = $("#EditIdentityForm input[name='ClaimType']").val();
			var displayName = $("#EditIdentityForm input[name='DisplayName']").val();
			var roles = 0;
			$("div.addedRole").each(function (i, el) {
				roles |= MeridiumUtil.parseInt($(el).attr("data-role-id"));
			});

			//enum binder wont work if json object is an integer... only works with strings?!
			return { ClaimType: claimType, ClaimValue: claimValue, DisplayName: displayName, Roles: "" + roles };
		},
		//saves the identity
		//@param $row the row
		saveIdentity: function () {
			var self = this;
			//Form validation
			var $row = $("#EditIdentityForm").closest("tr");
			var identity = this.parseForm();

			app.load({
				url: 'GlobalRights/Save',
				data: identity, //$('#EditIdentityForm').serializeArray(),
				//				dataType: 'HTML',
				success: function (data) {
					//remove any hidden rows (the edited row for example)
					$("tr :hidden", self.$identityTableBody).remove();
					$row.after(data);
					$row.remove();
					// activate edit buttons
					$("#global-rights-admin .edit").die("click");
					$("#global-rights-admin .edit").live("click", function () {
						var $tr = $(this).closest("tr");
						self.showEditIdentityForm($tr);
						return false;
					});
				}
			});
		},
		escapeTerm: function (term) {
			if (term) {
				term = term.replace("\\", "\\\\");
			}
			return term;
		},
		//handles the autocomplete search function
		getAutoCompleteSource: function (request, response) {
			var self = this;
			var term = this.escapeTerm(request.term);
			app.json({
				url: "Vault/GetIdentities",
				data: { searchString: term + "*" },
				success: function (data) {
					//matches
					var matches = $.map(data, function (tag) {
						//if (tag.DisplayName.toUpperCase().indexOf(request.term.toUpperCase()) === 0) {
						return { label: tag.DisplayName, value: tag.ClaimValue, type: tag.ClaimType||"" }
						//}
						//return null;
					});
					//remove already used identities
					var usedIdentities = $.map($("tr:visible", self.$identityTableBody), function (tr) {
						var claimType = $(tr).attr("data-claimType");
						var claimValue = $(tr).attr("data-claimValue");
						var displayName = $(tr).attr("data-displayName") || claimValue;
						if (claimValue) {
							return { value: claimValue, label: displayName, type: claimType }
						}
						return null;
					});
					var noOfMatches = matches.length;
					var notUsedMatches = [];
					outerloop:
					for (var i = 0; i < matches.length; i++) {
						for (var j = 0; j < usedIdentities.length; j++) {
							if (matches[i].value === usedIdentities[j].value && matches[i].type === usedIdentities[j].type)
								continue outerloop;
						}
						notUsedMatches[notUsedMatches.length] = matches[i];
					}
					matches = notUsedMatches;

					var nohitsMessage = ImageVaultUi.StringUtil.formatString(translate("common.IdentitySearch_NoUserOrGroupWithNameXExists"), request.term );
					//If search found identities that already is used
					if (noOfMatches > 0) {
						nohitsMessage = ImageVaultUi.StringUtil.formatString(translate("common.IdentitySearch_NoHitsOnSearchForXMessage"), request.term );
					}
					//Monkeypatching a no hits message.
					$(".nohits").remove();
					if (matches.length === 0) {
						$("#access-displayName").parent().after("<div class=\"nohits\"><p>" + nohitsMessage + '</p></div>');
					}
					response(matches);
				}
			});
		}
	};
	//inherit from _listView
	ImageVaultUi._ListView.call(globalRightsView.prototype);

	ns.GlobalRightsView = globalRightsView;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});