﻿(function ($, ns) {

	var mediaFormatView = function (config) {
		this.init(config);
		return this;
	};

	mediaFormatView.OpenDialog = function () {
		//TODO:We need a better way of doing this...
		var loading = new IVNotification(translate("common.Loading"));
		app.load({
			url: 'MediaFormat',
			success: function (data) {
				loading.remove();
				$('.dialog>div.dialog-content').replaceWith('<div class="dialog-content">' + data + '</div>');
			},
			error: function (error) {
				loading.remove();
				app.showError("Error opening media formats", error);
			}
		});
	};

    mediaFormatView.CloseDialog = function () { };

	mediaFormatView.prototype = {
		fieldEmptyMsg: null,
		fieldExistsMsg: null,
		deleteDefinitionQuestion: "Delete definition???",
		formatsCanHaveCompressionQuality: ['0', '1', '4', '6'],
		init: function (config) {
			$.extend(this, config);
			var self = this;
			//locate components
			//this.dialogElement = $('#conversions-admin');

			// attach show new form event
			$('#media-format-add-button').die('click');
			$('#media-format-add-button').live('click', function () {
				if ($('#media-format-form').length == 0) {
					self.showAddNewMediaFormatForm(this);
					$(this).attr('disabled', 'disabled');
				}
				return false;
			});
			// attach event for removing the form
			$('#new-media-format-cancel-button').die('click');
			$('#new-media-format-cancel-button').live('click', function () {
				$('#media-format-form').remove();
				$('#media-format-add-button').removeAttr('disabled');
				return false;
			});
			// attach event for editing
			$('#media-format-admin .edit').die('click');
			$('#media-format-admin .edit').live('click', function () {
				if ($('#media-format-form').length == 0) {
					var $row = $(this).closest('tr');
					self.editMediaFormat($row);
					$('#media-format-add-button').attr('disabled', 'disabled');
				}
				return false;
			});
			$('#media-format-save-button').die('click');
			$('#media-format-save-button').live('click', function () {
				var $row = $(this).closest('tr');
				self.saveMediaFormat($row);
				return false;
			});
			$('#media-format-cancel-button').die('click');
			$('#media-format-cancel-button').live('click', function () {
				var $row = $(this).closest('tr');
				self.cancelMediaFormat($row);
				$('#media-format-add-button').removeAttr('disabled');
				return false;
			});

			// checks if the compression quality can be set
			$('#MediaFormatOutputType').die('click');
			$('#MediaFormatOutputType').live('change', function () {
				self.updateCompressionQualityField(this);
				self.updateExportMetadataField(this);
			});
			$('#media-format-admin input[type=number]').die('keydown');
			$('#media-format-admin input[type=number]').live('keydown', function (e) {
				if (e.ctrlKey) return true;//allow control modified keys (copy paste)
				var code = e.keyCode || e.which;
				switch (code) {
					case 8://backspace
					case 9://tab
					case 13://enter
					case 33://page up
					case 34://page down
					case 35://end
					case 36://home
					case 37://left arrow
					case 38://up arrow
					case 39://rigth arrow
					case 40://down arrow
					case 45://insert
					case 46://delete
					case 96://num0
					case 97://num1
					case 98://num2
					case 99://num3
					case 100://num4
					case 101://num5
					case 102://num6
					case 103://num7
					case 104://num8
					case 105://num9
						return true;
					default:
						var key = String.fromCharCode(code);
						//ignore codes that does not translate to a key
						if (!key || key.length === 0) return true;
						return !isNaN(key);
				}
			});

		},
		// inserts a form used for adding a new conversion format
		showAddNewMediaFormatForm: function (button) {
			$('#new-media-format-template').tmpl().prependTo($('#media-format-table tbody'));
		},
		// edit the current conversion format
		editMediaFormat: function ($row) {
			var self = this;
			var mediaFormatId = $row.attr('data-media-format-id');
			app.json({
				url: this.adminUrl + '/Get',
				data: { mediaFormatId: mediaFormatId },
				success: function (data) {
					$row.html($('#editMediaFormatTemplate').tmpl(data));
					$('#MediaFormatOutputType option[value="' + data.MediaFormatOutputType + '"]').attr('selected', 'selected');
					$('#ExportMetadataType option[value="' + data.ExportMetadataType + '"]').attr('selected', 'selected');
					$('#media-format-delete-button').click(function (e) {
						e.preventDefault();
						self.deletedMediaFormat($row);
						return false;
					});
					self.scrollInSight($('#media-format-admin > div'), $row);
					self.updateExportMetadataField($('#MediaFormatOutputType'));
				}
			});
		},

		//cancel the edit operation
		cancelMediaFormat: function ($row) {
			var self = this;
			var mediaFormatId = $row.attr('data-media-format-id');
			if (!mediaFormatId) {
				$row.replaceWith('');
				return;
			}
			app.json({
				url: this.adminUrl + '/Get',
				data: { mediaFormatId: mediaFormatId },
				success: function (data) {
					$row.replaceWith($('#mediaFormatTemplate').tmpl(data));
				}
			});
		},
		saveMediaFormat: function ($row) {
			var self = this;
			//Form validation
			//var $nameInput = $('#media-format-form #Name');
			if (!self.validateForm()) {
				return false;
			}
			$('#media-format-save-button').attr('disabled', 'disabled');
			$('#media-format-add-button').removeAttr('disabled');
			app.form({
				url: this.adminUrl + '/Save',
				data: $('#media-format-form').serializeArray(),
				dataType: 'JSON',
				type: 'POST',
				success: function (data) {
					$row.replaceWith($('#mediaFormatTemplate').tmpl(data));
				}
			});
		},
		// deletes a definition 
		deletedMediaFormat: function ($row) {
			if (!confirm($('<div/>').html(this.deleteDefinitionQuestion).text())) {
				return;
			}
			$('#media-format-add-button').removeAttr('disabled');
			var id = $row.attr('data-media-format-id');
			app.json({
				url: this.adminUrl + '/Delete',
				data: { mediaFormatId: id },
				success: function () {
					$row.remove();
				}
			});
			return false;
		},
		// validate name
		validateForm: function () {
			var valid = true;
			$('#media-format-form #error-msg').remove();
			$('#media-format-form .error').removeClass('error');
			var $nameInput = $('#media-format-form #Name');

			var self = this;
			//Validating field empty
			if ($nameInput.val() == '') {
				alert(self.fieldEmptyMsg);
				return false;
			}
			//Validating already exists, (the code needs to look like this to handle special characters)
			var name = $nameInput.val();
			var children = $('#media-format-table tr td:first-child');
			if (children.length > 0) {
				for (var i = 0; i < children.length; i++) {
					if ($(children[i]).text().toLowerCase() == name.toLowerCase()) {
						alert(self.fieldExistsMsg);
						return false;
					}
				}
			}

			var $widthInput = $('#media-format-form #Width');
			if ($widthInput.val() != '' && $widthInput.val() < 0) {
				$widthInput.addClass('error');
				valid = false;
			}
			var $heightInput = $('#media-format-form #Height');
			if ($heightInput.val() != '' && $heightInput.val() < 0) {
				$heightInput.addClass('error');
				valid = false;
			}
			var $dpiInput = $('#media-format-form #Dpi');
			if ($dpiInput.val() != '' && $dpiInput.val() < 0) {
				$dpiInput.addClass('error');
				valid = false;
			}

			return valid;
		},
		// check if the compression quality can be set
		updateCompressionQualityField: function (select) {
			var self = this;
			if (self.formatsCanHaveCompressionQuality.indexOf($(select).val()) < 0) {
				$('input:text[name=CompressionQuality]').val('').attr('disabled', 'disabled');
			} else {
				$('input:text[name=CompressionQuality]').removeAttr('disabled');
			}
		},
		updateExportMetadataField: function (select) {
			// Clear- and disable the exportMetadata field if the outputtype is Png.
			if ($(select).val() === "4" || $(select).val() === "5") {
				$('select[name=ExportMetadataType]').val('').attr('disabled', 'disabled');
			} else {
				$('select[name=ExportMetadataType]').removeAttr('disabled');
			}
		}
	};
	//inherit from _listView
	ImageVaultUi._ListView.call(mediaFormatView.prototype);

	//export to namespace
	ns.MediaFormatView = mediaFormatView;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});