﻿(function($, ns) {
    var metadataDefinitionView = function(config) {
        this.init(config);
        return this;
    };

    metadataDefinitionView.OpenDialog = function() {
        //TODO:We need a better way of doing this...
        var loading = new IVNotification(translate("common.Loading"));
        app.load({
            url: 'MetadataDefinition',
            success: function(data) {
                loading.remove();
                $('.dialog>div.dialog-content').replaceWith('<div class="dialog-content">' + data + '</div>');
            },
            error: function(error) {
                loading.remove();
                app.showError("Error opening metadata definitions", error);
            }
        });
    };

    metadataDefinitionView.CloseDialog = function () { };

    metadataDefinitionView.prototype = {
        //Properties
        fieldEmptyMsg: null,
        fieldExistsMsg: null,
        dialogElement: null,
        adminUrl: null,
        currentDefinition: null,
        availableMappingsForCurrentDefinition: null,
        currentEditElement: null,
        //Methods
        init: function(config) {
            $.extend(this, config);
            var self = this;
            //locate components
            this.dialogElement = $('#meta-def-admin-metadatadefinition');

            //hook up event on add definition button
            $('#DefinitionAddButton').die('click');
            $('#DefinitionAddButton').live('click', function() {
                self.currentDefinition = null;
                self.availableMappingsForCurrentDefinition = null;
                self.toggleNewDefinitionForm();
                self.symbolDropdown();

                return false;
            });

            // hook up event on cancel button
            $('#DefinitionCancelButton').die('click');
            $('#DefinitionCancelButton').live('click', function() {
                var $row = $(this).closest('tr');
                self.cancelEditDefinition($row);
                return false;
            });

            // hook up event on delete definition button
            $('#DefinitionDeleteButton').die('click');
            $('#DefinitionDeleteButton').live('click', function() {
                var $row = $(this).closest('tr');
                self.deletedDefinition($row);
                return false;
            });

            // hook up events on add mapping button when createing a new button
            $('#NewAddMappingButton').die('click');
            $('#NewAddMappingButton').live('click', function() {
                var mapping = [];
                if (self.currentDefinition) {
                    mapping = self.currentDefinition.SourceMetadataDefinitions;
                }
                self.currentDefinition = { Name: $('#Name').val(), Description: $('#Description').val(), SourceMetadataDefinitions: mapping, MetadataType: $('#MetadataType').val(), IsReadOnly: $('#IsReadOnly').prop("checked"), IsMultilingual: $('#IsMultilingual').prop("checked"), Id: 0 }; // $('#MetdataDefinitionForm').serializeArray();
                if (!self.currentDefinition.SourceMetadataDefinitions) {
                    self.currentDefinition.SourceMetadataDefinitions = [];
                }
                $('#MetadataType').attr('disabled', 'disabled');
                self.showAvailableMappings($('#MetadataType').val());
                return false;
            });

            // hook up event on add mapping button
            $('#AddMappingButton').die('click');
            $('#AddMappingButton').live('click', function() {
                var $row = $(this).closest('tr');
                var datatype = $("#MetadataType", $row).val();
                self.showAvailableMappings(datatype);
                return false;
            });

            // hook up event on create definition button
            $('#meta-def-admin .create').die('click');
            $('#meta-def-admin .create').live('click', function() {
                self.createDefinition();
                return false;
            });

            $('#meta-def-admin .save').die('click');
            $('#meta-def-admin .save').live('click', function() {
                var $row = $(this).closest('tr');
                self.saveDefinition($row);
                return false;
            });

            $('#meta-def-admin .edit').die('click');
            $('#meta-def-admin .edit').live('click', function() {
                var $row = $(this).closest('tr');
                self.editDefinition($row);
                return false;
            });

            $('#MetdataDefinitionForm .cancel').die('click');
            $('#MetdataDefinitionForm .cancel').live('click', function() {
                self.closeNewDefinitionForm();
                return false;
            });

            // attach event for mapping removal
            $("#meta-def-admin .remove-mapping").die('click');
            $("#meta-def-admin .remove-mapping").live('click', function() {
                self.removeMapping(this);
                return false;
            });

            // attach event for adding a mapping
            $("#meta-def-admin #add-mapping").die('click');
            $("#meta-def-admin #add-mapping").live('click', function() {
                self.addMapping(this);
                return false;
            });

            $('#meta-def-admin .close').click(function() {
                $('#meta-def-admin').die();
                $('#DefinitionCancelButton').die();
                $('#DefinitionDeleteButton').die();
                $('#AddMappingButton').die();
                $('.overlay').fadeOut('fast', function() {
                    $(this).remove();
                });

                return false;
            });

        },
        //toggles the new definition form
        toggleNewDefinitionForm: function() {
            if ($('#MetdataDefinitionForm').length == 0) {
                this.addForm();
            } else {
                this.closeNewDefinitionForm();
            }
        },
        //closes the new definition form
        closeNewDefinitionForm: function() {
            $('#MetadataDefinitionFormContainer').remove();
            this.setEditingDefinition(null);
        },
        // adds definition row
        addForm: function() {
            var $template = $('#newDefinitionFormTemplate').tmpl();
            $template.prependTo($('#definitionTable tbody'));
            this.setEditingDefinition($template);
        },
        //cancel the edit operation
        cancelEditDefinition: function($row) {
            var self = this;
            var definitionId = $row.attr('id');
            $('#NewAddMappingButton').die();
            $('#definition-maps a').die();
            $('#DefinitionAddButton').removeAttr('disabled');
            app.json({
                url: this.adminUrl + '/GetDefinition',
                data: { id: definitionId },
                success: function(data) {
                    $row.replaceWith($('#definitionRowTemplate').tmpl(data));
                    self.setEditingDefinition(null);
                }
            });
        },
        // Creates a new definition
        createDefinition: function() {
            var self = this;

            //Form validation
            var $nameInput = $('#MetdataDefinitionForm #Name');
            if (!self.validateForm($nameInput)) {
                return false;
            }

            app.form({
                url: this.adminUrl + '/Create',
                data: $('#MetdataDefinitionForm').serialize(),
                success: function(data) {
                    $('#DefinitionAddButton').removeAttr('disabled');
                    var $template = $('#newDefinitionRowTemplate').tmpl(data);
                    $template.prependTo($('#definitionTable tbody'));
                    $template.effect("highlight", { color: '#fffed9' }, 1000);
                    $('#MetdataDefinitionForm').remove();
                    self.setEditingDefinition(null);
                }
            });
        },
        saveDefinition: function($row) {
            var self = this;
            //Form validation
            var $nameInput = $('#MetdataDefinitionForm #Name');
            if (!self.validateForm($nameInput)) {
                return false;
            }

            app.form({
                url: this.adminUrl + '/Save',
                data: $('#MetdataDefinitionForm').serializeArray(),
                //				type: 'POST',
                //				dataType: 'JSON',
                success: function(data) {
                    $('#NewAddMappingButton').die();
                    $('#definition-maps a').die();
                    $('#DefinitionAddButton').removeAttr('disabled');

                    $row.replaceWith($('#definitionRowTemplate').tmpl(data));

                    self.setEditingDefinition(null);
                    app.trigger("metadatadefinition:changed")
                }
            });
        },
        //checks if we currently are editing a definition
        isEditingDefinition: function() {
            return this.currentEditElement != null;
        },
        //sets/clears the current editing element
        setEditingDefinition: function(element) {
            var enableButtons = element == null;
            var enableAddDefinition = enableButtons || element.is("form");
            if (enableButtons) {
                $('#meta-def-admin .edit').removeAttr('disabled');
            } else {
                $('#meta-def-admin .edit').attr('disabled', 'disabled');
            }
            if (enableAddDefinition) {
                $('#meta-def-admin .add').removeAttr('disabled');
            } else {
                $('#meta-def-admin .add').attr('disabled', 'disabled');
            }
            this.currentEditElement = element;
        },
        // edit a definition 
        editDefinition: function($row) {
            var self = this;
            if (self.isEditingDefinition()) {
                return false;
            }
            var definitionId = $row.attr('id');
            $('#DefinitionAddButton').attr('disabled', 'disabled');

            app.json({
                url: this.adminUrl + '/GetDefinition',
                data: { id: definitionId },
                success: function(data) {

                    self.currentDefinition = data;
                    self.availableMappingsForCurrentDefinition = null;
                    self.setEditingDefinition($row);
                    $row.replaceWith($('#editDefinitionTemplate').tmpl(data));

                    $("#definition-maps").sortable({
                        update: function() {
                            self.sortMappings();
                        }
                    });

                    // Set active symbol key
                    $(".symbol-key-dropdown").val(data.SymbolKey);
                    self.symbolDropdown();
                }
            });

        },
        // deletes a definition 
        deletedDefinition: function($row) {
            var self = this;
            var definitionId = $row.attr('id');
            app.json({
                url: self.adminUrl + '/GetDeleteMessage',
                data: { id: definitionId },
                success: function(data) {
                    if (!confirm(data)) {
                        return;
                    }
                    app.json({
                        url: self.adminUrl + '/Delete',
                        data: { id: definitionId },
                        success: function() {
                            $('#DefinitionAddButton').removeAttr('disabled');
                            $row.remove();
                            self.setEditingDefinition(null);
                            app.trigger("metadatadefinition:deleted");
                        }
                    });
                }
            });
        },

        // load the available mappings
        showAvailableMappings: function(datatype) {
            var self = this;
            var datatype2 = datatype;
            if (self.availableMappingsForCurrentDefinition == null) {
                app.json({
                    url: this.adminUrl + '/GetAvailableMappingDefinitions',
                    data: { datatype: datatype2 },
                    success: function(data) {
                        self.availableMappingsForCurrentDefinition = data;
                        self.updateAvaliableMappings();
                    }
                });


            } else {
                self.updateAvaliableMappings();

            }
        },
        currentDefinitionHasMappingSelected: function(definition) {
            if (this.currentDefinition == null || this.currentDefinition.SourceMetadataDefinitions == null)
                return false;
            for (var i = 0; i < this.currentDefinition.SourceMetadataDefinitions.length; i++) {
                var d = this.currentDefinition.SourceMetadataDefinitions[i].MetadataDefinition;
                if (d.Id == definition.Id)
                    return true;
            }
            return false;
        },
        updateAvaliableMappings: function() {
            var mappings = new Array();
            for (var i = 0; i < this.availableMappingsForCurrentDefinition.length; i++) {
                var definition = this.availableMappingsForCurrentDefinition[i];
                if (!this.currentDefinitionHasMappingSelected(definition))
                    mappings.push(definition);
            }
            var select = $('<li class="add"><select id="available-mappings"/><a href="#" id="add-mapping">' + translate('common.Add') + '</a></li>');
            $('#definition-maps').append(select);
            $('#available-mappings').append($('#addMappingsTemplate').tmpl(mappings));
            $('#AddMappingButton, #NewAddMappingButton').hide();
        },
        // adds a mapping to a specified definition
        addMapping: function(definition) {
            var self = this;
            var def = self.currentDefinition;
            var id = $('#available-mappings').find(':selected').val();

            def.Name = $('#Name').val();
            def.Description = $('#Description').val();
            def.IsReadOnly = $('#IsReadOnly').is(':checked');
            def.IsMultilingual = $('#IsMultilingual').is(':checked');

            def.SourceMetadataDefinitions.push({ Priority: def.SourceMetadataDefinitions.length + 1, MetadataDefinition: { Id: id, Name: $('#available-mappings').find(':selected').text() } });
            var $row = $("#MetadataDefinitionFormContainer");
            if ($('#NewAddMappingButton').length) {
                $row.parent().replaceWith($('#newDefinitionFormTemplate').tmpl(def));
            } else {
                $row.parent('tr').replaceWith($('#editDefinitionTemplate').tmpl(def));
            }
            self.symbolDropdown();
            $("#definition-maps").sortable({
                update: function(event, ui) {
                    self.sortMappings($(this).sortable('toArray'));
                }
            });
        },
        // removes a mapping from the definition
        removeMapping: function(mapping) {
            var self = this;
            var def = self.currentDefinition;
            var index = $(mapping).attr('href').replace('#', '');
            def.Name = $('#Name').val();
            def.Description = $('#Description').val();
            def.IsReadOnly = $('#IsReadOnly').is(':checked');
            def.IsMultilingual = $('#IsMultilingual').is(':checked');
            def.SourceMetadataDefinitions.splice(index, 1);

            var $row = $("#MetadataDefinitionFormContainer");
            if ($('#NewAddMappingButton').length) {
                $row.parent().replaceWith($('#newDefinitionFormTemplate').tmpl(def));
            } else {
                $row.parent('tr').replaceWith($('#editDefinitionTemplate').tmpl(def));
            }
            self.symbolDropdown();

        },
        // validate name
        validateForm: function($nameInput) {
            var self = this;
            //Validating field empty
            if ($nameInput.val() == '') {
                alert(self.fieldEmptyMsg);
                return false;
            }
            //Validating already exists
            var name = $nameInput.val();

            var match = false;

            var list = $('#definitionTable tbody tr td:first-child');
            $.each(list, function(k, v) {
                if ($(v).text() == name) {
                    match = true;
                    return;
                }
            });

            if (match) {
                alert(self.fieldExistsMsg);
                return false;
            }
            return true;
        },
        sortMappings: function() {
            var maps = $('#meta-def-admin :hidden.map');
            for (var i = 0; i < maps.length; i++) {
                maps[i].value = i;
            }
        },
        symbolDropdown: function () {
            var button = $("#SymbolKeyButton");
            var dropdown = $("#SymbolKey");
            var list = $("#SymbolKeyList");

            if (list.find("div").length > 0) return;

            button.click(function () {
                document.getElementById("SymbolKeyList").classList.toggle("show");
                return false;
            });

            var items = dropdown.find("option");
            var selected = dropdown.find("option:selected");
            dropdown.hide();

            for (var j = 0; j < items.length; j++) {
                var item = $(items[j]);
                var html = "<div data-val='" + item.val() + "'>";

                if (item.val() !== "") {
                    html += "<span class='metadata-symbol metadata-symbol-" +
                        item.val() +
                        "'><span class='icon icon-" +
                        item.val() +
                        "'></span></span>";
                }

                html += item.text() + "</div >";

                list.append(html);
            }

            button.text(selected.text());

            list.find("div").click(function() {
                var active = $(this);
                dropdown.val(active.attr("data-val"));
                button.html(active.html());
            });

            list.find("div[data-val='" + selected.val() +"']").click();

            $(window).click(function (event) {
                if (!event.target.matches('.dropbtn')) {
                    var dropdowns = document.getElementsByClassName("dropdown-content");
                    var i;
                    for (i = 0; i < dropdowns.length; i++) {
                        var openDropdown = dropdowns[i];
                        if (openDropdown.classList.contains('show')) {
                            openDropdown.classList.remove('show');
                        }
                    }
                }
            });
        }
    };
    //export to namespace
    ns.MetadataDefinitionView = metadataDefinitionView;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});