document.addEventListener("DOMContentLoaded", (event) => {
    document.querySelectorAll("details").forEach((details) => {
        // Add notification spans
        if (details.hasAttribute("data-notification") && !details.querySelector("span.collapsable-notification")) {
            let notification = document.createElement("span");
            notification.classList.add("collapsable-notification", "circle-notification");
            details.querySelector("summary").append(notification);
        }

        // Add modal behaviour for details
        if (details.hasAttribute("data-modal")) {
            details.addEventListener("click", modalClick);
        }
    });
});

// When opening a detail marked with data-modal,
// close all others that are open.
const modalClick = (clickEvent) => {
    if (!clickEvent.currentTarget.open) {
        document.querySelectorAll("details[data-modal][open]").forEach((openDetail) => {
            if (openDetail != clickEvent.currentTarget.target) {
                openDetail.removeAttribute("open");
            }
        });
    }
};