﻿(function ($, ns, undefined) {
    //constructor (only use this for inheritance)
    var dialog = function () {
        return this;
    }

    //class functions
    dialog.prototype.init = function (config) {
        $.extend(this, config);
        this.disabledCssClass = "disabled";
        this.hiddenCssClass = "hidden";

        var self = this;
        if (!this.actions) {
            this.actions = {
                close: {
                    text: translate("common.Close"),
                    action: function () {
                        self.close();
                    }
                }
            }
        }
    };
    //opens the dialog and loads the contents
    dialog.prototype.open = function (onCloseCallback) {
        if(!dialog.current) {
            window.ImageVaultUi.ModalUtil.disableBodyScroll();
        }
        this.parentDialog = dialog.current;
        dialog.current = this;
        var self = this;
        this._onCloseCallback = onCloseCallback;
        //don't show overlay since we provide one of our own
        this._loading = new IVNotification(translate("common.Loading"), { showOverlay: false });

        //setup dialog
        var $cancelButton = $("<a href=\"#\" class=\"cancel-action close-cross\" data-actionname=\"cancel\"><span class=\"icon icon-cross\"></span></a>");
        this.$overlay = $("<div class='overlay'/>");
        this.$dialog = $("<div class='dialog-light' />");
        this.$dialog.append($cancelButton);

        this.$innerWrapper = $("<div class='dialog-inner-wrapper'/>");
        this.$dialog.hide();
        this.$dialogContents = $("<div class='dialog-content'/>");
        if (this.dialogSize) {
            this.$dialog.addClass(this.dialogSize);
        }
        if (this.dialogClass) {
            this.$dialog.addClass(this.dialogClass);
        }
        this.$innerWrapper.append(this.$dialogContents);
        this.$dialog.append(this.$innerWrapper);
        if (!this.hideHrBeforeActions) {
            this.$innerWrapper.append('<hr/>');
        }
        var $footerDiv = $('<div class="dialog-footer"/>');
        var $actionsDiv = $('<div class="actions"/>');
        var actions = this.actions;
        // Add cancel action for all
        $cancelButton.unbind("click").click(function () {
            self.actions["cancel"].action();
            return false;
        });

        for (var actionName in actions) {

            if (actions.hasOwnProperty(actionName)) {
                var action = actions[actionName];


                if (action.htmlText) {
                    $footerDiv.append(action.htmlText);
                } else {

                    var $actionLink = $('<a href="#" class="button">' + action.text + '</a>');
                    if (action.disabled) {
                        $actionLink.addClass(self.disabledCssClass);
                    }
                    if (action.cssClass) {
                        $actionLink.addClass(action.cssClass);
                    }
                    if (action.noButton) {
                        $actionLink.removeClass("button");
                    }
                    if (action.hidden) {
                        $actionLink.addClass(self.hiddenCssClass);
                    }
                    $actionLink.attr("data-actionName", actionName);
                    action.$a = $actionLink;
                    $actionLink.unbind("click").click(function () {
                        var $a = $(this);
                        if ($a.hasClass(self.disabledCssClass)) return false;

                        var actionName = $a.attr("data-actionName");
                        self.actions[actionName].action();
                        return false;
                    });

                }

                $actionsDiv.append($actionLink);
            }
        }

        $footerDiv.append($actionsDiv);
        this.$innerWrapper.append($footerDiv);

        if (this.$container == undefined || this.$container.length === 0) {
            this.$overlay.append(this.$dialog);
            $('body').append(this.$overlay);
        } else {
            this.$container.html(this.$dialog);
            this.$container.animate({ top: "0" }, 500);
        }

        this.reload();
        self._status = dialog.status.opened;
    };
    dialog.prototype.disableAction = function (actionName) {
        this.actions[actionName].$a.addClass(this.disabledCssClass);
    };
    dialog.prototype.enableAction = function (actionName) {
        this.actions[actionName].$a.removeClass(this.disabledCssClass);
    };
    dialog.prototype.hideAction = function (actionName) {
        this.actions[actionName].$a.addClass(this.hiddenCssClass);
    };
    dialog.prototype.showAction = function (actionName) {
        this.actions[actionName].$a.removeClass(this.hiddenCssClass);
    };
    //reloads the contents of the dialog
    dialog.prototype.reload = function () {
        var self = this;
        //default getDialogHtml will load from controller and data
        if (!self.getDialogHtml) {
            self.getDialogHtml = function (success, error) {
                app.load({
                    url: this.loadControllerPath,
                    data: this.loadControllerData,
                    success: function (data) {
                        success(data);

                    },
                    error: function (e) {
                        error(e);
                    }
                });
            };
        }
        //call getDialogHtml and display contents
        self.getDialogHtml(function (data) {
            self._loading.remove();
            self.$dialogContents.empty();
            self.$dialogContents.append(data);
            self.$dialog.show();
            if (self.onLoad)
                self.onLoad(self.$dialogContents);
        },
            function (error) {
                self.close();
                self._loading.remove();
                app.showError('Error opening dialog', error);
            }
        );
    };
    dialog.status = {
        closed: "Closed",
        opened: "Opened"
    };
    dialog.prototype.isClosed = function () {
        return this._status === dialog.status.closed;
    };
    dialog.prototype.isOpened = function () {
        return this._status === dialog.status.opened;
    };
    //closes the dialog
    dialog.prototype.close = function (noFade) {
        var self = this;
        self._status = dialog.status.closed;
        if (self.onClose)
            self.onClose(self.$dialogContents);
        this.$dialog.remove();
        if (noFade) {
            self.$overlay.remove();
        } else {
            this.$overlay.fadeOut('fast', function () { self.$overlay.remove(); });
        }
        if (self._onCloseCallback) {
            self._onCloseCallback();
        }
        dialog.current = this.parentDialog;
        this.parentDialog = null;
        if(!dialog.current) {
            window.ImageVaultUi.ModalUtil.enableBodyScroll();
        }
    };
    //export to ns
    ns.Dialog = dialog;

})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});