﻿(function ($, ns, undefined) {
	var popupMenu = Backbone.Model.extend({
		//############################################
		//##  Attributes
		//############################################
		//a unique id for the instance (used to mark event handlers)
		id: _.uniqueId("PopupMenu"),

		//############################################
		//##  Functions
		//############################################
		//Initializes the object. Run on creation
		initialize: function (self) {
			//if we initialize this from a base class then we need to pass the {self:this} object to the initialize call
			if (self && self.self) {
				self = self.self;
			} else {
				self = this;
			}
			var $domobject = self.get('$domobject');
			if ($domobject === undefined)
				throw "$domobject is not defined in config";

			//click a link, trigger click event
			$("a", $domobject).click(function (e) {
				var unhandled = self.clickAction($(this));
				if(!unhandled) e.preventDefault();
				return unhandled;
			});

			$("i", $domobject).click(function (e) {
				var unhandled = self.clickAction($(this));
				if(!unhandled) e.preventDefault();
				return unhandled;
			});
		},

		clickAction: function (selector) {
			var self = this;
			var id = selector.attr("data-name");
			//ignore links without data-name
			if (!id) {
				self.trigger("popup:linkClicked", selector);
				return true;
			}
			self.trigger(id + "Click", selector);
			self.hide();
			return false;
		},
		//checks if the supplied target (element) is a child of the domobject of the popup menu
		isLocalElement: function (target) {
			var elem = this.get('$domobject').get(0);
			while (target) {
				if (target == elem)
					return true;
				target = target.parentNode;
			}
			return false;
		},
		isVisible: function () {
			var $domobject = this.get('$domobject');
			return ($(':visible', $domobject).length > 0);
		},
		//toggles the popup menu
		toggle: function () {
			if (this.isVisible()) {
				this.hide();
			} else {
				this.show();
			}
		},
		//hides the menu
		hide: function () {
			var $domobject = this.get('$domobject');
			this.trigger("beforeHide");
			$domobject.fadeOut('fast');
			//disconnect the event listener
			var id = this.get("id");
			$('body').unbind("click." + id);
			this.trigger("afterHide");
		},
		//shows the popup menu
		show: function () {
			//hide any open popup menu
			if (ImageVaultUi.PopupMenu.Current)
				ImageVaultUi.PopupMenu.Current.hide();
			var $domobject = this.get('$domobject');
			this.trigger("beforeShow");
			$domobject.show();
			var self = this;
			var id = this.get("id");
			$('body').bind("click." + id, function (e) {

				var target = (e && e.target) || (event && event.srcElement);

				// Ignore datepicker
				if (!self.isLocalElement(target) && !$(target).closest("#ui-datepicker-div").length) {
					self.hide();
					if ($("ul.disabled")) {
						$("ul.disabled").removeClass("disabled");
					}
				}
				return true;
			});
			//update the pointer to the current open popup menu
			ImageVaultUi.PopupMenu.Current = this;
		}
	});
	ns.PopupMenu = popupMenu;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});