﻿(function ($, ns, undefined) {
    var templatedPopup = function (config) {
		this.init(config);
		return this;
	};
	templatedPopup.prototype = {
		template: null,
		init: function (config) {
			this.template = _.template(config.templateString);
		},
		injectAfter: function (selectorString, valueObj, initFunc) {
			var html = this.template(valueObj);
			$(html).insertAfter($(selectorString));
			if (initFunc && typeof (initFunc) === "function") {
				initFunc(html);
			}
		}
	};

	// Predefined templates
	$.extend(templatedPopup, {
		tplCopyLinkManualPopup: " \
		<div id='manual-copy' class='overlay'> \
        <div id='manual-copy-dialog' class='dialog-light small thin'> \
        <a href='#' class='cancel-action close-cross' data-actionname='cancel'><span class='icon icon-cross'></span></a> \
        <div class='dialog-inner-wrapper'> \
        <div class='dialog-inner-wrapper'> \
            <div id='manual-copy-header'> \
                <h1 id='manual-copy-header-text'><%= copyLink %></h1> \
            </div> \
            <p id='manual-copy-message'><%= copyLinkManualMessage %></p> \
            <input id='share-link-input' readonly='readonly' type='text' value='<%= actualLink %>'/> \
        </div> \
        <div class='dialog-footer'> \
            <div class='actions'> \
                <a href='#' id='close-manual-copy' class='button cancel-action'><%= closeThisWindow %></a> \
            </div> \
        </div> \
        </div> \
        </div> \
</div> \
	",
		tplChangeVersionConfirmationPopup: " \
            <div class='confirmation-dialog'> \
                <h1 class='alert'><%= confirmHeader %></h1> \
            </div> \
            <p><%= confirmMessage %></p> \
        "
	});

	ns.TemplatedPopup = templatedPopup;


	var confirmDialog = function (config) {
	    var self = this;
	    config.hideHrBeforeActions = true;
	    config.templateString = templatedPopup.tplChangeVersionConfirmationPopup;
	    config.dialogSize = "confirm";
	    config.dialogClass = "confirmation-dialog";
        config.actions= {
            ok: {
                text: translate("common.Ok"),
                action:function() {
                    self.result = confirmDialog.results.Ok;
                    self.close();
                },
                cssClass: "ok-action"
            },
            cancel: {
                text: translate("common.Cancel"),
                action: function () {
                    self.result = confirmDialog.results.Cancel;
                    self.close();
                },
                noButton: true,
                cssClass: "cancel-action"
            }
        }
        this.init(config);
	    return this;
	};
    //setup inheritance
	confirmDialog.prototype = new ImageVaultUi.Dialog;
	confirmDialog.constructor = confirmDialog;
	confirmDialog.prototype.base = ImageVaultUi.Dialog.prototype;

	confirmDialog.results = { Ok: "ok", Cancel: "cancel" };

	confirmDialog.prototype.getDialogHtml = function (success,error) {
	    try {
	        this.template = _.template(this.templateString);
	        var html = this.template(this.templateValues);
	        success(html);
	    } catch (e) {
	        error(e);
	    }
	};
	ns.ConfirmDialog = confirmDialog;

})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});