customElements.define(
    "search-media-typegroups",
    class extends HTMLElement {
        static get observedAttributes() { return ['data-filecount']; }
        constructor() {
            super();            
        }
        connectedCallback() {
            this.bindEvents();
            this.init();
            this.fileCountContainer = this.querySelector("span.filecount");
        }
        attributeChangedCallback(name, oldvalue, newvalue) {
            if (this.fileCountContainer && name === "data-filecount") {
                this.fileCountContainer.textContent = newvalue;                
            }
        }
        init() {
            this.selectedMediaTypeGroups = $.bbq.getState("mediaTypeGroups") ? $.bbq.getState("mediaTypeGroups").split(",") : [];
            [...this.querySelectorAll("input[type=checkbox]")].forEach(checkbox => {  
                checkbox.checked = this.selectedMediaTypeGroups.includes(checkbox.value);
            });
        }
        bindEvents() {
            [...this.querySelectorAll("input[type=checkbox]")].forEach(checkbox => {  
                checkbox.addEventListener("change", () => {     
                    var currentState = $.bbq.getState(checkbox.name);
                    var stateArray = currentState ? currentState.split(",") : [];
                    var indexOfValue = stateArray.indexOf(checkbox.value);
                    indexOfValue === -1 ? stateArray.push(checkbox.value) : stateArray.splice(indexOfValue, 1);
                    var newState = {};
                    newState[checkbox.name] = stateArray.join(",");
                    $.bbq.pushState(newState);
                });
            });
            window.addEventListener("hashchange", e => {
                if (app.hasStateChanged("mediaTypeGroups")) {
                    this.init();
                }
            });
        }
    }
)