customElements.define(
    "search-media-orientations",
    class extends HTMLElement {
        constructor() {
            super();            
        }
        connectedCallback() {
            this.bindEvents();    
            this.init();        
        }
        init() {
            this.selectedMediaOrientations = $.bbq.getState("mediaOrientations") ? $.bbq.getState("mediaOrientations").split(",") : [];
            [...this.querySelectorAll("input[type=checkbox]")].forEach(checkbox => {    
                checkbox.checked = this.selectedMediaOrientations.includes(checkbox.value);
            });
        }
        bindEvents() {
            [...this.querySelectorAll("input[type=checkbox]")].forEach(checkbox => {                
                checkbox.addEventListener("change", () => {     
                    var currentState = $.bbq.getState(checkbox.name);
                    var stateArray = currentState ? currentState.split(",") : [];
                    var indexOfValue = stateArray.indexOf(checkbox.value);
                    indexOfValue === -1 ? stateArray.push(checkbox.value) : stateArray.splice(indexOfValue, 1);
                    var newState = {};
                    newState[checkbox.name] = stateArray.join(",");
                    $.bbq.pushState(newState);
                });
            });
            window.addEventListener("hashchange", e => {
                if (app.hasStateChanged("mediaOrientations")) {                
                    this.init();
                }
            });
        }
    }
)