
customElements.define(
    "search-media-sizegroups",
    class extends HTMLElement {
        constructor() {
            super();                        
        }
        connectedCallback() {
            this.bindEvents();
            this.init();
        }
        init() {
            this.selectedMediaSizeGroups = $.bbq.getState("mediaSizeGroups") ? $.bbq.getState("mediaSizeGroups").split(",") : [];                         
            [...this.querySelectorAll("input[type=checkbox]")].forEach(checkbox => {    
                checkbox.checked = this.selectedMediaSizeGroups.includes(checkbox.value);
            });
        }
        bindEvents() {
            [...this.querySelectorAll("input[type=checkbox]")].forEach(checkbox => {                
                checkbox.addEventListener("change", () => {     
                    var currentState = $.bbq.getState(checkbox.name);
                    var stateArray = currentState ? currentState.split(",") : [];
                    var indexOfValue = stateArray.indexOf(checkbox.value);
                    indexOfValue === -1 ? stateArray.push(checkbox.value) : stateArray.splice(indexOfValue, 1);
                    var newState = {};
                    newState[checkbox.name] = stateArray.join(",");
                    $.bbq.pushState(newState);
                });
            });
            window.addEventListener("hashchange", e => {
                if (app.hasStateChanged("mediaSizeGroups")) {
                    this.init();
                }
            });
        }
    }
)