customElements.define(
  "search-metadata",
  class extends HTMLElement {
    constructor() {
      super(); 
      this.metadataFieldNames = {};      
    }

    connectedCallback() {
      this.bindEvents();
      this.init();
    }

    init() {      
      //Reset dialog
      [...this.querySelectorAll("input,select")].forEach(input => {
        input.value ="";
      });
      //Init dialog with current values
      var currentState = $.bbq.getState("mediaMetadataOptions");
      var stateArray = currentState ? currentState.split(",") : [];
      [].forEach.call(stateArray, value => {
        var keyvalue = value ? value.split(this.dataset.keyvaluesplit) : [];
        if (keyvalue.length > 1) {
          if (keyvalue[1].indexOf(this.dataset.rangevaluesplit) < 0) {
            document.getElementById(this.dataset.identifierprefix + keyvalue[0]).value = keyvalue[1];
          } else {
            var ranges = keyvalue[1].split(this.dataset.rangevaluesplit);
            document.getElementById(this.dataset.identifierprefix + keyvalue[0] + "-min").value = ranges[0];
            document.getElementById(this.dataset.identifierprefix + keyvalue[0] + "-max").value = ranges[1];
          }
        }
      });
    }
    
    bindEvents() {
      this.querySelector('nav').addEventListener("click", (e) => {
        e.stopPropagation();
      });

      [...this.querySelectorAll('details details')].forEach(el => {          
          el.addEventListener("click", (e) => {
            const container = this.querySelector('nav > ul');
            this.style.setProperty('--y', (-24 - container.scrollTop) + "px") ;
            [...this.querySelectorAll('details details')].forEach(el => {                                
              if(!e.target.closest('details').isEqualNode(el)) {   
                el.removeAttribute("open");
              }
            });
          });
      });

      [...this.querySelectorAll('button')].forEach(btn => {        
        var mdid = btn.dataset.mdid;
        if (mdid === undefined) return;
        var inputid = this.dataset.identifierprefix + mdid;
        var fieldName = btn.dataset.name;
        this.metadataFieldNames[mdid] = fieldName;

        btn.addEventListener("click", (e) => {
            e.preventDefault();  

            var searchMissingProperty = document.getElementById("empty-" + inputid)?.checked;

            //Create search value        
            var searchValuePrefix = mdid + this.dataset.keyvaluesplit;
            var searchValue = "";
            if (e.target.dataset && e.target.dataset.valueisrange && e.target.dataset.valueisrange.toLowerCase() === "true") {
              var minInput = document.getElementById(inputid + "-min");
              var maxInput = document.getElementById(inputid + "-max");              
              if ((minInput.value + maxInput.value).length > 0) {
                searchValue += minInput.value + this.dataset.rangevaluesplit + maxInput.value;
              }
            } else {
              var input = document.getElementById(inputid);
              if (input.value.length > 0) {
                searchValue += input.value;
              }
            }

            //Get state
            var name = "mediaMetadataOptions";
            var currentState = $.bbq.getState(name);
            var stateArray = currentState ? currentState.split(",") : [];

            //Remove previous searches on same metadata definition
            var filteredArray = stateArray.filter(x => {
              return !x.startsWith(mdid);
            });  
            
            //Add new value
            if (searchValue.length > 0 || searchMissingProperty == true) {              
              filteredArray.push(searchValuePrefix + searchValue);                
            }

            //Save state
            var newState = {};
            newState[name] = filteredArray.join(",");
            $.bbq.pushState(newState);
          });
      }); 
            
      window.addEventListener("hashchange", e => {
        if (app.hasStateChanged("mediaMetadataOptions")) {
            this.init();
        }
    });
    }        

    get fieldNames() {
      return this.metadataFieldNames;
    }
  }
);
