(function ($, ns, undefined) {
  function searchCategories($ul, value, organiseView) {
    const parents = $ul.children().toArray()
    // Remove input field if organiseView...
    if (organiseView) parents.shift()

    parents.forEach(function (parent) {
      parent.style.display = 'block'
    })

    $('span.expand.expanded', $ul).each(function () {
      var $span = $(this);
      $span.removeClass('expanded')
      $span.siblings('ul').hide()
    })

    const searchString = value.toLowerCase()
    if (searchString === '') {
      displayLis(getChildrenLis(document, organiseView))
      displayLis(getGrandchildrenLis(document, organiseView))
      return
    };

    const parentsWithFoundChildMatches = []
    const matchFoundInParent = parents.filter(function (p) {
      return getTextContent(p, organiseView).includes(searchString)
    })

    if (matchFoundInParent.length) {
      parentsWithFoundChildMatches.push.apply(parentsWithFoundChildMatches, matchFoundInParent)
    }

    // Check if search is in child categories
    parents.forEach(function (parent) {
      if (checkChildForUl(parent, organiseView)) {
        const childrenLis = Array.from(getChildrenLis(parent, organiseView))
        const matchFoundFirstChild = childrenLis.filter(function (child) {
          return getTextContent(child, organiseView).includes(searchString)
        })

        if (matchFoundFirstChild.length) {
          matchFoundFirstChild.forEach(function (child) {
            checkForSibblingsAndHide(child, searchString, organiseView)
            parentsWithFoundChildMatches.push(child.parentNode.parentNode)
            triggerExpandCategory(child.parentNode.parentNode.firstElementChild)
          })
        }

        childrenLis.forEach(function (child) {
          if (checkChildForUl(child, organiseView)) {
            const grandChildLis = Array.from(getGrandchildrenLis(parent, organiseView))
            const matchFoundSecondChild = grandChildLis.filter(function (grandChild) {
              return getTextContent(grandChild, organiseView).includes(searchString)
            })

            if (matchFoundSecondChild.length) {
              matchFoundSecondChild.forEach(function (gc) {
                checkForSibblingsAndHide(gc, searchString, organiseView)
                checkForSibblingsAndHide(gc.parentNode.parentNode, searchString, organiseView)
                triggerExpandCategory(gc.parentNode.parentNode.parentNode.parentNode.firstElementChild)
                triggerExpandCategory(gc.parentNode.parentNode.firstElementChild)
                parentsWithFoundChildMatches.push(gc.parentNode.parentNode.parentNode.parentNode)
              })
            }
          }
        })
      }
    })

    const parentsToRemove = parents.filter(function (el) { return !parentsWithFoundChildMatches.includes(el) })
    parentsToRemove.forEach(function (e) { e.style.display = 'none' })
  }

  function checkChildForUl(e, organiseView) {
    return !!e.querySelector(organiseView ? 'ul > li' : 'ul')
  }

  function getChildrenLis(p, organiseView) {
    const selector = organiseView
      ? '.category-search > ul > li > ul > li'
      : '#categories > .category-tree > ul > li > ul > li'
    return p.querySelectorAll(selector)
  }

  function getGrandchildrenLis(p, organiseView) {
    const selector = organiseView
      ? '.category-search > ul > li > ul > li > ul > li'
      : '#categories > .category-tree > ul > li > ul > li > ul > li'
    return p.querySelectorAll(selector)
  }

  function checkForSibblingsAndHide(child, searchString, organiseView) {
    Array.from(child.parentNode.children).forEach(function (c) {
      if (
        getTextContent(c, organiseView).includes(searchString) ||
        getTextContent(c, organiseView) === getTextContent(child, organiseView) ||
        parentHasChildrenMatches(c, searchString, organiseView)
      ) {
        c.style.display = 'block'
      } else {
        c.style.display = 'none'
      }
    })
  }

  function parentHasChildrenMatches(c, searchString, organiseView) {
    if (checkChildForUl(c, organiseView)) {
      const match = Array.from(c.querySelectorAll('ul > li')).filter(function (li) {
        return getTextContent(li, organiseView).includes(searchString)
      })
      return match.length > 0
    }
  }

  function getTextContent(e, organiseView) {
    return e.querySelector(organiseView ? 'label' : '.checkbox-input-label-text').textContent.trim().toLowerCase()
  }

  function displayLis(liNodeList) {
    const lis = Array.from(liNodeList)
    lis.forEach(function (li) {
      li.style.display = 'block'
    })
  }

  function triggerExpandCategory(e) {
    if (!e.classList.contains('expanded')) {
      e.click()
    }
  }

  ns.CategorySearchHelper = { searchCategories: searchCategories }
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {})
