(function ($, ns, undefined) {
  function createTag (name, target) {
    var item = document.createElement('li');
    item.innerText = target.children.length > 2 ? ' ' + name : name;
    item.classList.add('tag');

    var span = document.createElement('span');
    span.classList.add('remove');
    span.classList.add('icon');
    span.classList.add('icon-cross');

    span.addEventListener('click', function () {
      removeTag(this);
    });
    item.appendChild(span);
    $(target).children().last().before(item);
    if ($(target).siblings('.error').hasClass('visible'))
      $(target).siblings('.error').removeClass('visible');

    // Update metadatafield
    var mediaId = target.getAttribute('data-mediaid');
    var value = document.querySelector(
      'li.item-' + mediaId + ' .metadatatags'
    ).value;
    var spacing = value !== '' ? ', ' : '';
    document.querySelector('li.item-' + mediaId + ' .metadatatags').value =
      value + spacing + name;
  }

  function removeTag (element, updateMetadata) {
    var tagName = element.parentElement.textContent;
    var mediaId = element.parentElement.parentElement.getAttribute(
      'data-mediaid'
    );
    element.parentElement.parentElement.removeChild(element.parentElement);

    // update metadatafield
    if (updateMetadata !== false) {
      var value = document
        .querySelector('li.item-' + mediaId + ' .metadatatags')
        .value.split(',');
      value.splice(value.indexOf(tagName), 1);
      document.querySelector(
        'li.item-' + mediaId + ' .metadatatags'
      ).value = value.join(',');
    }
  }

  ns.CreateTagHelper = { 
    createTag: createTag,
    removeTag: removeTag
  }
  })(jQuery, window.ImageVaultUi = window.ImageVaultUi || {})
  