/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./ImageVault.ClientScript/Scripts/imagevault-client-script/scripts/ts/ivAmp/AzureMediaPlayer.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./ImageVault.ClientScript/Scripts/imagevault-client-script/scripts/ts/ivAmp/AzureMediaPlayer.ts":
/*!*******************************************************************************************************!*\
  !*** ./ImageVault.ClientScript/Scripts/imagevault-client-script/scripts/ts/ivAmp/AzureMediaPlayer.ts ***!
  \*******************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var NumberUtil_1 = __webpack_require__(/*! ../lib/NumberUtil */ "./ImageVault.ClientScript/Scripts/imagevault-client-script/scripts/ts/lib/NumberUtil.ts");
var IvMdResponse = (function () {
    function IvMdResponse() {
    }
    return IvMdResponse;
}());
exports.IvMdResponse = IvMdResponse;
var AzureMediaPlayer = (function () {
    function AzureMediaPlayer(id, options) {
        this.options = options || { debug: false };
        var videoElement = document.getElementById(id);
        if (!videoElement)
            throw "No element with id " + id + " was found";
        if (videoElement.tagName.toLocaleLowerCase() !== "video")
            throw "Element with id " + id + " is no video tag. (" + videoElement.tagName + ")";
        var source = videoElement.attributes["data-ivmdurl"].value;
        if (!source)
            throw "Missing attribute data-ivmdurl on video element " + id;
        this.id = id;
        this.source = source;
        this.videoElement = videoElement;
    }
    AzureMediaPlayer.setup = function (id, options) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, new Promise(function (resolve) { return __awaiter(_this, void 0, void 0, function () {
                        var player;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    player = new AzureMediaPlayer(id, options);
                                    player.log("Player created");
                                    return [4, player.initAsync()];
                                case 1:
                                    _a.sent();
                                    player.log("Init completed");
                                    resolve(player);
                                    return [2];
                            }
                        });
                    }); })];
            });
        });
    };
    AzureMediaPlayer.prototype.initAsync = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, new Promise(function (resolve, reject) { return __awaiter(_this, void 0, void 0, function () {
                        var self, ampOptions, response, myPlayer, sourceElement, textTracks;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    self = this;
                                    ampOptions = { "logo": { "enabled": false }, plugins: this.options.plugins };
                                    if (this.options.autoplay !== undefined) {
                                        ampOptions["autoplay"] = this.options.autoplay;
                                    }
                                    if (this.options.controls !== undefined) {
                                        ampOptions["controls"] = this.options.controls;
                                    }
                                    self.log("Resolving url " + this.source);
                                    return [4, this.resolveUrlAsync(this.source)];
                                case 1:
                                    response = _a.sent();
                                    if (!response) {
                                        reject("Failed to get video");
                                        return [2];
                                    }
                                    this.hideInfoScreen();
                                    self.log("Setting up player for url " + response.manifestUrl);
                                    myPlayer = amp(this.id, ampOptions);
                                    sourceElement = [
                                        { src: response.manifestUrl, type: "application/vnd.ms-sstr+xml" }
                                    ];
                                    textTracks = response.tracks;
                                    if (this.options.disableTextTracks)
                                        textTracks = null;
                                    myPlayer.src(sourceElement, textTracks);
                                    myPlayer.ready(function () {
                                        self.log("Player ready. Starting playback");
                                        if (self.options.autoplay !== false)
                                            myPlayer.play();
                                        else {
                                            myPlayer.play();
                                            myPlayer.pause();
                                        }
                                        resolve();
                                    });
                                    return [2];
                            }
                        });
                    }); })];
            });
        });
    };
    AzureMediaPlayer.prototype.log = function (msg) {
        if (this.options.debug && console && console.log)
            console.log(msg);
    };
    AzureMediaPlayer.prototype.resolveUrlAsync = function (url) {
        var _this = this;
        return new Promise(function (resolve, reject) { return __awaiter(_this, void 0, void 0, function () {
            var retry, r;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        retry = false;
                        _a.label = 1;
                    case 1:
                        retry = false;
                        return [4, this.getIvMdAsync(url)];
                    case 2:
                        r = _a.sent();
                        if (r.response) {
                            resolve(r.response);
                            return [2];
                        }
                        if (!(r.status === 503)) return [3, 4];
                        this.showInfoScreen(r.message || "Conversion in progress...", r.progress || 0);
                        return [4, AzureMediaPlayer.delay((r.retryAfter || 5) * 1000)];
                    case 3:
                        _a.sent();
                        retry = true;
                        return [3, 5];
                    case 4:
                        if (r.status === 404) {
                            this.showInfoScreen("Media was not found on server: " + r.status, -1);
                        }
                        else {
                            this.showInfoScreen("Failed to get resource. Response code " + r.status, -1);
                            this.log(r.message);
                        }
                        resolve(null);
                        _a.label = 5;
                    case 5:
                        if (retry) return [3, 1];
                        _a.label = 6;
                    case 6: return [2];
                }
            });
        }); });
    };
    AzureMediaPlayer.delay = function (ms) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, new Promise(function (resolve) { return setTimeout(resolve, ms); })];
            });
        });
    };
    AzureMediaPlayer.prototype.hideInfoScreen = function () {
        this.videoElement.style.display = "";
        if (this.infoElement) {
            this.infoElement.parentNode.removeChild(this.infoElement);
            this.infoElement = null;
        }
    };
    AzureMediaPlayer.prototype.showInfoScreen = function (message, progressPercent) {
        this.log(message + ":" + progressPercent + "%");
        if (!this.infoElement) {
            var parent = this.videoElement.parentNode;
            if (!parent.insertBefore) {
                return;
            }
            var info = this.infoElement = document.createElement("div");
            var borderWidth = 2;
            info.style.width = (this.videoElement.clientWidth - borderWidth * 2) + "px";
            info.style.height = (this.videoElement.clientHeight - borderWidth * 2) + "px";
            info.style.background = "black";
            info.style.border = borderWidth + "px inset white";
            info.style.display = "flex";
            info.style.flexDirection = "column";
            info.style.justifyContent = "center";
            info.style.alignItems = "center";
            info.style.fontFamily = "monospace";
            var m = this.messageElement = document.createElement("div");
            m.style.color = "white";
            m.style.fontSize = "14pt";
            m.style.paddingBottom = "20px";
            info.appendChild(m);
            var pp = this.progressBarBaseElement = document.createElement("div");
            pp.style.width = "95%";
            pp.style.height = "25px";
            pp.style.border = "black solid 1px";
            pp.style.background = "white";
            info.appendChild(pp);
            var p = this.progressBarElement = document.createElement("div");
            p.style.height = "25px";
            p.style.background = "blue";
            p.style.textAlign = "center";
            p.style.fontWeight = "bold";
            p.style.color = "white";
            p.style.fontSize = "18px";
            p.style.lineHeight = "25px";
            pp.appendChild(p);
            parent.insertBefore(info, this.videoElement.nextSibling);
            this.videoElement.style.display = "none";
        }
        this.videoElement.style.display = "none";
        this.messageElement.textContent = message;
        if (progressPercent < 0) {
            this.progressBarBaseElement.style.display = "none";
        }
        else {
            if (progressPercent > 100)
                progressPercent = 100;
            this.progressBarBaseElement.style.display = "";
            this.progressBarElement.style.width = progressPercent + "%";
            this.progressBarElement.textContent = progressPercent + "%";
        }
    };
    AzureMediaPlayer.prototype.getIvMdAsync = function (url) {
        var _this = this;
        return new Promise(function (resolve) {
            var xhr = new XMLHttpRequest();
            xhr.withCredentials = true;
            var resolved = false;
            xhr.onreadystatechange = function () {
                _this.log("onreadystatechange " + xhr.readyState + ":" + xhr.status + ":" + resolved);
                if (resolved)
                    return;
                if (xhr.readyState !== 4)
                    return;
                var response = { status: xhr.status };
                switch (response.status) {
                    case 200:
                        var data = JSON.parse(xhr.responseText);
                        if (data && data.manifestUrl) {
                            response.response = data;
                        }
                        else {
                            response.message = "Failed to retrieve manifest url. " + xhr.responseText;
                        }
                        break;
                    case 503:
                        response.retryAfter = NumberUtil_1.NumberUtil.parseInt(xhr.getResponseHeader("Retry-After"));
                        response.progress = NumberUtil_1.NumberUtil.parseInt(xhr.getResponseHeader("X-Progress-Percent"));
                        break;
                    default:
                        response.message = xhr.responseText;
                        break;
                }
                resolved = true;
                resolve(response);
                return;
            };
            xhr.open('GET', url, true);
            xhr.send();
        });
    };
    AzureMediaPlayer.initAllVideo = function (options) {
        var videos = document.getElementsByTagName("video");
        if (!videos || !videos.length)
            return;
        for (var i = 0; i < videos.length; i++) {
            var video = videos[i];
            var id = video.id;
            if (!id)
                continue;
            var ivMdUrl = video.attributes["data-ivmdurl"].value;
            if (!ivMdUrl)
                continue;
            var player = new AzureMediaPlayer(id, options);
            player.initAsync();
        }
    };
    AzureMediaPlayer.initDocument = function () {
        var init = function () {
            AzureMediaPlayer.initAllVideo();
        };
        if (window.addEventListener) {
            window.addEventListener("load", init);
        }
        else {
            window.onload = function () { return init; };
        }
    };
    return AzureMediaPlayer;
}());
exports.AzureMediaPlayer = AzureMediaPlayer;
(window.ImageVault = window.ImageVault || {}).AzureMediaPlayer = AzureMediaPlayer;
window.ImageVault.AzureMediaPlayer.initDocument();


/***/ }),

/***/ "./ImageVault.ClientScript/Scripts/imagevault-client-script/scripts/ts/lib/NumberUtil.ts":
/*!***********************************************************************************************!*\
  !*** ./ImageVault.ClientScript/Scripts/imagevault-client-script/scripts/ts/lib/NumberUtil.ts ***!
  \***********************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var NumberUtil = (function () {
    function NumberUtil() {
    }
    NumberUtil.parseInt = function (text, defaultValue) {
        var i = parseInt(text);
        if (isNaN(i))
            return defaultValue || 0;
        return i;
    };
    return NumberUtil;
}());
exports.NumberUtil = NumberUtil;


/***/ })

/******/ });
//# sourceMappingURL=ivAmp.min.js.map