/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/AzureMediaPlayer.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/AzureMediaPlayer.ts":
/*!*******************************************************************************************************!*\
  !*** ./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/AzureMediaPlayer.ts ***!
  \*******************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzureMediaPlayer = void 0;
var NumberUtil_1 = __webpack_require__(/*! ../lib/NumberUtil */ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/NumberUtil.ts");
var Util_1 = __webpack_require__(/*! ../lib/Util */ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/Util.ts");
var UriUtil_1 = __webpack_require__(/*! ../lib/UriUtil */ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/UriUtil.ts");
var LanguageUtil_1 = __webpack_require__(/*! ../lib/LanguageUtil */ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/LanguageUtil.ts");
__webpack_require__(/*! ../lib/Polyfills */ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/Polyfills.ts");
var ErrorUtil_1 = __webpack_require__(/*! ../lib/ErrorUtil */ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/ErrorUtil.ts");
var ElementResizer_1 = __webpack_require__(/*! ./ElementResizer */ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/ElementResizer.ts");
var EmbedResizeMode_1 = __webpack_require__(/*! ./EmbedResizeMode */ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/EmbedResizeMode.ts");
var MessageLevel_1 = __webpack_require__(/*! ./MessageLevel */ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/MessageLevel.ts");
var AzureMediaPlayer = (function () {
    function AzureMediaPlayer(id, options) {
        this.debugProgressNo = 0;
        this.disposed = false;
        this.preInitBackground = null;
        this.initPausedChecked = false;
        this.handlers = {};
        var videoElement = document.getElementById(id);
        if (!videoElement)
            throw "No element with id " + id + " was found";
        if (videoElement.tagName.toLocaleLowerCase() !== "video")
            throw "Element with id " + id + " is no video tag. (" + videoElement.tagName + ")";
        var baseOptions = this.getSetupOptionsFromVideoTag(videoElement) || { debug: false };
        var overrideOptions = options || {};
        this.options = Object.assign(baseOptions, overrideOptions);
        var source = this.options.manifestUrl || AzureMediaPlayer.getManifestUrlFromVideoTag(videoElement);
        if (!source)
            throw "Missing attribute " + AzureMediaPlayer.manifestUrlAttributeName + " on video element " + id;
        source = UriUtil_1.UriUtil.changeExtension(source, ".json");
        this.queryStringParams = UriUtil_1.UriUtil.getQueryStringParameters(source);
        this.id = id;
        this.source = source;
        this.videoElement = videoElement;
        this.beginPlayerInit();
        if (this.options.disableLoaderIcon) {
            this.videoElement.className += " disable-loader-icon";
        }
        this.userSettings = this.loadUserSettings();
        AzureMediaPlayer.players[id] = this;
    }
    AzureMediaPlayer.setupAsync = function (id, options) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, new Promise(function (resolve, reject) { return __awaiter(_this, void 0, void 0, function () {
                        var player, e_1;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    _a.trys.push([0, 2, , 3]);
                                    player = new AzureMediaPlayer(id, options);
                                    player.log("Player created");
                                    return [4, player.initAsync()];
                                case 1:
                                    _a.sent();
                                    player.log("Init completed");
                                    resolve(player);
                                    return [3, 3];
                                case 2:
                                    e_1 = _a.sent();
                                    (player || console).log("Init failed " + e_1);
                                    reject(e_1);
                                    return [3, 3];
                                case 3: return [2];
                            }
                        });
                    }); })];
            });
        });
    };
    AzureMediaPlayer.getManifestUrlFromVideoTag = function (video) {
        if (!video)
            return null;
        var dataAtt = video.attributes[AzureMediaPlayer.manifestUrlAttributeName];
        if (!dataAtt)
            return null;
        var manifestUrl = dataAtt.value;
        video.removeAttribute(AzureMediaPlayer.manifestUrlAttributeName);
        return manifestUrl;
    };
    AzureMediaPlayer.prototype.getSetupOptionsFromVideoTag = function (video) {
        if (!video)
            return null;
        var dataAtt = video.attributes[AzureMediaPlayer.setupOptionsAttributeName];
        if (!dataAtt)
            return null;
        var optionsString = dataAtt.value;
        try {
            var options = JSON.parse(optionsString);
            video.removeAttribute(AzureMediaPlayer.setupOptionsAttributeName);
            return options;
        }
        catch (e) {
            this.log("Failed to parse options from video attribute " + AzureMediaPlayer.setupOptionsAttributeName + "\n" + e);
        }
        return null;
    };
    AzureMediaPlayer.prototype.beginPlayerInit = function () {
        if (!this.options.displayDuringInit) {
            this.videoElement.className += " " + AzureMediaPlayer.loadingClassName;
            if (this.options.initBackground) {
                this.preInitBackground = this.videoElement.parentElement.style.background;
                this.videoElement.parentElement.style.background = this.options.initBackground;
            }
        }
    };
    AzureMediaPlayer.prototype.endPlayerInit = function () {
        try {
            var playerDom = document.getElementById(this.id);
            if (!playerDom) {
                this.warn("No player component was found " + this.id + ". It might have been removed. Player init interrupted");
            }
            else {
                if (this.options.embedResizeMode === EmbedResizeMode_1.EmbedResizeMode.ScaleToFill || this.options.embedResizeMode === EmbedResizeMode_1.EmbedResizeMode.ScaleToFit) {
                    var ar = this.player.videoWidth() / this.player.videoHeight();
                    this.playerResizer = new ElementResizer_1.ElementResizer(playerDom, this.options.embedResizeMode, ar, this);
                }
            }
            var startAt = NumberUtil_1.NumberUtil.parseFloat(this.options.startAt);
            if (startAt > 0 && startAt < this.player.duration()) {
                this.player.currentAbsoluteTime(startAt);
            }
            if (playerDom && !this.options.displayDuringInit) {
                playerDom.className = playerDom.className.replace(" " + AzureMediaPlayer.loadingClassName, "");
                if (this.options.initBackground) {
                    playerDom.parentElement.style.background = this.preInitBackground;
                }
            }
        }
        catch (e) {
            this.error("endPlayerInit failed: " + e);
        }
    };
    AzureMediaPlayer.prototype.loadUserSettings = function () {
        try {
            var json = window.localStorage.getItem(AzureMediaPlayer.userSettingsStorageKey);
            if (json) {
                return JSON.parse(json);
            }
        }
        catch (e) {
            this.log("Failed to read user settings from local storage, falling back to local. " + ErrorUtil_1.ErrorUtil.toString(e));
        }
        return AzureMediaPlayer.defaultUserSettings;
    };
    AzureMediaPlayer.prototype.saveUserSettings = function () {
        try {
            window.localStorage.setItem(AzureMediaPlayer.userSettingsStorageKey, JSON.stringify(this.userSettings));
        }
        catch (e) {
            this.log("Failed to save user settings " + ErrorUtil_1.ErrorUtil.toString(e));
        }
    };
    AzureMediaPlayer.prototype.addEventListener = function (message, handler) {
        var self = this;
        var wrap = function () { handler(self.player); };
        if (this.player) {
            this.player.addEventListener(message, wrap);
        }
        else {
            this.handlers[message] = wrap;
        }
    };
    AzureMediaPlayer.prototype.findActiveTextTrack = function (language, tracks) {
        try {
            if (!tracks || !tracks.length || !language) {
                return null;
            }
            var languages = language.split(/\s*,\s*/);
            for (var i = 0; i < languages.length; i++) {
                var lang = languages[i].toLowerCase();
                for (var j = 0; j < tracks.length; j++) {
                    var track = tracks[j];
                    if (track.kind !== "subtitles" && track.kind !== "captions")
                        continue;
                    if (track.srclang && track.srclang.toLowerCase() === lang)
                        return track;
                }
            }
        }
        catch (e) {
            this.log("Error finding active text track " + e);
        }
        return null;
    };
    AzureMediaPlayer.prototype.getMatchingTextTrackByUrl = function (url, tracks) {
        if (!url || !tracks || !tracks.length)
            return null;
        for (var i = 0; i < tracks.length; i++) {
            if (url == tracks[i].src)
                return tracks[i];
        }
        return null;
    };
    AzureMediaPlayer.prototype.getMatchingPlayerTrackByUrl = function (url, tracks) {
        if (!url || !tracks || !tracks.length)
            return null;
        for (var i = 0; i < tracks.length; i++) {
            if (url == tracks[i].src)
                return tracks[i];
        }
        return null;
    };
    AzureMediaPlayer.prototype.handleResize = function () {
        if (this.playerResizer) {
            this.playerResizer.resize();
        }
    };
    AzureMediaPlayer.prototype.initAsync = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2, new Promise(function (resolve, reject) { return __awaiter(_this, void 0, void 0, function () {
                        var self_1, ampOptions, response, sourceElement, textTracks, textDictionary_1, activeTextTrack, i, suggestedActiveTextTrackLanguage, events, e_2;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    _a.trys.push([0, 2, , 3]);
                                    self_1 = this;
                                    ampOptions = {
                                        logo: { enabled: false },
                                        plugins: this.options.plugins,
                                        skinConfig: {}
                                    };
                                    ampOptions["nativeControlsForTouch"] = false;
                                    ampOptions["language"] = AzureMediaPlayer.lu.currentLanguage();
                                    if (this.options.autoplay !== undefined) {
                                        ampOptions.autoplay = this.options.autoplay;
                                    }
                                    if (this.options.muted !== undefined) {
                                        ampOptions.muted = this.options.muted;
                                    }
                                    if (this.options.controls !== undefined) {
                                        ampOptions.controls = this.options.controls;
                                    }
                                    if (this.options.disableFullscreen) {
                                        ampOptions.hotKeys = { enableFullscreen: false };
                                    }
                                    self_1.log(AzureMediaPlayer.lu.translate("Resolving url") + " " + this.source);
                                    return [4, this.resolveUrlAsync(this.source)];
                                case 1:
                                    response = _a.sent();
                                    this.hideInfoScreen();
                                    self_1.log("Setting up player for url " + response.manifestUrl);
                                    self_1.player = amp(this.id, ampOptions);
                                    sourceElement = [
                                        { src: response.manifestUrl, type: "application/vnd.ms-sstr+xml" }
                                    ];
                                    textTracks = response.tracks;
                                    textDictionary_1 = {};
                                    textTracks.forEach(function (t) { textDictionary_1[t.src] = t.srclang; });
                                    activeTextTrack = void 0;
                                    if (this.options.disableTextTracks) {
                                        textTracks = null;
                                    }
                                    else {
                                        if (textTracks && textTracks.length) {
                                            for (i = 0; i < textTracks.length; i++) {
                                                if (textTracks[i].kind === "subtitles")
                                                    textTracks[i].kind = "captions";
                                                textTracks[i].src = UriUtil_1.UriUtil.addQueryStringParameters(textTracks[i].src, this.queryStringParams);
                                            }
                                            suggestedActiveTextTrackLanguage = this.options.activeTextTrackLanguage || this.userSettings.textLanguage;
                                            activeTextTrack = this.findActiveTextTrack(suggestedActiveTextTrackLanguage, textTracks);
                                            if (!activeTextTrack && this.userSettings.textLanguage) {
                                                activeTextTrack = textTracks[0];
                                            }
                                        }
                                    }
                                    self_1.player.src(sourceElement, textTracks);
                                    if (activeTextTrack) {
                                        this.activePlayerTextTrack = this.getMatchingPlayerTrackByUrl(activeTextTrack.src, self_1.player.textTracks());
                                    }
                                    events = Object.keys(self_1.handlers);
                                    events.forEach(function (e) {
                                        self_1.player.addEventListener(e, self_1.handlers[e]);
                                    });
                                    self_1.handlers = {};
                                    self_1.player.ready(function () {
                                        try {
                                            if (self_1.options.disableFullscreen) {
                                                var fullscreenButton = document.getElementsByClassName("vjs-fullscreen-control")[0];
                                                if (fullscreenButton) {
                                                    fullscreenButton.style.display = "none";
                                                }
                                            }
                                            self_1.log("Player ready. Starting playback");
                                            var playButton = document.getElementsByClassName("vjs-big-play-button")[0];
                                            if (playButton) {
                                                playButton.style.top = "50%";
                                                playButton.style.left = "50%";
                                                playButton.style.transform = "translate(-50%, -50%)";
                                            }
                                            try {
                                                if (self_1.activePlayerTextTrack) {
                                                    self_1.player.setActiveTextTrack(self_1.activePlayerTextTrack);
                                                }
                                            }
                                            catch (e) {
                                                self_1.log("Failed to set active text track language" + e);
                                            }
                                            self_1.player.addEventListener(amp.eventName.play, function () {
                                                self_1.log("play");
                                            });
                                            self_1.player.addEventListener(amp.eventName.start, function () {
                                                if (!self_1.activePlayerTrackChangedInterval) {
                                                    var waitForTrackToBeLoaded = 0;
                                                    var interval = 2000;
                                                    if (self_1.activePlayerTextTrack)
                                                        waitForTrackToBeLoaded = 1;
                                                    self_1.activePlayerTrackChangedInterval = window.setInterval(function () {
                                                        if (waitForTrackToBeLoaded > 0) {
                                                            self_1.log("waiting for active track to be loaded");
                                                            waitForTrackToBeLoaded--;
                                                            return;
                                                        }
                                                        try {
                                                            var currentTextTrack = self_1.player.getCurrentTextTrack();
                                                            if (!currentTextTrack) {
                                                                if (!self_1.activePlayerTextTrack)
                                                                    return;
                                                                if (!self_1.userSettings.textLanguage)
                                                                    return;
                                                                self_1.log("User turned of text language");
                                                                self_1.activePlayerTextTrack = null;
                                                                self_1.userSettings.textLanguage = null;
                                                                self_1.saveUserSettings();
                                                                return;
                                                            }
                                                            if (self_1.activePlayerTextTrack && self_1.activePlayerTextTrack.src == currentTextTrack.src)
                                                                return;
                                                            self_1.activePlayerTextTrack = currentTextTrack;
                                                            self_1.log("User changed text track url to " + currentTextTrack.src);
                                                            var srclang = textDictionary_1[currentTextTrack.src];
                                                            if (!srclang) {
                                                                self_1.log("Cannot find matching text track for url " + currentTextTrack.src);
                                                                return;
                                                            }
                                                            if (srclang == self_1.userSettings.textLanguage)
                                                                return;
                                                            self_1.log("User changed text language to " + srclang);
                                                            self_1.userSettings.textLanguage = srclang;
                                                            self_1.saveUserSettings();
                                                            return;
                                                        }
                                                        catch (e) {
                                                            self_1.log("Failed to track track changes " + ErrorUtil_1.ErrorUtil.toString(e));
                                                            window.clearInterval(self_1.activePlayerTrackChangedInterval);
                                                        }
                                                    }, interval);
                                                }
                                                self_1.log("start");
                                            });
                                            self_1.player.addEventListener(amp.eventName.playing, function () {
                                                self_1.log("playing");
                                                if (!self_1.initPausedChecked) {
                                                    self_1.initPausedChecked = true;
                                                    if (self_1.options.initPaused) {
                                                        self_1.log("Pausing initPaused");
                                                        self_1.player.pause();
                                                        var startAt = NumberUtil_1.NumberUtil.parseFloat(self_1.options.startAt) || 0;
                                                        if (startAt < 0) {
                                                            startAt = 0;
                                                        }
                                                        if (startAt > self_1.player.duration()) {
                                                            startAt = self_1.player.duration();
                                                        }
                                                        self_1.log("SetStart to " + startAt);
                                                        self_1.player.currentAbsoluteTime(startAt);
                                                    }
                                                }
                                            });
                                            self_1.player.addEventListener(amp.eventName.resume, function () { self_1.log("resume"); });
                                            self_1.player.addEventListener(amp.eventName.loadeddata, function (amp) {
                                                self_1.log("loaded data");
                                                self_1.endPlayerInit();
                                            });
                                            if (self_1.options.loop) {
                                                self_1.player.addEventListener(amp.eventName.ended, function (amp) {
                                                    var startAt = NumberUtil_1.NumberUtil.parseFloat(self_1.options.startAt) || 0;
                                                    self_1.log("ended, looping from " + startAt);
                                                    self_1.player.currentAbsoluteTime(startAt);
                                                    self_1.player.play();
                                                });
                                            }
                                            var settingsView = document.getElementsByClassName("vjs-caption-settings")[0];
                                            if (self_1.player.width() < 480 || self_1.player.height() < 340) {
                                                var scale = Math.min(self_1.player.width() / 480.0, self_1.player.height() / 340.0);
                                                settingsView.style.top = "50%";
                                                settingsView.style.height = "20em";
                                                var strTransform = "translate(-50%, -55%) scale(" + scale.toString() + ")";
                                                settingsView.style.webkitTransform = strTransform;
                                                settingsView.style.transform = strTransform;
                                            }
                                            resolve();
                                        }
                                        catch (e) {
                                            reject(e);
                                        }
                                    });
                                    return [3, 3];
                                case 2:
                                    e_2 = _a.sent();
                                    reject(e_2);
                                    return [3, 3];
                                case 3: return [2];
                            }
                        });
                    }); })];
            });
        });
    };
    AzureMediaPlayer.prototype.dispose = function () {
        this.disposed = true;
        if (this.playerResizer) {
            this.playerResizer.dispose();
            this.playerResizer = null;
        }
        window.clearInterval(this.activePlayerTrackChangedInterval);
        if (this.player)
            this.player.dispose();
    };
    AzureMediaPlayer.prototype.log = function (msg, force) {
        if (force === void 0) { force = false; }
        if ((this.options.debug || force) && console && console.log)
            console.log(msg);
    };
    AzureMediaPlayer.prototype.warn = function (msg) {
        this.log("WARN: " + msg, true);
    };
    AzureMediaPlayer.prototype.error = function (msg) {
        this.log("ERROR: " + msg, true);
    };
    AzureMediaPlayer.prototype.resolveUrlAsync = function (url) {
        var _this = this;
        return new Promise(function (resolve, reject) { return __awaiter(_this, void 0, void 0, function () {
            var r, shouldRetryAutomatically, e_3;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 9, , 10]);
                        _a.label = 1;
                    case 1:
                        if (this.disposed)
                            throw "Player disposed";
                        if (!this.options.debugProgress) return [3, 3];
                        this.showInfoScreen(Object.assign({ message: AzureMediaPlayer.lu.translate("Conversion in progress..."), progress: this.debugProgressNo }, r), MessageLevel_1.MessageLevel.Info);
                        this.debugProgressNo++;
                        if (this.debugProgressNo > 100)
                            this.debugProgressNo = 0;
                        return [4, AzureMediaPlayer.delay(200)];
                    case 2:
                        _a.sent();
                        return [3, 7];
                    case 3: return [4, this.getIvMdAsync(url)];
                    case 4:
                        r = _a.sent();
                        if (r.response) {
                            resolve(r.response);
                            return [2];
                        }
                        if (!(r.status === 503)) return [3, 6];
                        shouldRetryAutomatically = r.retryAfter > 0;
                        if (!shouldRetryAutomatically) {
                            throw r.message;
                        }
                        this.showInfoScreen(Object.assign({ message: AzureMediaPlayer.lu.translate("Conversion in progress..."), progress: 0 }, r), MessageLevel_1.MessageLevel.Info);
                        return [4, AzureMediaPlayer.delay((r.retryAfter || 5) * 1000)];
                    case 5:
                        _a.sent();
                        return [3, 7];
                    case 6:
                        if (r.status === 404) {
                            throw AzureMediaPlayer.lu.translate("Media was not found on server") + ": " + r.status;
                        }
                        else {
                            throw AzureMediaPlayer.lu.translate("Failed to get resource") + " " + url + ". " + AzureMediaPlayer.lu.translate("Response code") + " " + r.status;
                        }
                        _a.label = 7;
                    case 7:
                        if (true) return [3, 1];
                        _a.label = 8;
                    case 8: return [3, 10];
                    case 9:
                        e_3 = _a.sent();
                        this.showInfoScreen(Object.assign(r || { status: -1 }, { message: e_3, progress: -1 }), MessageLevel_1.MessageLevel.Error);
                        this.log(e_3);
                        reject(e_3);
                        return [3, 10];
                    case 10: return [2];
                }
            });
        }); });
    };
    AzureMediaPlayer.delay = function (ms) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, new Promise(function (resolve) { return setTimeout(resolve, ms); })];
            });
        });
    };
    AzureMediaPlayer.prototype.hideInfoScreen = function () {
        this.videoElement.style.display = "";
        if (this.infoElement) {
            this.infoElement.parentNode.removeChild(this.infoElement);
            this.infoElement = null;
        }
    };
    AzureMediaPlayer.prototype.showInfoScreen = function (response, level) {
        var message = response.message;
        var progressPercent = response.progress || -1;
        var moreInformation = response.moreInformation;
        this.log(message + ":" + progressPercent + "%");
        if (!this.infoElement) {
            var parent_1 = this.videoElement.parentNode;
            if (!parent_1.insertBefore) {
                return;
            }
            var info = this.infoElement = document.createElement("div");
            info.className = "ivAmp-info";
            if (this.options.embedResizeMode === EmbedResizeMode_1.EmbedResizeMode.Default) {
                info.style.width = this.videoElement.clientWidth + "px";
                info.style.height = this.videoElement.clientHeight + "px";
            }
            else {
                info.style.width = "100%";
                info.style.height = "100%";
            }
            var m = this.messageElement = document.createElement("div");
            m.className = "message";
            info.appendChild(m);
            var pp = this.progressBarBaseElement = document.createElement("div");
            pp.className = "progress-bar";
            info.appendChild(pp);
            var p = this.progressBarElement = document.createElement("div");
            pp.appendChild(p);
            parent_1.insertBefore(info, this.videoElement.nextSibling);
        }
        var messageClass = "message message-" + MessageLevel_1.MessageLevel[level].toString().toLowerCase();
        this.messageElement.className = messageClass;
        this.videoElement.style.display = "none";
        message = Util_1.Util.htmlEncode(message);
        message = message.replace(/[\012\015]+/g, "<br/>");
        if (moreInformation) {
            message += "<br/><a href='" + moreInformation + "' target='_contact_meriworks'>" + AzureMediaPlayer.lu.translate("Contact us for more information") + "</a>";
        }
        this.messageElement.innerHTML = message;
        if (progressPercent < 0) {
            this.progressBarBaseElement.style.display = "none";
        }
        else {
            if (progressPercent > 100)
                progressPercent = 100;
            this.progressBarBaseElement.style.display = "";
            this.progressBarElement.style.width = progressPercent + "%";
        }
    };
    AzureMediaPlayer.prototype.getIvMdAsync = function (url) {
        var _this = this;
        return new Promise(function (resolve) {
            var xhr = new XMLHttpRequest();
            xhr.withCredentials = true;
            var resolved = false;
            xhr.onreadystatechange = function () {
                _this.log("onreadystatechange " + xhr.readyState + ":" + xhr.status + ":" + resolved);
                if (resolved)
                    return;
                if (xhr.readyState !== 4)
                    return;
                var response = { status: xhr.status };
                switch (response.status) {
                    case 200:
                        var data = JSON.parse(xhr.responseText);
                        if (data && data.manifestUrl) {
                            response.response = data;
                        }
                        else {
                            response.message = AzureMediaPlayer.lu.translate("Failed to retrieve manifest url") + ". " + xhr.responseText;
                        }
                        break;
                    case 503:
                        response.retryAfter = NumberUtil_1.NumberUtil.parseInt(xhr.getResponseHeader("Retry-After"), null);
                        response.progress = NumberUtil_1.NumberUtil.parseInt(xhr.getResponseHeader("X-Progress-Percent"));
                        response.exceptionType = xhr.getResponseHeader("X-Exception-Type");
                        response.message = xhr.getResponseHeader("X-Exception-Message");
                        response.moreInformation = xhr.getResponseHeader("X-More-Information");
                        if (response.message)
                            response.message = response.message.replace(/%0a/ig, "\n");
                        response.message = decodeURIComponent(escape(response.message));
                        break;
                    default:
                        response.message = xhr.responseText;
                        break;
                }
                resolved = true;
                resolve(response);
                return;
            };
            xhr.open('GET', url, true);
            xhr.send();
        });
    };
    AzureMediaPlayer.initAllVideo = function (options) {
        options = options || {};
        var videos = document.getElementsByTagName("video");
        if (!videos || !videos.length)
            return;
        for (var i = 0; i < videos.length; i++) {
            var video = videos[i];
            var id = video.id;
            if (!id)
                continue;
            var manifestUrl = this.getManifestUrlFromVideoTag(video);
            if (!manifestUrl)
                continue;
            options.manifestUrl = manifestUrl;
            var player = new AzureMediaPlayer(id, options);
            player.initAsync();
        }
    };
    AzureMediaPlayer.initDocument = function () {
        var init = function () {
            AzureMediaPlayer.initAllVideo();
        };
        if (window.addEventListener) {
            window.addEventListener("load", init);
        }
        else {
            window.onload = function () { return init; };
        }
    };
    AzureMediaPlayer.defaultUserSettings = {};
    AzureMediaPlayer.players = {};
    AzureMediaPlayer.loadingClassName = "init-loading";
    AzureMediaPlayer.manifestUrlAttributeName = "data-ivmdurl";
    AzureMediaPlayer.setupOptionsAttributeName = "data-ivsetup";
    AzureMediaPlayer.lu = LanguageUtil_1.LanguageUtil.registerTranslations("AzureMediaPlayer", ["sv", "no", "de"], {
        "Failed to retrieve manifest url": [
            "Misslyckades att hämta manifestfilen",
            "Kunne ikke hente manifest url",
            "Manifest-URL konnte nicht abgerufen werden"
        ],
        "Resolving url": [
            "Hämtar url",
            "Løse url",
            "URL auflösen"
        ],
        "Conversion in progress...": [
            "Konvertering pågår...",
            "Konvertering pågår...",
            "Umstellung läuft..."
        ],
        "Media was not found on server": [
            "Videon hittades inte på servern",
            "Media ble ikke funnet på serveren",
            "Medien wurden auf dem Server nicht gefunden"
        ],
        "Failed to get resource": [
            "Kunde inte hämta resurs",
            "Kunne ikke skaffe ressurs",
            "Ressource konnte nicht abgerufen werden"
        ],
        "Response code": [
            "Svarskod",
            "Responskode",
            "Antwortcode"
        ],
        "Contact us for more information": [
            "Kontakta oss för mer information",
            "Kontakt oss for mer informasjon",
            "Kontaktieren Sie uns für weitere Informationen"
        ]
    });
    AzureMediaPlayer.userSettingsStorageKey = "IV-AzureMediaPlayer-UserSettings";
    return AzureMediaPlayer;
}());
exports.AzureMediaPlayer = AzureMediaPlayer;
(window.ImageVault = window.ImageVault || {}).AzureMediaPlayer = AzureMediaPlayer;
window.ImageVault.AzureMediaPlayer.initDocument();


/***/ }),

/***/ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/ElementResizer.ts":
/*!*****************************************************************************************************!*\
  !*** ./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/ElementResizer.ts ***!
  \*****************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ElementResizer = void 0;
var EmbedResizeMode_1 = __webpack_require__(/*! ./EmbedResizeMode */ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/EmbedResizeMode.ts");
var ElementResizer = (function () {
    function ElementResizer(element, resizeMode, aspectRatio, logger) {
        if (aspectRatio === void 0) { aspectRatio = 0; }
        if (logger === void 0) { logger = null; }
        var self = this;
        this.element = element;
        this.parent = element.parentElement;
        this.aspectRatio = aspectRatio || element.clientWidth / element.clientHeight;
        this.resizeMode = resizeMode;
        this.logger = logger || { log: function () { } };
        this.resize();
        window.addEventListener("resize", function () { self.resize(); });
        return this;
    }
    ElementResizer.prototype.dispose = function () {
        window.removeEventListener("resize", this.resize);
    };
    ElementResizer.prototype.resize = function () {
        if (this.resizeMode !== EmbedResizeMode_1.EmbedResizeMode.ScaleToFill && this.resizeMode !== EmbedResizeMode_1.EmbedResizeMode.ScaleToFit)
            return;
        var w = this.parent.clientWidth;
        var h = this.parent.clientHeight;
        if (this.parent.tagName.toLowerCase() === "body") {
            w = window.innerWidth;
            h = window.innerHeight;
        }
        var pa = w / h;
        var cw = w;
        var ch = h;
        var mt = 0;
        var ml = 0;
        var targetMoreLandscape = pa > this.aspectRatio;
        var keepHeight = this.resizeMode === EmbedResizeMode_1.EmbedResizeMode.ScaleToFit && targetMoreLandscape
            || this.resizeMode === EmbedResizeMode_1.EmbedResizeMode.ScaleToFill && !targetMoreLandscape;
        if (keepHeight) {
            cw = this.aspectRatio * ch;
            ml = (w - cw) / 2;
            this.element.style.marginTop = "0";
            this.element.style.marginLeft = ml + "px";
        }
        else {
            ch = cw / this.aspectRatio;
            mt = (h - ch) / 2;
            this.element.style.marginTop = mt + "px";
            this.element.style.marginLeft = "0";
        }
        this.element.style.width = cw + "px";
        this.element.style.height = ch + "px";
        this.logger.log("" + EmbedResizeMode_1.EmbedResizeMode[this.resizeMode].toString() + " (" + cw + "," + ch + ") (" + ml + "," + mt + ") inside (" + w + "," + h + ")");
    };
    return ElementResizer;
}());
exports.ElementResizer = ElementResizer;


/***/ }),

/***/ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/EmbedResizeMode.ts":
/*!******************************************************************************************************!*\
  !*** ./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/EmbedResizeMode.ts ***!
  \******************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.EmbedResizeMode = void 0;
var EmbedResizeMode;
(function (EmbedResizeMode) {
    EmbedResizeMode[EmbedResizeMode["Default"] = 0] = "Default";
    EmbedResizeMode[EmbedResizeMode["ScaleToFit"] = 1] = "ScaleToFit";
    EmbedResizeMode[EmbedResizeMode["ScaleToFill"] = 2] = "ScaleToFill";
})(EmbedResizeMode = exports.EmbedResizeMode || (exports.EmbedResizeMode = {}));


/***/ }),

/***/ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/MessageLevel.ts":
/*!***************************************************************************************************!*\
  !*** ./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/ivAmp/MessageLevel.ts ***!
  \***************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageLevel = void 0;
var MessageLevel;
(function (MessageLevel) {
    MessageLevel[MessageLevel["Info"] = 0] = "Info";
    MessageLevel[MessageLevel["Success"] = 1] = "Success";
    MessageLevel[MessageLevel["Warning"] = 2] = "Warning";
    MessageLevel[MessageLevel["Error"] = 3] = "Error";
})(MessageLevel = exports.MessageLevel || (exports.MessageLevel = {}));


/***/ }),

/***/ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/ErrorUtil.ts":
/*!**********************************************************************************************!*\
  !*** ./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/ErrorUtil.ts ***!
  \**********************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorUtil = void 0;
var ErrorUtil = (function () {
    function ErrorUtil() {
    }
    ErrorUtil.isError = function (error) {
        return error.message !== undefined;
    };
    ErrorUtil.toString = function (error) {
        var msg = "Unknown";
        if (typeof error === 'string')
            return error;
        if (this.isError(error))
            return error.message;
        if (error) {
            if (error.exception) {
                msg = error.exception.message;
            }
            else {
                msg = error.statusCode + " - " + error.statusText;
            }
        }
        return msg;
    };
    return ErrorUtil;
}());
exports.ErrorUtil = ErrorUtil;


/***/ }),

/***/ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/LanguageUtil.ts":
/*!*************************************************************************************************!*\
  !*** ./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/LanguageUtil.ts ***!
  \*************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.LanguageUtil = void 0;
var LanguageUtil = (function () {
    function LanguageUtil(baseKey, fallbackLanguage) {
        if (fallbackLanguage === void 0) { fallbackLanguage = "en"; }
        this._baseKey = baseKey;
        this._fallbackLanguage = fallbackLanguage;
    }
    LanguageUtil.prototype.currentLanguage = function () {
        return document.documentElement.lang || navigator.language || this._fallbackLanguage;
    };
    LanguageUtil.prototype.currentTranslations = function () {
        return LanguageUtil._languages[this.currentLanguage()] || {};
    };
    LanguageUtil.prototype.translate = function (key, fallback) {
        var k = this._baseKey + key;
        var t = this.currentTranslations();
        return t[k] || fallback || key;
    };
    LanguageUtil.registerTranslations = function (baseKey, languages, translations) {
        if (!translations)
            return;
        languages.map(function (lang, langIndex) {
            var langData = LanguageUtil._languages[lang];
            if (!langData) {
                langData = {};
                LanguageUtil._languages[lang] = langData;
            }
            Object.keys(translations).map(function (key) {
                var tray = translations[key];
                if (!tray || !tray.length || tray.length <= langIndex)
                    return;
                var value = translations[key][langIndex];
                var k = baseKey + key;
                langData[k] = value;
            });
        });
        return new LanguageUtil(baseKey);
    };
    LanguageUtil._languages = {};
    return LanguageUtil;
}());
exports.LanguageUtil = LanguageUtil;


/***/ }),

/***/ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/NumberUtil.ts":
/*!***********************************************************************************************!*\
  !*** ./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/NumberUtil.ts ***!
  \***********************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.NumberUtil = void 0;
var NumberUtil = (function () {
    function NumberUtil() {
    }
    NumberUtil.parseInt = function (text, defaultValue) {
        var i = parseInt(text);
        if (isNaN(i))
            return defaultValue || 0;
        return i;
    };
    NumberUtil.parseFloat = function (text, defaultValue) {
        var f = parseFloat(text);
        if (isNaN(f))
            return defaultValue || 0;
        return f;
    };
    return NumberUtil;
}());
exports.NumberUtil = NumberUtil;


/***/ }),

/***/ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/Polyfills.ts":
/*!**********************************************************************************************!*\
  !*** ./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/Polyfills.ts ***!
  \**********************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

if (typeof Object.assign !== 'function') {
    Object.defineProperty(Object, "assign", {
        value: function assign(target, varArgs) {
            'use strict';
            if (target === null || target === undefined) {
                throw new TypeError('Cannot convert undefined or null to object');
            }
            var to = Object(target);
            for (var index = 1; index < arguments.length; index++) {
                var nextSource = arguments[index];
                if (nextSource !== null && nextSource !== undefined) {
                    for (var nextKey in nextSource) {
                        if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
                            to[nextKey] = nextSource[nextKey];
                        }
                    }
                }
            }
            return to;
        },
        writable: true,
        configurable: true
    });
}


/***/ }),

/***/ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/UriUtil.ts":
/*!********************************************************************************************!*\
  !*** ./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/UriUtil.ts ***!
  \********************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.UriUtil = void 0;
var UriUtil = (function () {
    function UriUtil() {
    }
    UriUtil.toQueryString = function (q) {
        if (!q)
            return "";
        var queryString = Object.keys(q).map(function (key) {
            return encodeURIComponent(key) + '=' + encodeURIComponent(q[key]);
        }).join('&');
        return queryString;
    };
    UriUtil.changeExtension = function (url, extension) {
        var rex = /^((?:(?:\w+:)?\/\/[^\/]+\/)?[^?]*?)(\.[^\.\?]*)?($|\?.*$)/i;
        if (!url)
            return url;
        var m = url.match(rex);
        if (!m)
            return url;
        extension = extension || "";
        if (extension && extension.length && extension[0] !== '.')
            extension = "." + extension;
        var newUrl = m[1] + extension + m[3];
        return newUrl;
    };
    UriUtil.getQueryStringParameters = function (url) {
        var p = {};
        if (!url)
            return p;
        var rex = /\?(.*)(\#.*)?$/i;
        var m = url.match(rex);
        if (!m)
            return p;
        var qs = m[1];
        if (!qs)
            return p;
        var kv = qs.split("&");
        for (var i = 0; i < kv.length; i++) {
            var pair = kv[i].split("=");
            var key = decodeURIComponent(pair[0]);
            var value = decodeURIComponent(pair.length > 1 ? pair[1] : "");
            p[key] = value;
        }
        return p;
    };
    UriUtil.stripQuery = function (url) {
        if (!url)
            return url;
        var i = url.indexOf("?");
        if (i >= 0)
            return url.substring(0, i);
        return url;
    };
    UriUtil.addQueryStringParameters = function (url, queryStringParams) {
        if (!url)
            return url;
        if (!queryStringParams || !Object.keys(queryStringParams).length)
            return url;
        var q = UriUtil.getQueryStringParameters(url);
        var baseUrl = UriUtil.stripQuery(url);
        if (!q || !Object.keys(q).length) {
            q = queryStringParams;
        }
        else {
            q = Object.assign(queryStringParams, q);
        }
        return baseUrl + "?" + UriUtil.toQueryString(q);
    };
    return UriUtil;
}());
exports.UriUtil = UriUtil;


/***/ }),

/***/ "./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/Util.ts":
/*!*****************************************************************************************!*\
  !*** ./ImageVault.ClientScript/scripts/imagevault-client-script/scripts/ts/lib/Util.ts ***!
  \*****************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Util = void 0;
var Util = (function () {
    function Util() {
    }
    Util.has = function (object, key) {
        return object ? object.hasOwnProperty(key) : false;
    };
    Util.get = function (object, key, defaultValue) {
        return Util.has(object, key) ? object[key] : defaultValue;
    };
    Util.formatString = function (str) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        if (!str)
            return str;
        return str.replace(/{(\d+)}/g, function (a, b) {
            return args[b];
        });
    };
    Util.htmlEncode = function (str) {
        if (!str)
            return "";
        if ((typeof str) !== "string")
            str = str.toString();
        return str
            .replace(/&/g, '&amp;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#39;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/\//g, '&#x2F;');
    };
    return Util;
}());
exports.Util = Util;


/***/ })

/******/ });
//# sourceMappingURL=ivAmp.min.js.map