(function(ns) { 
var editor = (function () {
    function twoDigitString(inPut) {
        var outPut = inPut.toString();
        if (inPut < 10) {
            outPut = "0" + outPut;
        }
        return outPut;
    }

    function secondsToTimeString(timeInSeconds) {
        var hours = Math.floor(timeInSeconds / 3600),
            minutes = Math.floor(timeInSeconds / 60) % 60,
            seconds = Math.floor(timeInSeconds) % 60;
        return twoDigitString(hours) + ":" + twoDigitString(minutes) + ":" + twoDigitString(seconds);
    }

    function text(x, y, width, font, style) {
        return {
            x: x,
            y: y,
            width: width,
            font: font,
            style: style
        };
    }
    function rect(x, y, w, h) {
        return {
            x: x,
            y: y,
            width: w,
            height: h
        };
    }
    function house(width, height, roof, fillStyle, strokeStyle, lineWidth, pointingTo) {
        return {
            width: width,
            height: height,
            roof: roof,
            fillStyle: fillStyle,
            strokeStyle: strokeStyle,
            lineWidth: lineWidth,
            pointingTo: pointingTo
        };
    }

    return {
        create: function (myVideo, myCanvas, settings) {
            var vid = document.getElementById(myVideo);
            var canvas = document.getElementById(myCanvas);
            var ctx = canvas.getContext("2d");
            var isSubClipEditor = true;
            var start = 0;

            var videoDuration = Math.floor(vid.duration);

            var stop = videoDuration;

            var canvasWidth = document.getElementById("player1").offsetWidth;

            var videoWidth = vid.offsetWidth;
            var videoHeight = vid.offsetHeight;

            canvas.width = canvasWidth;
            canvas.height = 80;
            if (settings !== undefined) {
                if (settings.editor !== undefined) {
                    isSubClipEditor = !!settings.editor;
                }
                if (settings.start !== undefined && settings.start > 0 && settings.start < videoDuration) {
                    start = settings.start;
                }
                if (settings.stop !== undefined && settings.stop > 0 && settings.stop < videoDuration) {
                    stop = settings.stop;
                }
                if (start > stop) {
                    var temp = start;
                    start = stop;
                    stop = temp;
                } else if (start === stop) {
                    if (start > 0) {
                        start -= 1;
                    } else {
                        stop += 1;
                    }
                }
            }
            var meta = { "start": Math.floor(start), "stop": Math.floor(stop) };
            var initData = { "start": Math.floor(start), "stop": Math.floor(stop) };

            var movingStart = false;
            var movingStop = false;
            var movingCurrent = false;
            var isSubClickPlay = false;

            var coverBoxStyle = "#fff";
            var subClipBarStyle = "#c3c3c3";
            var subClipDurationBarStyle = "#333333";
            var startStopHouseStyle = "#330000";
            var startStopHouseStroke = "#333333";
            var currentHouseStroke = "grey";
            var currentHouseStyle = "#333333";
            var playPauseButtonStyle = "#1364a3";
            var increaseDecreaseButtonStyle = "#333333";
            var textWidth = 52;
            var textFont = "12px";
            var textStyle = "#333333";

            var coverBox = rect(0, 0, canvasWidth, 74);
            var widthForDurationTime = 100;
            var subClipBar = rect(30, 30, Math.round(coverBox.width) - widthForDurationTime, 15);

            var startText = text(subClipBar.x, subClipBar.y - 15, textWidth, textFont, textStyle);
            var stopText = text(subClipBar.x + subClipBar.width - 62, startText.y, textWidth, textFont, textStyle);

            var subClipDurationText = text(subClipBar.x + subClipBar.width + 12, startText.y, textWidth, textFont, textStyle);
            var fullTimeDurationText = text(subClipDurationText.x, subClipBar.y + 12, textWidth, textFont, textStyle);

            var currentTimeText = text(subClipBar.x, subClipBar.y + subClipBar.height + 25, textWidth, textFont, textStyle);
            var currentTimeTextMinusWidth = 24;

            var subPlayButton = rect(subClipBar.x - 23, subClipBar.y, 15, 15);
            var currentTimeMover = rect(subClipBar.x, subClipBar.y + subClipBar.height, 5, subClipBar.height / 2);

            var subDecreaseStart = rect(startText.x - 15, startText.y - 10, 10, 10);
            var subIncreaseStart = rect(startText.x + textWidth, startText.y - 10, 10, 10);
            var subDecreaseStop = rect(stopText.x - 15, stopText.y - 10, 10, 10);
            var subIncreaseStop = rect(stopText.x + textWidth, stopText.y - 10, 10, 10);

            var startHouse = house(9, 9, 3, startStopHouseStyle, startStopHouseStroke, 1, "down");
            var stopHouse = house(9, 9, 3, startStopHouseStyle, startStopHouseStroke, 1, "down");
            var currentHouse = house(9, 9, 3, currentHouseStyle, currentHouseStroke, 1, "up");

            var pixelsPerSec = subClipBar.width / videoDuration;

            var secPerPixel = videoDuration / subClipBar.width;

            var startXpos = meta.start * pixelsPerSec + subClipBar.x;
            var stopXpos = meta.stop * pixelsPerSec + subClipBar.x;

            var pauseButtonlineWidth = 5;

            if (isSubClipEditor === false) {
                subClipDurationBarStyle = "#c3c3c3";
                coverBox = rect(0, 0, vid.clientWidth, 47);
                subClipBar = rect(30, 3, coverBox.width - widthForDurationTime, 15);
                subPlayButton = rect(subClipBar.x - 23, subClipBar.y, 15, 15);
                currentTimeMover = rect(subClipBar.x, subClipBar.y + subClipBar.height, 5, subClipBar.height / 2);
                currentTimeText = text(subClipBar.x, subClipBar.y + subClipBar.height + 25, textWidth, textFont, textStyle);
                fullTimeDurationText = text(subClipDurationText.x, subClipBar.y + 12, textWidth, textFont, textStyle);
            }

            function drawRectangle(x, y, width, height, fillStyle) {
                ctx.fillStyle = fillStyle;
                ctx.fillRect(x, y, width, height);
            }

            function drawTriangle(x, y, width, height, style, pointingTo) {
                ctx.fillStyle = style;
                ctx.beginPath();
                if (pointingTo === "left") {
                    ctx.moveTo(x + width, y);
                    ctx.lineTo(x, y + (height / 2));
                    ctx.lineTo(x + width, y + height);
                } else if (pointingTo === "right") {
                    ctx.moveTo(x, y);
                    ctx.lineTo(x + width, y + (height / 2));
                    ctx.lineTo(x, y + height);
                }
                ctx.fill();
                ctx.closePath();
            }

            function drawText(text, x, y, width, font, style) {
                ctx.font = font;
                ctx.fillStyle = style;
                ctx.fillText(text, x, y, width);
            }

            function drawLine(fromX, fromY, toX, toY, width, style) {
                ctx.lineWidth = width;
                ctx.strokeStyle = style;
                ctx.beginPath();
                ctx.moveTo(fromX, fromY);
                ctx.lineTo(toX, toY);
                ctx.stroke();
                ctx.closePath();
            }

            function drawHouse(x, y, myHouse, useStroke) {
                ctx.fillStyle = myHouse.fillStyle;
                ctx.strokeStyle = myHouse.strokeStyle;
                ctx.lineWidth = myHouse.lineWidth;
                ctx.beginPath();
                ctx.moveTo(x, y);
                if (myHouse.pointingTo === "up") {
                    ctx.lineTo(x + (myHouse.width / 2), y + (myHouse.height / myHouse.roof));
                    ctx.lineTo(x + (myHouse.width / 2), y + myHouse.height);
                    ctx.lineTo(x - (myHouse.width / 2), y + myHouse.height);
                    ctx.lineTo(x - (myHouse.width / 2), y + (myHouse.height / myHouse.roof));
                } else if (myHouse.pointingTo === "down") {
                    ctx.lineTo(x + (myHouse.width / 2), y - (myHouse.height / myHouse.roof));
                    ctx.lineTo(x + (myHouse.width / 2), y - myHouse.height);
                    ctx.lineTo(x - (myHouse.width / 2), y - myHouse.height);
                    ctx.lineTo(x - (myHouse.width / 2), y - (myHouse.height / myHouse.roof));
                }
                ctx.lineTo(x, y);
                ctx.fill();
                if (useStroke) {
                    ctx.stroke();
                }
                ctx.closePath();
            }

            function draw() {
                //clear entire canvas
                ctx.clearRect(0, 0, canvas.width, canvas.height);
                //draw box around things defined under
                drawRectangle(coverBox.x, coverBox.y, coverBox.width, coverBox.height, coverBoxStyle);
                //draw sub clip bar
                drawRectangle(subClipBar.x, subClipBar.y, subClipBar.width, subClipBar.height, subClipBarStyle);
                //draw bar between sub clip start and stop
                drawRectangle(startXpos, subClipBar.y, stopXpos - startXpos, subClipBar.height, subClipDurationBarStyle);
                //draw current time marker inside current time bar
                drawHouse(currentTimeMover.x, subClipBar.y + subClipBar.height, currentHouse, false);
                // draw sub clip play/pause button
                if (vid.paused) {
                    drawTriangle(subPlayButton.x, subPlayButton.y, subPlayButton.width, subPlayButton.height, playPauseButtonStyle, "right");
                } else {
                    drawLine(subPlayButton.x + (subPlayButton.width / 5), subPlayButton.y, subPlayButton.x + (subPlayButton.width / 5), subPlayButton.y + subPlayButton.height, pauseButtonlineWidth, playPauseButtonStyle);
                    drawLine(subPlayButton.x + (subPlayButton.width * 4 / 5), subPlayButton.y, subPlayButton.x + (subPlayButton.width * 4 / 5), subPlayButton.y + subPlayButton.height, pauseButtonlineWidth, playPauseButtonStyle);
                }
                drawText(secondsToTimeString(Math.floor(vid.currentTime)), currentTimeText.x, currentTimeText.y, currentTimeText.width, currentTimeText.font, currentTimeText.style);
                drawText(secondsToTimeString(Math.floor(vid.duration)), fullTimeDurationText.x, fullTimeDurationText.y, fullTimeDurationText.width, fullTimeDurationText.font, fullTimeDurationText.style);
                //draw isSubClipEditor = true parts
                if (isSubClipEditor) {
                    drawText(secondsToTimeString(meta.stop - meta.start), subClipDurationText.x, subClipDurationText.y, subClipDurationText.width, subClipDurationText.font, subClipDurationText.style);
                    //draw increase/decrease sub clip time buttons 
                    drawTriangle(subIncreaseStart.x, subIncreaseStart.y, subIncreaseStart.width, subIncreaseStart.height, increaseDecreaseButtonStyle, "right");
                    drawTriangle(subDecreaseStart.x, subDecreaseStart.y, subDecreaseStart.width, subDecreaseStart.height, increaseDecreaseButtonStyle, "left");
                    drawTriangle(subIncreaseStop.x, subIncreaseStop.y, subIncreaseStop.width, subIncreaseStop.height, increaseDecreaseButtonStyle, "right");
                    drawTriangle(subDecreaseStop.x, subDecreaseStop.y, subDecreaseStop.width, subDecreaseStop.height, increaseDecreaseButtonStyle, "left");
                    // draw time texts
                    drawHouse(stopXpos, subClipBar.y, stopHouse, false);
                    drawHouse(startXpos, subClipBar.y, startHouse, false);
                    drawText(secondsToTimeString(meta.start), startText.x, startText.y, startText.width, startText.font, startText.style);
                    drawText(secondsToTimeString(meta.stop), stopText.x, stopText.y, stopText.width, stopText.font, stopText.style);
                }
            }

            function setCurrentTime(inputTime) {
                if (inputTime >= 0 && inputTime <= vid.duration) {
                    currentTimeMover.x = (inputTime * pixelsPerSec) + subClipBar.x;
                    currentTimeText.x = currentTimeMover.x - currentTimeTextMinusWidth;
                    vid.currentTime = inputTime;
                }
                draw();
            }

            function setStartStop(start, stop) {
                if (start >= 0 && start < stop && stop <= vid.duration) {
                    meta.start = Math.floor(start);
                    meta.stop = Math.floor(stop);
                    startXpos = (meta.start * pixelsPerSec) + subClipBar.x;
                    stopXpos = (meta.stop * pixelsPerSec) + subClipBar.x;
                }
                draw();
            }

            vid.addEventListener('timeupdate', function () {
                if (isSubClickPlay && this.currentTime >= meta.stop) {
                    this.pause();
                    isSubClickPlay = false;
                }
                currentTimeMover.x = (this.currentTime * pixelsPerSec) + subClipBar.x;
                currentTimeText.x = currentTimeMover.x - currentTimeTextMinusWidth;
                draw();
            });

            function play() {
                if (vid.paused) {
                    if (vid.currentTime < meta.stop) {
                        isSubClickPlay = true;
                    }
                    vid.play();
                } else {
                    vid.pause();
                }
            }

            function isMouseInCanvasArea(event, x, y, width, height) {
                if (event.pageX < x + width + canvas.offsetLeft &&
                    event.pageX > x - width + canvas.offsetLeft &&
                    event.pageY < y + height + canvas.offsetTop &&
                    event.pageY > y + canvas.offsetTop) {
                    return true;
                }
                return false;
            }

            function myMove(event) {
                if (movingStart) {
                    setStartStop(Math.floor((event.pageX - canvas.offsetLeft - subClipBar.x) * secPerPixel), meta.stop);
                    setCurrentTime(meta.start);
                } else if (movingStop) {
                    setStartStop(meta.start, Math.floor((event.pageX - canvas.offsetLeft - subClipBar.x) * secPerPixel));
                    setCurrentTime(meta.stop);
                } else if (movingCurrent) {
                    setCurrentTime((event.pageX - canvas.offsetLeft - subClipBar.x) * secPerPixel);
                }
            }

            function myDown(event) {
                if (isMouseInCanvasArea(event, startXpos - (startHouse.width / 2), subClipBar.y - startHouse.height, startHouse.width, startHouse.height)) {
                    setCurrentTime(meta.start);
                    movingStart = true;
                    canvas.onmousemove = myMove;
                } else if (isMouseInCanvasArea(event, stopXpos - (stopHouse.width / 2), subClipBar.y - stopHouse.height, stopHouse.width, stopHouse.height)) {
                    setCurrentTime(meta.stop);
                    movingStop = true;
                    canvas.onmousemove = myMove;
                } else if (isMouseInCanvasArea(event, currentTimeMover.x - (currentHouse.width / 2), currentTimeMover.y, currentHouse.width, currentHouse.height)) {
                    movingCurrent = true;
                    canvas.onmousemove = myMove;
                } else if (isMouseInCanvasArea(event, subPlayButton.x, subPlayButton.y, subPlayButton.width, subPlayButton.height)) {
                    play();
                } else if (isMouseInCanvasArea(event, subIncreaseStart.x, subIncreaseStart.y, subIncreaseStart.width, subIncreaseStart.height)) {
                    setStartStop(meta.start + 1, meta.stop);
                    setCurrentTime(meta.start);
                } else if (isMouseInCanvasArea(event, subDecreaseStart.x, subDecreaseStart.y, subDecreaseStart.width, subDecreaseStart.height)) {
                    setStartStop(meta.start - 1, meta.stop);
                    setCurrentTime(meta.start);
                } else if (isMouseInCanvasArea(event, subIncreaseStop.x, subIncreaseStop.y, subIncreaseStop.width, subIncreaseStop.height)) {
                    setStartStop(meta.start, meta.stop + 1);
                    setCurrentTime(meta.stop);
                } else if (isMouseInCanvasArea(event, subDecreaseStop.x, subDecreaseStop.y, subDecreaseStop.width, subDecreaseStop.height)) {
                    setStartStop(meta.start, meta.stop - 1);
                    setCurrentTime(meta.stop);
                }
            }

            function myUp() {
                movingStart = false;
                movingStop = false;
                movingCurrent = false;
                canvas.onmousemove = null;
            }

            setStartStop(start, stop);
            setCurrentTime(Math.floor(start));

            draw();
            canvas.onmousedown = myDown;
            canvas.onmouseup = myUp;

            return {
                getVideoDuration:function() {
                    return videoDuration;
                },
                getOriginalStartTime: function () {
                    return initData.start;
                },
                getOriginalStopTime: function () {
                    return initData.stop;
                },
                getStartTime: function () {
                    return meta.start;
                },
                getStopTime: function () {
                    return meta.stop;
                },
                getDuration: function () {
                    return meta.stop - meta.start;
                },
                getWidth: function () {
                    return videoWidth;
                },
                getHeight: function () {
                    return videoHeight;
                }
            };
        }
    };
})();

    editor.initPlayer = function(myVideo, myCanvas, settings) {
        return editor.create(myVideo, myCanvas, settings);
    };
    ns.VideoEditor2 = editor;
})(window.ImageVault || (window.ImageVault = {}));