﻿(function ($, ns) {
    var bottombar = function (config) {
        this.init(config);
        return this;
    };
    bottombar.prototype = {
        //properties
        $domobject: null,
        sortMenuPopup: null,
        //functions
        init: function (config) {
            $.extend(this, config);
            var self = this;
            this.$domobject = $('#sort-order');
            var dompopup = $("#sort-menu");
            this.sortMenuPopup = new ImageVaultUi.PopupMenu({ $domobject: dompopup });

            //adjust position of popup so it centers above the text
            this.sortMenuPopup.bind("beforeShow", function () {
                //Calculate position of menu
                var position = Math.round((self.$domobject.width() / 2 + self.$domobject.position().left) - 61);
                dompopup.css('left', position);
            });
            //handle all click events
            this.sortMenuPopup.bind("all", function (eventName) {
                if (!MeridiumUtil.endsWith(eventName, "Click"))
                    return true;
                var selectedOrder = eventName.substr(0, eventName.length - "Click".length);
                var o = selectedOrder.split("-");
                var sortOrder = $.bbq.getState('order');
                if (sortOrder) {
                    $.bbq.pushState({ 'prev-order': sortOrder + "-" + $.bbq.getState('direction')});
                }
                //Add order to hash
                $.bbq.pushState({ 'order': o[0], 'direction': o[1] });
                //Update anchor text
                self.updateSelectedSortText();
                //Set cookie
                var cookieData = ImageVaultUi.Common.getJsonCookie("ImageVaultCookieData");
                cookieData["SortOrder"] = selectedOrder;
                ImageVaultUi.Common.setCookie("ImageVaultCookieData", cookieData, 1);
                return false;
            });
            //Sort order anchor click event
            this.$domobject.click(function () {
                self.sortMenuPopup.toggle();
                return false;
            });

            //The user has done something. Find out what
            $(window).bind('hashchange', function (e) {
                self.updateSelectedSortText();
            });
        },
        updateSelectedSortText: function () {
            //Get order from hash
            var order = $.bbq.getState('order');
            var direction = $.bbq.getState('direction');
            if (!order) {
                var cookieData = ImageVaultUi.Common.getJsonCookie("ImageVaultCookieData");
                var sortOrder = cookieData["SortOrder"];
                if (sortOrder) {
                    sortOrder = sortOrder.split("-");
                    $.bbq.pushState({ 'order': sortOrder[0], 'direction': sortOrder[1] });
                    order = sortOrder[0];
                    direction = sortOrder[1];
                }
            }
            var item = this.sortMenuPopup.get('$domobject').find('a[data-name=' + order + '-' + direction + ']');
            if (item.length === 0)
                return;
            var name = item.text();
            this.$domobject.text(name);

        }
    };
    ns.BottomBar = bottombar;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});