﻿(function($, ns, undefined) {
    var infoPanel = Backbone.Model.extend({
        //properties
        currentId: null,
        $domobject: null,
        $viewport: null,
        $noItemSelected: null,
        $loading: null,
        cookieTimeout: null,
        currentScrollTop: undefined,
        isMobile: false,
        isTouchDevice: null,
        jScrollPane: null,
        //methods
        initialize: function() {
            this.$domobject = this.get("$domobject");
            this.isMobile = (window.outerWidth <= 991);

            if (this.$domobject === undefined)
                throw "$domobject is not defined in config";
            this.$viewport = $("#details-viewport #scrollable", this.$domobject);
            if (this.$viewport.length === 0)
                throw "Cannot find tab div in $domobject";
            this.$noItemSelected = $("#details-no-mediaitem-selected", this.$domobject);
            if (this.$noItemSelected.length === 0)
                throw "Cannot find $noItemSelected in $domobject";
            this.$loading = $(".loading", this.$domobject);
            if (this.$loading.length === 0)
                throw "Cannot find $loading in $domobject";

            var self = this;

            app.bind("deleteDialog:fileDeleted", this.fileDeleted, this);
            app.bind("collectionDialog:removedFromCollection", this.fileDeleted, this);
            app.bind("category:edited", this.refresh, this);
            app.bind("category:deleted", this.refresh, this);

            app.bind("agreementDialog:agreementSaved", this.refresh, this);
            app.bind("agreementDialog:agreementDeleted", this.refresh, this);
            app.bind("lightbox:hasChanged", this.lightboxChanged, this);
            this.updateSelectedTab();

            // Initiate new scroll
            $(window).resize(function() {
                self.initScrollPane();
            });

            $("li a", this.$domobject).click(function() {
                //ignore events if the no items selected is visible...
                if ($(":visible", self.$noItemSelected).length > 0) {
                    return false;
                }
                var newTab = $(this).attr("data-name");
                self.loadTab(newTab);
                return false;
            });

            $("a.close", this.$domobject).click(function() {
                $.bbq.pushState("items", null);
                self.$domobject.removeClass("item-selected");
                $("body").removeClass("item-selected")
                if (self.currentScrollTop !== undefined)
                    $(document).scrollTop(self.currentScrollTop);
                app.trigger("display:refresh");
                return false;
            });

            app.bind("media:versionchange", this.refresh, this);

            if (!this.isMobile) {
                // Resizable on details
                $("#details").resizable({
                    minWidth: 235,
                    maxWidth: 500,
                    handles: "w, sw",
                    start: function() {
                        var resizeMaxWidth = $("#toolbar").width() - 600 - $("#nav").width();
                        resizeMaxWidth = resizeMaxWidth > 500 ? 500 : resizeMaxWidth;
                        resizeMaxWidth = resizeMaxWidth < 300 ? 300 : resizeMaxWidth;
                        $("#details").resizable("option", "maxWidth", resizeMaxWidth);
                    },
                    resize: function() {
                        var resizeWidth = $("#details").width();

                        // Move actions
                        $("ul#actions").css("right", resizeWidth);

                        // Change padding for display options
                        $("#display-options").css("padding-right", resizeWidth);

                        // Move column buttons
                        $(".columns").css("margin-right", resizeWidth + 13 + "px");

                        // Move delete button
                        $("#toolbar>ul>li.delete a").css("right", (8 - resizeWidth) + "px");

                        clearTimeout(self.cookieTimeout);

                        self.cookieTimeout = setTimeout(function() {
                                // Set cookie for width of details column
                                var cookieData = ImageVaultUi.Common.getJsonCookie("ImageVaultCookieData");
                                cookieData["DetailsColumnWidth"] = resizeWidth;
                                ImageVaultUi.Common.setCookie("ImageVaultCookieData", cookieData, 1);
                            },
                            500);

                        // Update image size
                        self.updateDetailsImage(resizeWidth);

                        // Event for changing column size in library
                        app.trigger("column:changingsize");
                    },
                    stop: function() {
                        // Reinititialize scrollbars for library
                        app.trigger("column:changedsize");

                        self.initScrollPane();
                    }
                }).live("resize", function(e) {
                    e.stopPropagation();

                });
            }
        },

        //refreshes the current view
        refresh: function() {
            this.show(this.currentId, true);
        },
        //shows the supplied media item and updates the current tab
        // @id, the id of the item to show or 0 if no item should be shown
        // @force, true if the tab should be reloaded even if the same item already is displayed there.
        show: function(id, force) {
            var self = this;
            //if not force and we should display the same as current, do nothing
            if (id && id > 0) {
                //save old scrollTop for mobile devices
                if (this.isMobile) {
                    this.currentScrollTop = $(document).scrollTop();
                } else {
                    this.currentScrollTop = undefined;
                }
                $("body").addClass("item-selected");
                this.$domobject.addClass("item-selected");
                //if we have a new id, reload the current frame
                if (force || this.currentId !== id) {
                    this.showLoading();
                    this.loadTab(this.getSelectedTab(), id, function(error) {

                        self.showContent();
                        // if (!error) {
                        //     self.$viewport.show(0, function() {
                        //         // todo maybe this should be placed in another backbone view and be fired by an event
                        //         $("#metadata-tabs").find("a").removeClass("inactive");
                        //     });
                        // }
                    });
                } else {
                    this.showContent();
                }
            } else {
                this.showNoItems();
                $("body").removeClass("item-selected");
                this.$domobject.removeClass("item-selected");
            }
        },
        fileDeleted: function() {
            this.show(null);
        },
        getSelectedTab: function() {
            var currentTab = "information";
            if ($.bbq.getState("infotab") === "metadata")
                currentTab = "metadata";
            return currentTab;
        },
        setSelectedTab: function(tab) {
            $.bbq.pushState({ infotab: tab });
            this.updateSelectedTab();
        },
        updateSelectedTab: function() {
            var currentTab = this.getSelectedTab();
            $("li a", this.$domobject).removeClass("selected");
            $("li a[data-name='" + currentTab + "']", this.$domobject).addClass("selected");
        },
        showNoItems: function() {
            this.$viewport.hide(0, function() {
                // call destroy on the custom scrollbar
                ($("#details-viewport").jScrollPane().data().jsp).destroy();
                // todo maybe this should be placed in another backbone view and be fired by an event
                // we also need to remove the event and add a return false event
                $("#metadata-tabs").find("a").addClass("inactive");
            });
            this.$loading.hide();
            this.$noItemSelected.show();
        },
        showLoading: function() {
            this.$loading.show();
            this.$viewport.hide();
            this.$noItemSelected.hide();
        },
        showContent: function() {
            this.$loading.hide();
            this.$noItemSelected.hide();
            this.$viewport.show(0, function() {
                // todo maybe this should be placed in another backbone view and be fired by an event
                $("#metadata-tabs").find("a").removeClass("inactive");
            });
        },
        loadTab: function(tab, id, callback) {
            var self = this;
            // add notification
            // ReSharper disable once InconsistentNaming
            var action = "information";
            if (tab === "metadata") {
                action = "metadata";
            }
            //if no id is specified, use the current one
            if (id === undefined)
                id = this.currentId;
            app.load({
                controller: "library",
                action: action,
                data: { id: id },
                success: function(data) {
                    self.$viewport.html(data);
                    self.$viewport.attr("data-item-id", id);
                    self.setSelectedTab(action);
                    self.currentId = id;

                    if (self.attributes.isTouchDevice) {
                        $("a.agreement-link", this.$domobject).click(function() {
                            return false;
                        });
                    } else {
                        // Show agreement dialog on click
                        $("a.agreement-link", this.$domobject).click(function(ev) {
                            new ImageVaultUi.AgreementDialog({ agreementId: $(ev.currentTarget).attr("data-agreement-id") }).open();
                            return false;
                        });
                    };
                    if (callback)
                        callback();
                },
                complete: function() {
                    self.initViewport();
                },
                error: function(error) {
                    self.showNoItems();
                    callback(error);
                }
            });
        },
        initViewport: function() {
            var self = this;
            //makes sure we init scroll pane when image container resizes (image is loaded)
            $("#image-container", self.$domobject).find("img").bind("load", function() {
                self.initScrollPane();
                self.updateAreaOfInterest();
            });
            self.initScrollPane();

            // Set cookie for width of details column
            var cookieData = ImageVaultUi.Common.getJsonCookie("ImageVaultCookieData");

            self.updateDetailsImage(cookieData["DetailsColumnWidth"] || 235);
        },

        updateAreaOfInterest: function () {
            if (!$("#areaOfInterest").length) {
                return;
            }

            var img = document.querySelector(".image-content > img");
            var y = $("#areaOfInterest").attr("data-pos-y") * img.clientHeight;
            var x = $("#areaOfInterest").attr("data-pos-x") * img.clientWidth;
            var w = $("#areaOfInterest").attr("data-width") * img.clientWidth;
            var h = $("#areaOfInterest").attr("data-height") * img.clientHeight;

            $("#areaOfInterest").css("top", y + img.offsetTop + "px")
            $("#areaOfInterest").css("left", x + img.offsetLeft + "px")
            $("#areaOfInterest").css("height", h + "px")
            $("#areaOfInterest").css("width", w + "px")
        },
        updateDetailsImage: function(width) {
            // Which attribute to use depending on width
            var widthToUse = "data-small-src";

            if (width > 240)
                widthToUse = "data-medium-src";

            if (width > 340)
                widthToUse = "data-large-src";

            $("#details img").first().attr("src", $("#details img").attr(widthToUse));

            // Recalculate max-width/max-height for image in order to stabilize the rendering of SVG files on IE11
            var maxWidth = $("#details span.image-content").first().width();
            var maxHeight = $("#details span.image-content").first().height();

            // Compute the ratios of the image and its container.
            var containerRatio = maxWidth / maxHeight;
            var imgRatio = $("#details img").first().data("width") / $("#details img").first().data("height");

            // Adapt the dimensions to fit into the container.
            if (imgRatio > containerRatio) {
                maxHeight = maxWidth / imgRatio;
            } else {
                maxWidth = maxHeight * imgRatio;
            }

            // Set the dimensions for the image.
            $("#details img").first().css("max-width", maxWidth + "px");
            $("#details img").first().css("max-height", maxHeight + "px");
        },

        reinitializeScroll: function() {

            // Reinitialize scrollbars
            var jsp = this.jScrollPane.data("jsp");

            if (jsp) {
                jsp.reinitialise();
            }
        },
        lightboxChanged: function() {
            var self = this;
            setTimeout(function() {
                self.initScrollPane();
            }, 200);
        },
        initScrollPane: function() {
            // //Calculate height och scrollable area            
            // var height = $("#library").height() - 74;
            // $("#details-viewport").height(height);
            if (this.jScrollPane) {
                var jsp = this.jScrollPane.data("jsp");

                if (jsp) {
                    jsp.destroy()
                }
            }
            this.jScrollPane = $("#details-viewport").jScrollPane();
            this.reinitializeScroll();
        }
    });
    ns.InfoPanel = infoPanel;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});