﻿(function ($, ns) {
    var libraryView = function (config) {
        this.init(config);
        return this;
    };
    libraryView.prototype = {
        //Properties
        isLoading: true,
        loading: null,
        currentPageNo: 0,
        pageSize: 100,
        lastCount: null,
        maxCount: 50,
        ivUiAjax: null,
        jScrollPane: null,
        shiftKeyDown: false,
        ctrlKeyDown: false,
        $lastSelectedItem: null, // Item that is selected
        $chosenItem: null, // Item that is chosen for details/information/metadata
        draggableTimeout: null,
        browser: null,
        client: null,
        insertMode: null,
        vaults: null,
        nav: null,
        toolbar: null,
        bottomBar: null,
        infopanel: null,
        thumbnailFormatId: null,
        reinitializeScrollTimeout: null,
        changeImageTimeOut: null,
        insertMultiple: null,
        tabSearch: null,
        usingSearchEngine: false,
        // Methods / Events
        onSearchFailed: null,
        totalCount: null, // todo: get from search result
        _client: null,
        isTouchDevice: null,
        advancedSearchElements: {
            $allSearchFilterButtons: null,
            $allSearchDropdowns: null
        },

        //
        // initialize method
        //
        init: function (config) {
            var self = this;

            //map external functions
            $.extend(this, config);

            // Set current browser
            this.browser = ImageVaultUi.Common.getBrowserName();

            self.isTouchDevice = navigator.userAgent.match(/(iPhone|iPod|iPad|Android|BlackBerry)/);
            if (self.isTouchDevice) {
                $("body").addClass("touchDevice");
            }

            this._client = new ImageVault.Client({
                core: "/api",
                authMethod: "none"
            });


            this.nav = new ImageVaultUi.Nav({});

            this.toolbar = new ImageVaultUi.Toolbar({
                $domobject: $("#toolbar"),
                thumbnailFormatId: self.thumbnailFormatId,
                libraryView: self,
                maxCount: self.maxCount,
                insertMultiple: self.insertMultiple
            });
            this.bottomBar = new ImageVaultUi.BottomBar({});
            this.lightbox = new ImageVaultUi.Lightbox({
                $domobject: $("#lightbox"),
                thumbnailFormatId: self.thumbnailFormatId,
                maxCount: self.maxCount
            });

            this.infoPanel = new ImageVaultUi.InfoPanel({
                $domobject: $("#details"),
                isTouchDevice: self.isTouchDevice
            });

            this.editCurrentUserDialog = new ImageVaultUi.EditCurrentUserDialog({});

            self.printLibraryMessage();

            //Event for opening admin dialog
            $("#admin-anchor").click(function () {
                $.bbq.pushState({ 'admin-tab': "rights" });
                ImageVaultUi.AdminView.OpenDialog();
                return false;
            });

            $("#edit-user").click(function () {
                self.editCurrentUserDialog.open();
            });

            app.bind("collectionDialog:removedFromCollection", this.updateLibraryViewSettings, this);
            app.bind("media:versionchange", function () { self.performSearch(0, true); });
            app.bind("metadatadefinition:changed", function () { self.performSearch(0, true); });
            app.bind("metadatadefinition:deleted", function () { self.performSearch(0, true); });
            app.bind("column:changedsize", this.reinitializeScroll, this);
            app.bind("column:changingsize", this.updateLibraryViewSettings, this);
            app.bind("display:refresh", function () { self.$masonry.masonry("layout"); });
            app.bind("selection:changed", this.setSelectedItems, this);
            app.bind("navlibrarytab:collectionSelected", this.setSelectedItems, this);
            app.bind("navlibrarytab:vaultSelected", this.setSelectedItems, this);
            app.bind("navagreementstab:agreementSelected", function () { self.performSearch(0); });
            app.bind("scope:filterRemoved", function () { self.performSearch(0); });
            app.bind("deleteDialog:itemsRemoved", this.setSelectedItems, this);
            app.bind("deleteDialog:fileDeleted", function (deletedItems) {
                self.$masonry.masonry("layout");
                self.totalCount = self.totalCount - deletedItems.length;
                $("search-media-typegroups").attr("data-filecount", self.totalCount);
                self.printLibraryMessage();
            }, this);
            app.bind("lightbox:selected",
                function () {
                    // Update info panel
                    self.infoPanel.show(0);

                    // Unselect all items
                    $("#stream ul li.selected").removeClass("selected");

                    // Save selected items (zero)
                    self.setSelectedItems();
                });

            app.bind("lightbox:hasChanged", this.updateLibraryViewSettings, this);

            //Event triggers when a url hash fragment changes
            $(window).bind("hashchange",
                function (e) {
                    $("#SearchQuery").val($.bbq.getState("search"));

                    var currentTab = $.bbq.getState("tab");
                    var performSearchOnTabChange = false;
                    if (currentTab !== self.tabSearch) {
                        if (currentTab === ImageVaultUi.NavigationEvents.tabs.agreement ||
                            self.tabSearch === ImageVaultUi.NavigationEvents.tabs.agreement) {
                            performSearchOnTabChange = true;
                        }
                        self.tabSearch = currentTab;
                    }
                    //Check if a search should be performed
                    if (performSearchOnTabChange ||
                        app.hasStateChanged("vaults") ||
                        app.hasStateChanged("categories") ||
                        app.hasStateChanged("search") ||
                        app.hasStateChanged("order") ||
                        app.hasStateChanged("direction") ||
                        app.hasStateChanged("collections") ||
                        app.hasStateChanged("agreements") ||
                        app.hasStateChanged("em") ||
                        app.hasStateChanged("mediaTypeGroups") ||
                        app.hasStateChanged("mediaSizeGroups") ||
                        app.hasStateChanged("mediaOrientations") ||
                        app.hasStateChanged("mediaMetadataOptions") ||
                        app.hasStateChanged(ImageVaultUi.NavigationEvents.hash.consentStatusFilter) ||
                        app.hasStateChanged(ImageVaultUi.NavigationEvents.hash.consentUserId) ||
                        app.hasStateChanged(ImageVaultUi.NavigationEvents.hash.isPublishedFilter) 
                    ) {

                        //Perform search based on hash fragments
                        self.performSearch(0);
                    }

                    //Save current state so we can check if something has changed next time
                    app.set({ previousState: e });

                    //store the change in the hash to session
                    if (window.sessionStorage) {
                        window.sessionStorage.libraryHash = window.location.hash;
                        window.sessionStorage.currentUserName = app.get("currentUserName");
                    }

                });

            //Search event
            $("#search form").submit(function () {
                //Push state to hash
                $.bbq.pushState({ 'search': $("#SearchQuery").val() });

                $("#SearchQuery").autocomplete('close');

                return false;
            });

            $("ul.media-item-list").live("mousedown", function (e) {
                $("details").removeAttr("open");
            });

            $("#stream li").live("mousedown",
                function (e) {
                    $("details").removeAttr("open");

                    var $element = $(this);
                    var $target = $(e.target);
                    var showPreview = $target.hasClass("show-preview");
                    var symbol = $target.hasClass("media-library-symbol");
                    var itemIsSelected = $element.hasClass("selected") && !$element.hasClass("ui-selecting");
                    var $listItems = $("#stream li");
                    var $selectedItems = $("#stream li.selected");
                    var selectItemsButtonIsActive = $(".select-items-link").hasClass("active");

                    clearTimeout(self.draggableTimeout);

                    if ((!showPreview && !symbol) || (!self.isTouchDevice && !showPreview)) {
                        // Remove selected items if not ctrl key is down
                        if (!self.ctrlKeyDown && !self.shiftKeyDown && !selectItemsButtonIsActive) {

                            self.draggableTimeout = setTimeout(function () {
                                $selectedItems.removeClass("selected");

                                $element.addClass("selected");
                                var id = $element.attr("data-item-id");

                                self.$chosenItem = $element;
                                self.$lastSelectedItem = $element;

                                // Update infopanel
                                self.infoPanel.show(id);

                                // Save selected items
                                self.setSelectedItems();
                            },
                                500);
                        } else if (self.ctrlKeyDown || selectItemsButtonIsActive) {
                            if (itemIsSelected) {
                                // Remove selected class after selectable has triggered
                                $element.removeClass("selected").removeClass("ui-selected");

                            } else {

                                $element.addClass("selected");

                            }
                        } else if (self.shiftKeyDown) {
                            // Start from position where current media item is
                            var startPosition = $listItems.index(self.$chosenItem);

                            // Index of last selected item
                            var lastSelectedIndex = $listItems.index($element);

                            var $itemsToSelectWithShift;

                            // Select multiple items
                            if (startPosition >= lastSelectedIndex) {
                                $itemsToSelectWithShift = $listItems.slice(lastSelectedIndex, startPosition + 1);
                            } else {
                                $itemsToSelectWithShift = $listItems.slice(startPosition, lastSelectedIndex + 1);
                            }

                            // Add old selected items and add selected class to new items
                            $("#stream li").removeClass("selected");
                            $itemsToSelectWithShift.addClass("selected");
                        }

                        // Save selected items
                        self.setSelectedItems();
                    }
                },
                100);

            // Attach event for double clicking preview
            $("#stream li").live("dblclick",
                function () {
                    self.initPreview($(this).attr("data-item-id"));
                });

           const mouseWheel = function (e) {
                var container = findParent(e.target, "scroll-container");
                if (!container) return;

                //if no scroll, then ignore
                var hasHorizontalScrollbar = container.scrollWidth > container.clientWidth;
                var hasVerticalScrollbar = container.scrollHeight > container.clientHeight;
                if (!hasHorizontalScrollbar && !hasVerticalScrollbar) return;
                //if scroll already at the top, ignore
                if (container.scrollTop == 0 && e.deltaY < 0) return;
                //if scroll already at the bottom, ignore
                if (container.scrollTop + container.clientHeight >= container.scrollHeight && e.deltaY > 0) return;
                //stop event to bubble up to jquery and the jsp
                e.stopPropagation();
            }
            const findParent = function (elem, className) {
                while (elem && elem.classList) {
                    if (elem.classList.contains(className)) return elem;
                    elem = elem.parentElement;
                }
                return null;
            }
            $("#stream .media-library-symbol").live("hover", function () {
                // console.log("hover: "+this.tagName+"."+this.classList);
                let $symbolDiv = $(this);
                let $popup = $(".media-library-symbol-description", $symbolDiv);
                if ($popup.length == 0) return;
                //do not run if already open
                if ($popup.css("display") == "block") return;

                //close any traling
                $(".media-library-symbol-description").css("display", "none");
                $popup.css("display", "block");
                let domPopup = $popup.get(0);
                let domSymbolDiv = $symbolDiv.get(0);
                //mouse events are not working well with jquery, better use standard DOM events
                domSymbolDiv.removeEventListener("mouseleave", closePopup);
                domPopup.removeEventListener("mouseleave", closePopup);
                domPopup.removeEventListener("wheel", mouseWheel);
                domSymbolDiv.addEventListener("mouseleave", closePopup);
                domPopup.addEventListener("mouseleave", closePopup);
                domPopup.addEventListener("wheel", mouseWheel);
            });
            const closePopup = function (e) {
                let popup = e.target;
                 // console.log("closePopup: " + popup.tagName + "." + popup.classList);
                 //close popup can be called both from the popup itself
                 if(!popup.classList.contains("media-library-symbol-description")) {
                     //or a parent element to the popup
                     popup = popup.querySelector(".media-library-symbol-description");
                 }
                 if(!popup) return;
                 popup.style.display = null;
             }
            // Event for click on add to batch area
            $(".add-to-batch-area").live("click",
                function () {
                    app.trigger("stream:addToLightbox");
                    return false;
                });

            //attach event for single clicking the preview icon
            $("#stream li a.preview").live("mousedown",
                function () {
                    var $listItem = $(this).closest("li");

                    // Select item
                    $listItem.trigger("mousedown");
                    $listItem.addClass("selected");

                    // Wait for select event to be done
                    $listItem.addClass("show-preview");
                    self.initPreview($listItem.attr("data-item-id"));

                    return false;
                });

            // var previewTimeout;

            // $("#stream li a.preview").live("mouseover",
            //     function() {
            //         $(this).closest("li").addClass("show-preview");
            //     }).live("mouseout",
            //     function() {
            //         clearTimeout(previewTimeout);
            //         var $listItem = $(this);

            //         previewTimeout = setTimeout(function() {
            //                 $listItem.closest("li").removeClass("show-preview");
            //             },
            //             100);
            //     });

            // Add actions for select items link
            $("a.select-items-link").click(function () {
                var $clickedElement = $(this);
                $clickedElement.toggleClass("active");

                return false;
            });

            //Resize stream height on window resize
            $(window).resize(function () {
                self.updateLibraryViewSettings();
                self.forceNewPageIfResultNotFillingUpPage();
            });

            app.bind("share:created", this.shareCreated, this);
            app.bind("share:removed", this.shareRemoved, this);

            if ($.bbq.getState("newSession") && window.sessionStorage) {
                $.bbq.removeState("newSession");
                window.sessionStorage.clear();
            }
            //if we have stored an old hash in the session, navigate to it
            if (window.sessionStorage && window.sessionStorage.libraryHash) {
                //only reuse session storage for the same user that created it.
                if (window.sessionStorage.currentUserName === app.get("currentUserName")) {
                    window.location.hash = window.sessionStorage.libraryHash;
                }
            }
            // Events for key up on ctrl and shift
            $(window).keyup(function (event) {
                var key = event.which;

                if (key === 16) {
                    self.shiftKeyDown = false;
                }

                if (self.isCtrlOrCmdKey(key)) {
                    self.ctrlKeyDown = false;
                }
            });

            // Add key events to show next or previous image
            $(window).keydown(function (event) {

                // Keycode for event
                var key = event.which;

                // Return if ctrl key or shift key
                if (self.isCtrlOrCmdKey(key)) {
                    self.ctrlKeyDown = true;
                    return true;
                } else if (key === 16) {
                    self.shiftKeyDown = true;
                    return true;
                }

                // Esc key closes preview and dialogs
                if (key === 27) {
                    $(".dialog .close, .overlay .cancel-action, .dialog .cancel").last().click();
                    return false;
                }

                //if overlay is visible, skip input
                if ($(".overlay :visible").length) {
                    return true;
                }

                // Return true if user is in input field
                if ($(event.target)[0].nodeName === "INPUT" || $(event.target)[0].nodeName === "TEXTAREA")
                    return true;

                //delete key
                if (key === 46) {

                    //no modifier is pressed (only clean delete should be handled)
                    if (!event.shiftKey && !event.metaKey && !event.ctrlKey && !event.altKey) {
                        $(".delete:not(inactive) a").click();
                        return false;
                    }
                    return true;
                }

                var $previousSelectedItem = self.$lastSelectedItem;

                // All list items
                var $listItems = $("#stream li");

                // Calculate columns
                var position = $listItems.eq(0).position();
                var topPosition = 0;

                if (position != null) {
                    topPosition = position.top;
                }
                var columns = 0;

                $listItems.each(function () {
                    if ($(this).position().top === topPosition) {
                        columns++;
                    } else {
                        return;
                    }
                });

                var video = $("body > .fixed-preview-pane video")[0];

                if (video) {
                    if (key === 32) {
                        if (video.paused === true) {
                            if (video.readyState !== 4) {
                                video.load();
                            }
                            video.play();

                        } else {
                            video.pause();
                        }
                        return false;
                    }
                }

                var navigateVertical = function (direction) {
                    var left = self.$lastSelectedItem.offset().left;
                    var $newItem;
                    if (direction > 0) endItem = $listItems.length;

                    //sometimes when navigating down, an item can be the lowest point that triggers scroll even if it is not the last element.
                    var $lowestItem;

                    var i = self.$lastSelectedItem.index() + direction;
                    for (; i > 0 && i < $listItems.length - 1; i += direction) {
                        var $verticalItem = $($listItems[i]);
                        if (direction > 0) {
                            if ($lowestItem) {
                                if ($lowestItem.offset().top + $lowestItem.height() < $verticalItem.offset().top + $verticalItem.height()) {
                                    $lowestItem = $verticalItem;
                                }
                            } else {
                                $lowestItem = $verticalItem;
                            }
                        }
                        if (Math.abs(left - $verticalItem.offset().left) < 2) {
                            $newItem = $verticalItem;
                            break;
                        }
                    }
                    //go to first/last item if no item is located directly above/below
                    if (!$newItem) {
                        $newItem = $($listItems[i]);
                        //if we found a lower item that is lower than the current, use that instead
                        if ($lowestItem && $lowestItem.offset().top + $lowestItem.height() > $newItem.offset().top + $newItem.height()) {
                            $newItem = $lowestItem;
                        }
                    }
                    self.$lastSelectedItem = $newItem.length ? $newItem : self.$lastSelectedItem;
                };
                var navigateHorizontal = function (direction) {
                    var numColumns = (parseInt($("#stream").attr("data-number-of-columns")) + 1) * 2;
                    var lastColLeft = -1;
                    var cols = [];
                    var pos = 0;
                    //calculate all column positions
                    var left = self.$lastSelectedItem.offset().left;
                    var currentColumn = -1;
                    while (cols.length < numColumns && pos < $listItems.length) {
                        var $i = $($listItems[pos++]);
                        var colLeft = parseInt($i.offset().left);
                        if (colLeft > lastColLeft) {
                            if (Math.abs(left - colLeft) < 2) {
                                currentColumn = cols.length;
                            }
                            cols.push(colLeft);
                            lastColLeft = colLeft;
                        }
                    }

                    var nextColumn = currentColumn + direction;
                    if (nextColumn >= cols.length) {
                        nextColumn = 0;
                    } else if (nextColumn < 0) {
                        nextColumn = cols.length - 1;
                    }
                    var expectedLeft = cols[nextColumn];
                    var $newItem;

                    var i = self.$lastSelectedItem.index() + direction;
                    for (; i > 0 && i < $listItems.length - 1; i += direction) {
                        var $horizontalItem = $($listItems[i]);
                        if (Math.abs(expectedLeft - $horizontalItem.offset().left) < 2) {
                            $newItem = $horizontalItem;
                            break;
                        }
                    }
                    //go to first/last item if no item is located directly right/left
                    if (!$newItem) {
                        $newItem = $($listItems[i]);
                    }
                    self.$lastSelectedItem = $newItem.length ? $newItem : self.$lastSelectedItem;
                }
                // Left clicked
                if (key === 37) {
                    navigateHorizontal(-1);
                }
                // Up clicked
                else if (key === 38) {
                    navigateVertical(-1);
                }
                // Right clicked
                else if (key === 39) {
                    navigateHorizontal(1);
                }
                // Down clicked
                else if (key === 40) {
                    navigateVertical(1);
                }
                // Enter key triggers preview
                else if (key === 13) {
                    if (self.$lastSelectedItem) {
                        return self.$lastSelectedItem.find("img").trigger("dblclick");
                    }
                }

                // Select all visible media items
                if (self.ctrlKeyDown && (key === 65 || key === 97)) {
                    $("#stream li").addClass("selected");

                    // Save selected items
                    self.setSelectedItems();
                    return false;
                }

                var $itemsToSelectWithShift = [];

                // Set event for shift key to select multiple files
                if (self.shiftKeyDown) {
                    // Start from position where current media item is
                    var startPosition = $listItems.index(self.$chosenItem);

                    // Index of last selected item
                    var lastSelectedIndex = $listItems.index(self.$lastSelectedItem);

                    // Select multiple items
                    if (startPosition >= lastSelectedIndex) {
                        $itemsToSelectWithShift = $listItems.slice(lastSelectedIndex, startPosition + 1);
                    } else {
                        $itemsToSelectWithShift = $listItems.slice(startPosition, lastSelectedIndex + 1);
                    }

                    // Add old selected items and add selected class to new items
                    $("#stream li").removeClass("selected");
                    $itemsToSelectWithShift.addClass("selected");

                    // Save selected items
                    self.setSelectedItems();

                    // Scroll to last selected item
                    self.scrollToObject(self.$lastSelectedItem);

                    return false;
                }

                // Change preview item
                if (key === 37 || key === 38 || key === 39 || key === 40) {
                    if ($previousSelectedItem === self.$lastSelectedItem) {
                        return false;
                    }

                    return self.changePreviewMedia(self.$lastSelectedItem);
                }

                return true;
            });

            // Add event for click on window to unselect items and lightbox
            document.body.addEventListener("mousedown",
                function (e) {
                    //try to determine if we clicked on an overlay, 
                    //in that case, abandon the whole procedure.
                    if(e.target.closest) {
                        var overlay = e.target.closest(".overlay");
                        if(overlay) return;
                    }
                    var $clickedElement = $(e.target);

                    // Set ctrl key to true if key down
                    if (e.ctrlKey || e.metaKey) {
                        self.ctrlKeyDown = true;
                    } else {
                        self.ctrlKeyDown = false;
                    }

                    // Set shift key to true if key down
                    if (e.shiftKey) {
                        self.shiftKeyDown = true;
                    } else {
                        self.shiftKeyDown = false;
                    }

                    setTimeout(function () {
                        if (!$clickedElement.is("a") &&
                            !$clickedElement.is("input") &&
                            !$clickedElement.is("li") &&
                            !$clickedElement.is("span") &&
                            !$clickedElement.is("img") &&
                            !$clickedElement.hasClass("jspDrag") &&
                            !$clickedElement.hasClass("icon") &&
                            !$clickedElement.closest(".thumbnail").length &&
                            !$clickedElement.hasClass("ui-resizable-handle") &&
                            !$clickedElement.closest("#details-viewport").length &&
                            !$clickedElement.closest("#lightbox").length) {
                            $("#stream li.selected").removeClass("selected");
                            $("#lightbox").removeClass("selected");
                            self.setSelectedItems();

                        }
                    },
                        100);

                });

            // Listen to new collections created
            app.bind("collectionDialog:collectionSaved", this.collectionSaved, this);

            // Monitor changes for opener changes
            app.bind("app:openedForInsertChanged", this.showEditorForRequestedMediaUrl, this);

            //trigger search so we get some result
            var getSeveralPages = $.bbq.getState("pages") > 0 && $.bbq.getState("items") !== "" ? true : false;
            this.performSearch(0, null, getSeveralPages);

            var suggestionContainer = document.querySelector("div#SearchSuggestions");
            if (suggestionContainer) {
                $("#SearchQuery").autocomplete({
                    delay: 300,
                    appendTo: 'div#SearchSuggestions',
                    source: function (req, resp) { return self.searchSearchTerms(req, resp); },
                    select: function (event, ui) {
                        $.bbq.pushState({ 'search': '"' + ui.item.value + '"' });
                    },
                });
            }

            $("body").live("click", function (e) {
                var clickedDetails = $(e.target).closest("details");

                if ($(e.target).attr("data-mdid") || $(e.target).hasClass("submit-button")) {
                    return;
                } else {
                    var openDetails = $("details[open]");
                    openDetails.each(function () {
                        if (!clickedDetails.length || !clickedDetails.is($(this))) {
                            $(this).removeAttr("open");
                        }
                    });
                }
            });

            // Show or hide info
            $(".info-button").click(function (e) {

                $(".advanced-search-info").toggle(0,
                    function () {
                        $.bbq.pushState({ 'info': $(".advanced-search-info").is(":visible") });
                    });
                $(".info-button").toggleClass("active");
                return false;
            });
        },

        searchSearchTerms: function (req, res) {
            var url = "/apiv2/assets/suggest?$search=" + encodeURIComponent(req.term);
            $.ajax({
                url: url,
                type: "GET",
                contentType: "application/json; charset=utf-8"
            }).success(function (response) {
                var searchTerms = [];
                if (response.value) {
                    [].forEach.call(response.value, suggestion => {
                        searchTerms.push(suggestion.searchText);
                    });
                }
                res(searchTerms);
            })
                .error(function (jqXHR, textStatus, errorThrown) {
                    console.log("An error occured when trying to display suggestions");
                    //console.log(textStatus);
                    //console.log(errorThrown);     
                    res();
                });
        },

        showEditorForRequestedMediaUrl: function () {
            var self = this;

            // Test edit image
            function getParameterByName(name, url) {
                if (!url) url = window.location.href;
                name = name.replace(/[\[\]]/g, "\\$&");
                var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                    results = regex.exec(url);
                if (!results) return null;
                if (!results[2]) return '';
                return decodeURIComponent(results[2].replace(/\+/g, " "));
            }

            // Get current url 
            var url = window.location.href;
            var mediaUrl = getParameterByName("mediaUrl", url);


            if (mediaUrl) {
                // Parameters for webservice call "MediaService/Find"
                var mediaParameters = {
                    Filter: { Url: [mediaUrl] }
                };

                app.json({
                    url: 'api/mediaservice/find',
                    data: JSON.stringify(mediaParameters),
                    success: function (x) {
                        if (x && x[0]) {
                            self.showEditor(x[0].Id, x[0].MediaConversions[0].MediaFormatId);
                        } else {
                            app.showError(translate("library.MediaItemRemoved"));

                            // Close dialog
                            app.closeWindow();
                        }
                    }
                });
            }
        },

        showEditor: function (mediaId, mediaFormatId) {
            var self = this;

            var callBackFunction =
                function (effects) {
                    if (effects !== null) {
                        var jsonEffects = JSON.parse(effects);

                        // Add effects for width and height if video
                        if (jsonEffects &&
                            jsonEffects[0] &&
                            jsonEffects[0].ContentType &&
                            jsonEffects[0].ContentType.indexOf("video/") !== -1)
                            jsonEffects.push({
                                $type: "ImageVault.Common.Data.Effects.ResizeEffect,ImageVault.Common",
                                Width: mediaConversion.FormatWidth,
                                Height: mediaConversion.FormatHeight
                            });

                        // Parameters for webservice call "MediaService/Find"
                        var mediaParameters = {
                            Filter: { Id: [mediaId] },
                            Populate: {
                                MediaFormats: [
                                    // Webmedia format
                                    {
                                        $type: "ImageVault.Common.Data.WebMediaFormat,ImageVault.Common",
                                        Effects: jsonEffects
                                    },
                                    // Image format (fallback format)
                                    {
                                        $type: "ImageVault.Common.Data.ImageFormat,ImageVault.Common",
                                        Effects: jsonEffects
                                    }
                                ]
                            },
                            MediaUrlBase: window.location.origin
                        };

                        var findMediaJson = JSON.stringify(mediaParameters);

                        app.json({
                            url: 'api/mediaservice/find',
                            data: findMediaJson,
                            success: function (x) {
                                // One and only media conversion
                                var insertMedia = x[0];

                                return self.toolbar
                                    .insertItem([insertMedia.Id],
                                        insertMedia.MediaConversions[0] ?
                                            insertMedia.MediaConversions[0].MediaFormatId :
                                            insertMedia.MediaConversions[1].MediaFormatId);
                            }
                        });
                    } else {
                        app.insertCallback(null);
                    }
                };

            var editor = new ImageVaultUi.ImageVaultEditor(mediaId,
                mediaFormatId,
                null, {
                callback: callBackFunction,
                editorOkButtonText: translate("common.Ok"),
                lang: app.getPageLang(),
                // If user sent formatId in Url, then lock width and height if in insert mode
                targetFormatId: self.thumbnailFormatId
            });

            $(".notification").remove();
        },

        collectionSaved: function (id) {
            // Todo: reload collections...?
        },

        //
        // Add the shared class to the mediaItem node when share is created
        //
        shareCreated: function (mediaItemIds) {
            for (var i = 0; i < mediaItemIds.length; i++) {
                var id = mediaItemIds[i];
                var $mediaListItem = $("#stream li[data-item-id='" + id + "']");
                $mediaListItem.addClass("shared");
                var $symbolsDiv = $mediaListItem.find(".media-library-symbols");
                //if share symbol exists, skip
                if ($(".media-library-symbol-shared-media", $symbolsDiv).length) continue;
                //if video symbol exists, add as second
                var sharedDivHtml =
                    "<div class=\"media-library-symbol media-library-symbol-shared-media\"><span class=\"media-library-symbol-icon\"><span class=\"icon icon-shared-media\"></span></span></div>";
                if ($(".media-library-symbol-shared-video", $symbolsDiv).length) {
                    $(".media-library-symbol-shared-video", $symbolsDiv).after(sharedDivHtml);
                } else {
                    $symbolsDiv.prepend(sharedDivHtml);
                }
            }
            //Refresh the Information-tab
            if (this.infoPanel.getSelectedTab() === "information") {
                this.infoPanel.refresh();
            }
        },

        //
        // Unselect items
        //
        unSelectItems: function (ids) {
            for (var i = 0; i < ids.length; i++) {
                $("#stream li[data-item-id='" + ids[i] + "']").removeClass("selected");
            }

            this.setSelectedItems();
        },

        //
        // Remove the shared class from the mediaItems that doesn't belong to any share
        //
        shareRemoved: function (mediaItemIds) {
            for (var i = 0; i < mediaItemIds.length; i++) {
                var id = mediaItemIds[i];
                var $mediaListItem = $("#stream li[data-item-id='" + id + "']");
                $mediaListItem.removeClass("shared");
                $mediaListItem.find(".media-library-symbol-shared-media").remove();
            }
            //Refresh the Information-tab
            if (this.infoPanel.getSelectedTab() === "information") {
                this.infoPanel.refresh();
            }
        },
        //Keep track of last search so we don't repeat a search
        _oldSearchParams: null,
        cancelUnloadedThumbnails: function () {
            var $notLoadedImages = $("#stream li img:not(.loaded)");
            $notLoadedImages.each(function (index, img) {
                img.src = '';
            });
        },
        //
        //Perform search based on url hash fragments
        //
        _queuedSearch: null,
        _currentSearch: null,
        /**
         * Marks the current search as completed.
         * 
         * @param invokeQueued if any search is queued, the search will be executed
         * @return true if no other search is executed, false if a search was executed
         */
        currentSearchCompleted: function (invokeQueued) {
            this._currentSearch = null;
            if (invokeQueued && this._queuedSearch !== null) {
                var queuedPage = this._queuedSearch;
                this._queuedSearch = null;
                // console.log("Invoking queued search " + queuedPage);
                this.performSearch(queuedPage);
                return false;
            }
            return true;
        },
        performSearch: function (page, force, getSeveralPages) {
            // Make sure keyboardnavigation doesn't affect sidenav
            if ($(document.activeElement).attr("id") === "nav-viewport") {
                $(document.activeElement).blur()
            }

            var self = this;
            var vaultIds = [];
            var collectionIds = [];
            var agreementIds = [];
            var consentUserIds = [];
            var categoryIds = [];
            var mediaTypeGroups = [];
            var mediaSizeGroups = [];
            var mediaOrientations = [];
            var mediaMetadataOptions = [];

            var searchString = $.bbq.getState("search");

            var sortOrder = $.bbq.getState("order");
            var sortDirection = $.bbq.getState("direction");
            //exact match is true by default. 
            var exactMatch = $.bbq.getState("em") === 'false' ? false : true;

            var vaultIdsString = $.bbq.getState("vaults");
            vaultIds = vaultIdsString ? vaultIdsString.split(",") : [];

            if (vaultIds.indexOf("0") !== -1) {
                // select all vaults in vaultlist, to exclude files in process of being deleted
                if (vaultIds.length === 1) {
                    var vaults = $("#vaults li");
                    for (var i = 0; i < vaults.length; i++) {
                        var id = vaults[i].getAttribute("data-vault-id");
                        if (id === "0")
                            continue;
                        vaultIds.push(id)
                    }
                }
                vaultIds.splice(vaultIds.indexOf("0"), 1);
            }

            var collectionIdsString = $.bbq.getState("collections");
            collectionIds = collectionIdsString ? collectionIdsString.split(",") : [];
            if (collectionIds.indexOf("0") !== -1)
                collectionIds.splice(collectionIds.indexOf("0"), 1);

            var agreementIdsString = $.bbq.getState("agreements");
            agreementIds = agreementIdsString ? agreementIdsString.split(",") : [];
            if (agreementIds.indexOf("0") !== -1)
                agreementIds.splice(agreementIds.indexOf("0"), 1);

            var consentStatusFilterFlag = $.bbq.getState(ImageVaultUi.NavigationEvents.hash.consentStatusFilter) || 0;

            var consentUserIdString = $.bbq.getState(ImageVaultUi.NavigationEvents.hash.consentUserId)||0;
            consentUserIds = consentUserIdString ? consentUserIdString.split(",") : [];
            if (consentUserIds.indexOf("0") !== -1)
                consentUserIds.splice(consentUserIds.indexOf("0"), 1);

            var isPublishedFilter = $.bbq.getState(ImageVaultUi.NavigationEvents.hash.isPublishedFilter) || 0;
            var categoryIdsString = $.bbq.getState("categories");
            categoryIds = categoryIdsString ? categoryIdsString.split(",") : [];
            if (categoryIds.indexOf("0") !== -1)
                categoryIds.splice(categoryIds.indexOf("0"), 1);

            var mediaTypeGroupsString = $.bbq.getState("mediaTypeGroups");
            mediaTypeGroups = mediaTypeGroupsString ? mediaTypeGroupsString.split(",") : [];

            var mediaSizeGroupString = $.bbq.getState("mediaSizeGroups");
            mediaSizeGroups = mediaSizeGroupString ? mediaSizeGroupString.split(",") : [];

            var mediaOrientationString = $.bbq.getState("mediaOrientations");
            mediaOrientations = mediaOrientationString ? mediaOrientationString.split(",") : [];

            var mediaMetadataOptionsString = $.bbq.getState("mediaMetadataOptions");
            mediaMetadataOptions = mediaMetadataOptionsString ? mediaMetadataOptionsString.split(",") : [];

            //search
            $("#sort-menu li a[data-name='searchscore-descending']").parent().hide();
            if (this.usingSearchEngine && !self.isTouchDevice && window.outerWidth > 991) {
                if (searchString) {
                    $("#sort-menu li a[data-name='searchscore-descending']").parent().show();
                    if (sortOrder !== "searchscore" && !$.bbq.getState("prev-order")) {
                        if (!$.bbq.getState("prev-order") && sortOrder) {
                            $.bbq.pushState({ 'prev-order': sortOrder + "-" + sortDirection });
                        }
                        sortOrder = "searchscore";
                        sortDirection = "descending";
                        $.bbq.pushState({ 'order': sortOrder, 'direction': sortDirection });
                    }
                } else {
                    if (sortOrder === "searchscore") {
                        if ($.bbq.getState("prev-order")) {
                            var o = $.bbq.getState("prev-order").split("-");
                            sortOrder = o[0];
                            sortDirection = o[1];
                        } else {
                            sortOrder = "dateadded";
                            sortDirection = "descending";
                        }
                        $.bbq.pushState({ 'order': sortOrder, 'direction': sortDirection });
                    }
                    $.bbq.removeState("prev-order");
                }
            }
            //Create model parameters to pass to server...
            var params = {
                searchRequestData: {
                    SearchQuery: searchString,
                    SelectedVaultIds: vaultIds,
                    SelectedCollectionIds: collectionIds,
                    SelectedAgreementIds: agreementIds,
                    FilterConsentStatus: consentStatusFilterFlag,
                    SelectedConsentUserIds: consentUserIds,
                    FilterIsPublished: isPublishedFilter ? true : undefined,
                    SelectedCategoryIds: categoryIds,
                    SelectedMediaTypeGroups: mediaTypeGroups,
                    SelectedMediaSizeGroups: mediaSizeGroups,
                    SelectedMediaOrientations: mediaOrientations,
                    SelectedMediaMetadata: mediaMetadataOptions,

                    SelectedSortOrder: { Order: sortOrder, Direction: sortDirection },
                    PageNo: page,
                    ExactMatch: exactMatch
                }
            };
            if (getSeveralPages) {
                params.searchRequestData.RequestedPages = (parseInt($.bbq.getState("pages")) + 1);
                page = (parseInt($.bbq.getState("pages")));
            }
            var json = JSON.stringify(params);
            //Keep track of search so we don't repeat same search (from init and bbq updates)
            if (!force && this._oldSearchParams === json) {
                // console.log("old search is same as last search")
                this.currentSearchCompleted(true);
                return;
            }

            if (this._currentSearch !== null && $.bbq.getState("pages") > page) {
                return;
            }

            //if a search is currently running, queue the next one and invoke it later on
            if (this._currentSearch !== null) {
                this._queuedSearch = page || 0;
                // console.log("queuing search " + this._queuedSearch);
                return;
            }
            if (!page) {
                page = 0;
            }
            this._currentSearch = page;
            if (!page) {
                //console.log("cancel Unloaded thumbs")
                this.cancelUnloadedThumbnails();
            }
            this._oldSearchParams = json;

            //Notify user that we are getting stuff from server
            //ReSharper disable once InconsistentNaming
            self.loading = new IVNotification(translate("common.Loading"));
            self.isLoading = true;

            self.ivUiAjax = app.load({
                url: "library/search",
                data: json,
                success: function (data) {
                    var searchCompleted = false;
                    try {
                        // console.log("Search success " + searchString);
                        var $data = $("<div>" + data + "</div>");
                        self.lastCount = $data.find("li").length;

                        self.totalCount = $data.find(".total-count").val();
                        $("search-media-typegroups").attr("data-filecount", self.totalCount);

                        //We return one extra item to see if there is more
                        if (getSeveralPages && self.lastCount > self.pageSize && self.lastCount - 1 === (page + 1) * self.pageSize) {
                            //Remove last item
                            $data.find("li").last().remove();
                        }
                        if (self.lastCount > self.pageSize && !getSeveralPages) {
                            //Remove last item
                            $data.find("li").last().remove();
                        }
                        var jsp = $("#stream").data("jsp");

                        //setup result for new search (can be a page reload, so we need to set up all js specific data just in case)
                        if (page === 0 || getSeveralPages) {
                            //Reset page number
                            self.currentPageNo = getSeveralPages ? page : 0;
                            self._extraPagesLoaded = 0;

                            if (jsp) {
                                jsp.destroy();
                            }
                            var updateColumns = function () {
                                // Set cookie with number of columns value
                                var cookie = ImageVaultUi.Common.getJsonCookie("ImageVaultCookieData");
                                var numberOfColumns = cookie["Columns"] || 0;
                                // console.log(numberOfColumns);

                                // Set number of columns from cookie to get right size at images
                                self.toolbar.changeNumberOfColumns(numberOfColumns);
                            };
                            updateColumns();

                            // Add event on window resize to get right width and height
                            $(window).resize(function () {
                                updateColumns();
                                // Reload masonry
                                self.$masonry.masonry("layout");
                            });

                            //Insert ul to stream
                            $("#stream").html("<ul class='media-item-list'/><div id='imageLoader' style='display: none;'><div class='loader-object'></div></div><div id='fictiveImagePreview' style='display: none'></div>");
                            //Init scrollbars etc on viewport
                            self.initViewport();
                            //jsp will be reset after viewport update
                            jsp = $("#stream").data("jsp");
                            //Set up image-tiles
                            self.setupMasonry();

                        }
                        //Insert partial view from server to dom.
                        var $listItems = $data.find("li");
                        var items = $listItems.toArray();

                        var itemsToLayout = [];
                        //add each item to the stream (from server html response)
                        for (var i = 0; i < items.length; i++) {
                            var item = items[i];
                            self.$masonry.append(item);
                            var $item = self.$masonry.children().last();
                            var $img = $item.find("img");
                            //modify attributes to get correct src/width/height
                            var firstThumbnailWidth = $(".thumbnail", self.$masonry).first().width();
                            ImageVaultUi.ThumbnailUtil.setThumbnailAttributes($img, firstThumbnailWidth);
                            itemsToLayout.push($item.get(0));
                        }
                        //add to masonry
                        self.$masonry.masonry("appended", itemsToLayout);
                        //force masonry to layout items
                        self.$masonry.masonry("layout");
                        //reinitialize scroll pane to get scroll to reflect on new content
                        if (jsp) {
                            // Must be hidden to initiate scroll
                            jsp.reinitialise();
                        }
                        self.printLibraryMessage();

                        self.postImageLoadUpdateUi(page, getSeveralPages);
                        searchCompleted = true;
                        // console.log("search success completed " + searchString);                                                
                    } finally {
                        //if all searches are completed, check that the current
                        if (self.currentSearchCompleted(true) && searchCompleted) {
                            self.forceNewPageIfResultNotFillingUpPage();
                        }
                    }
                },
                error: function (error) {
                    self.currentSearchCompleted();
                    self.loading.remove();
                    app.showError("Error performing search", error);
                }
            });
        },
        _extraPagesLoaded: 0, //extra security to not load to many pages to fill page
        forceNewPageIfResultNotFillingUpPage: function () {
            var $mediaItemList = $(".media-item-list");
            var $stream = $("#stream");

            var mediaItemListHeight = $mediaItemList.outerHeight(); //including padding
            var streamHeight = $stream.height();
            var forceNextPage = mediaItemListHeight < streamHeight;
            //do not load more than 3 pages (if logic above cannot be trusted in all cases)
            if (this._extraPagesLoaded > 2)
                forceNextPage = false;
            if (forceNextPage) {
                this._extraPagesLoaded++;
                this.loadNextPageIfPossible();
            }
        },
        postImageLoadUpdateUi: function (page, severalPages) {
            var self = this;
            //Update toolbar
            var itemIds = self.getSelectedLibraryItemIds();

            if (itemIds) {
                var selectedItems = [];
                for (var i = 0; i < itemIds.length; i++) {
                    var $selectedItem = $("#stream li[data-item-id=" + itemIds[i] + "]");
                    if (!$selectedItem.length) {
                        continue;
                    }
                    $selectedItem.addClass("selected");
                    selectedItems.push($selectedItem);

                    // If only one item is selected, show in info panel 
                    if (itemIds.length === 1) {
                        self.infoPanel.show(itemIds[i]);
                        self.$lastSelectedItem = $selectedItem;
                        self.$chosenItem = $selectedItem;
                    } else {
                        self.infoPanel.show(0);
                    }
                }

                self.setSelectedItems();

                self.toolbar.updateToolbar();
                // Add draggable event
                self.initDraggableEvent();
            }
            $.bbq.pushState({ 'pages': page });
            //Set up events etc on thumbnails
            self.initThumbnails();


            //Remove loading notification
            self.loading.remove();
            self.isLoading = false;
            if (page === 0 || severalPages) {
                //Find top item
                if (itemIds && itemIds.length) {
                    var $topItem;
                    var topPos;
                    for (var i = 0; i < itemIds.length; i++) {
                        var $item = $("#stream li[data-item-id=" + itemIds[i] + "]");
                        if (!$item.length) continue;
                        var itemPos = $item.offset().top;
                        if (!$topItem || topPos > itemPos) {
                            $topItem = $item;
                            topPos = itemPos;
                        }
                    }
                    if ($topItem) {
                        self.scrollToObject($topItem);
                    } else if (!$topItem && severalPages) {
                        var position = $.bbq.getState("pos");
                        self.jScrollPane.data("jsp").scrollToPercentY(position, true);
                    }
                    $.bbq.removeState("pos");
                }
            }
        },
        //
        // Init events etc for thumbnails in stream
        //
        initThumbnails: function () {
            var self = this;
            // Set loaded class on images when loaded
            $("#stream li img").each(function () {
                var $item = $(this);
                $item.load(function () {
                    $item.addClass("loaded");
                    self.$masonry.masonry("layout");
                    self.reinitializeScroll();

                    /* IE BUGFIX - To center image by reset display inline value*/
                    $item.parent().css("display", "inline-block");
                    setTimeout(function () {

                        $item.parent().css("display", "inline");
                    },
                        10);
                    /* IE BUGFIX ENDS */

                });
            });
        },

        // 
        // Add/Init draggable event
        //
        initDraggableEvent: function () {
            var self = this;

            // Set loaded class on images when loaded
            $("#stream li").draggable({ disabled: true }).removeClass("ui-draggable");

            $("#stream li.selected").draggable({
                appendTo: "body",
                scope: "mediaItem",
                helper: function () {

                    var $images = $("#stream li.selected img").clone();

                    return $("<div class='drag-items-helper'></div>").append($images);
                },
                zIndex: 1000,
                opacity: 0.9,
                containment: "body",
                disabled: false,
                start: function (event) {
                    self.oldDragOver = null;
                    // Align helper with cursor
                    $(".drag-items-helper").css("margin-left", (event.clientX - $(event.target).offset().left) + 22);
                    $(".drag-items-helper").css("margin-top", (event.clientY - ($(event.target).offset().top)) - 45);

                    clearTimeout(self.draggableTimeout);
                },
                drag: function (event) {
                    //don't touch if lightbox has items
                    if ($("#lightbox li").length) {
                        return;
                    }
                    var e = document.elementFromPoint(event.pageX, event.pageY);
                    //if we hoover the same item, do nothing
                    if (e === self.oldDragOver) {
                        return;
                    }
                    self.oldDragOver = e;

                    //are we over the navViewPort, hide lightbox
                    var isOverNavViewPort = !!($(e).closest("#nav-viewport").length);
                    if (isOverNavViewPort) {
                        $("body").removeClass("has-batch-items");
                    } else {
                        $("body").addClass("has-batch-items");
                    }
                },
                stop: function () {
                    //$("body, html").css("overflow", "initial");
                    if (!$("#lightbox li").length) {
                        $("body").removeClass("has-batch-items");
                    }
                }
            });
        },
        loadNextPageIfPossible: function () {
            //Check if there is more stuff to get
            if (this.lastCount <= this.pageSize) {
                return;
            }
            //skip additional loading when already loading
            if (this.isLoading) {
                return;
            }
            this.currentPageNo = this.currentPageNo + 1;
            this.performSearch(this.currentPageNo);
        },
        //
        // Init viewport with scrollbars etc
        //
        initViewport: function () {
            var self = this;
            // Init scrollbars
            self.jScrollPane = $("#stream").jScrollPane({
                enableKeyboardNavigation: false
            });

            //$("#stream ul").css("overflow", "hidden");
            //self.updateLibraryViewSettings();

            //on mobile devices (or other with small view ports) we use standard window scroll instead of jsp
            //(native scroll)
            if (self.isTouchDevice || window.outerWidth <= 991) {
                $(window).scroll(function () {
                    //do not react on scroll if info panel is visible
                    if ($("body").hasClass("item-selected")) {
                        return;
                    }
                    var height = $(document).height();
                    var scrollTop = $(document).scrollTop();
                    var viewHeight = $(window).height();
                    //var offset = $("#stream").offset().top;
                    var scrollBottomArea = 100;
                    // console.log("height:" + height + " scrollTop:" + scrollTop + " viewHeight:" + viewHeight);
                    if (height - scrollTop - viewHeight > scrollBottomArea) {
                        return;
                    }
                    self.loadNextPageIfPossible();
                });
            } else {
                //Event triggered when scrolling
                $("#stream").bind("jsp-scroll-y",
                    function (event, scrollPositionY /*, isAtBottom, isAtTop*/) {
                        //Check if there is more stuff to get
                        if (self.lastCount <= self.pageSize) {
                            return;
                        }
                        if (self.lastCount == $("#stream li").length) {
                            return;
                        }
                        var contentHeight = $("#stream ul").height();
                        var contentPosition = scrollPositionY + $("#stream").height();

                        //Load more when reaching 200 px from bottom
                        if (scrollPositionY !== 0 && contentPosition > contentHeight - 200) {
                            if (self.isLoading) {
                                return;
                            }

                            self.currentPageNo = self.currentPageNo + 1;
                            self.performSearch(self.currentPageNo);
                        }
                    });
            }

            $("#stream li").hoverIntent(function () {
                $(this).find("a.preview").fadeIn(50);
            },
                function () {
                    $(this).find("a.preview").fadeOut(50);
                });

            // Selecting multiple items or single item in library
            $("#stream ul").selectable({
                filter: "li",
                cancel: ".selected:not(.ui-selected)",
                autoRefresh: true,
                selecting: function (event, ui) {
                    if (event.originalEvent.ctrlKey || event.originalEvent.metaKey) {
                        self.ctrlKeyDown = true;
                    } else {
                        self.ctrlKeyDown = false;
                    }

                    // Set shift key to true if key down
                    if (event.originalEvent.shiftKey) {
                        self.shiftKeyDown = true;
                    } else {
                        self.shiftKeyDown = false;
                    }

                    var selectItemsButtonIsActive = $(".select-items-link").hasClass("active");

                    if (!$(event.originalEvent.target).hasClass("preview")) {
                        app.trigger("item:selected");

                        if (!self.ctrlKeyDown && !self.shiftKeyDown && !selectItemsButtonIsActive) {
                            $("#stream li.selected:not(.ui-selecting)").removeClass("selected");
                        }

                        $(ui.selecting).addClass("selected");

                        // Save selected items
                        self.setSelectedItems();

                        // Hide menus
                        $(".menu").hide();
                    }

                },
                stop: function () {
                    // Remove jQuery ui class for selected
                    $("#stream li").removeClass("ui-selected");
                    return false;
                },
                unselecting: function (event, ui) {
                    if (!$("#stream li.show-preview").length)
                        $(ui.unselecting).removeClass("selected");

                    // Save selected items
                    self.setSelectedItems();
                    return false;
                }
            });

        },

        // 
        // Check if key is cmd key or ctrl key
        //
        isCtrlOrCmdKey: function (keyCode) {
            var self = this;
            return (((self.browser === "webkit" || self.browser === "opera") && (keyCode === 91 || keyCode === 93)) ||
                (self.browser === "mozilla" && keyCode === 224) ||
                keyCode === 17);
        },

        //
        // Load preview image
        //
        loadPreview: function (data) {
            var self = this;

            //If no preview is showing append to document
            if ($("body > .fixed-preview-pane").length === 0) {
                //append preview to stream
                $("body").append(data);
            } else {
                //Replace if already visible
                $(".fixed-preview-pane").replaceWith(data);
            }

            var $visiblePreviewPane = $("body > .fixed-preview-pane #preview-pane");
            var $visiblePreviewPaneImage = $visiblePreviewPane.find("img");

            $visiblePreviewPaneImage.bind("load", function () {
                $("#imageLoader").hide();
            });

            //prevent from closing
            $(".fixed-preview-pane").click(function (event) {
                event.stopPropagation();
            });

            //attach keyup command for closing the preview
            $(document).keyup(function (e) {
                if (e.keyCode === 27) {
                    $("#preview-pane .close").click();
                }
            });

            //attach body click for closing the preview
            $(".fixed-preview-pane").click(function (ev) {

                if (!$(ev.target).closest(".dialog").length)
                    $("#preview-pane .close").click(); //body click
            });

            //close preview pane
            $("#preview-pane .close").click(function () {
                $(".fixed-preview-pane").fadeOut("fast",
                    function () {
                        $(this).remove();
                    });
                return false;
            });

            //Add events for click on arrows to show next or previous image
            $(".slide-button").click(function () {

                //Selected item
                var $selectedListItem = $("#stream li.selected");


                //Item to show instead
                var $listItemToShow;

                //Show next image
                if ($(this).hasClass("next")) {
                    $listItemToShow = $selectedListItem.next();
                    // console.log("next", $listItemToShow);
                } else {
                    $listItemToShow = $selectedListItem.prev();
                    // console.log("prev", $listItemToShow);
                }

                self.changePreviewMedia($listItemToShow);

                return false;
            });

            //Show or hide next and previous arraow depending on if next or previous image exists
            var $selectedImageListItem = $("#stream li.selected");

            //Hide prev button if no previous image
            if (!$selectedImageListItem.prev().is("li")) {
                $(".slide-button.prev").hide();
            }

            //Hide next image if no next image
            if (!$selectedImageListItem.next().is("li")) {
                $(".slide-button.next").hide();
            }
        },

        //
        // Init preview window
        //
        initPreview: function (itemId) {
            var self = this;

            $("#imageLoader").show();

            app.load({
                controller: "library",
                action: "Preview",
                data: { mediaItemId: itemId },
                success: function (data) {
                    //make sure that the fictive image preview is empty
                    $("#fictiveImagePreview").empty();
                    //If embedded content or video, just load it and skip loader
                    if (data.indexOf("<iframe") !== -1 || data.indexOf("<video") !== -1) {
                        self.loadPreview(data);
                        $("#imageLoader").hide();
                    } else {
                        $("#fictiveImagePreview").append(data);

                        //Hide image until loaded and show loader for image
                        $("#fictiveImagePreview img").bind("load",
                            function () {
                                self.loadPreview(data);
                            });
                    }
                },
                error: function (error) {
                    $("#imageLoader").hide();
                    app.showError("Error loading preview", error);
                }
            });

        },

        //
        //Change media in preview
        //
        changePreviewMedia: function ($listItemToShow) {
            var self = this;

            self.$lastSelectedItem = $listItemToShow;

            //Selected item
            var $selectedListItem = $("#stream li.selected");

            //Check if next or previous image exists then change preview image
            if ($listItemToShow && $listItemToShow.is("li")) {
                $listItemToShow.addClass("selected");

                if (!self.shiftKeyDown)
                    $selectedListItem.removeClass("selected");

                clearTimeout(self.changeImageTimeOut);

                if ($("#preview-pane").length > 0)
                    $("#imageLoader").show();

                self.changeImageTimeOut = setTimeout(function () {

                    // Show information
                    var id = $listItemToShow.attr("data-item-id");

                    // Update infopanel
                    if (window.outerWidth > 991) {
                        self.infoPanel.show(id);
                    }
                    self.$chosenItem = $listItemToShow;
                    // Save selected items
                    self.setSelectedItems();

                    //Show preview if one is already active
                    if ($("#preview-pane").length > 0) {
                        $listItemToShow.find("img").trigger("dblclick");

                    }


                },
                    50);

                //Scroll to item
                self.scrollToObject($listItemToShow);

            }
            return false;
        },

        //
        // Scroll to object
        //
        scrollToObject: function ($item) {
            var self = this;

            // Scroll to item
            var jsp = self.jScrollPane.data("jsp");

            if ($item && $item.length)
                jsp.scrollToElement($item, false, true);
        },

        //
        // Set new values for scroll 
        //
        reinitializeScroll: function () {
            var self = this;

            clearTimeout(self.reinitializeScrollTimeout);

            // Reinitialize scrollbars
            if (self.jScrollPane) {
                var jsp = self.jScrollPane.data("jsp");

                if (jsp) {
                    jsp.reinitialise();
                }
            }
            this.forceNewPageIfResultNotFillingUpPage();
        },
        thumbnailToUse: null,
        setThumbnailSource: function (refreshSize, $container) {
            var self = this;
            var firstThumbnailWidth = $("#stream .thumbnail").first().width();
            if (refreshSize || !this.thumbnailToUse) {
                // Get thumbnail wrappers width and height (max height and width for thumbnails)
                var firstThumbnailHeight = $("#stream .thumbnail").first().height();
                var firstImageHighestWidthOrHeight = firstThumbnailWidth > firstThumbnailHeight ?
                    firstThumbnailWidth :
                    firstThumbnailHeight;

                // Which attribute to use depending on width on thumbnails
                this.thumbnailToUse = "small";
                if (firstImageHighestWidthOrHeight > 200)
                    this.thumbnailToUse = "medium";
                if (firstImageHighestWidthOrHeight > 300)
                    this.thumbnailToUse = "large";
            }
            if (!$container) {
                $container = $("#stream");
            }
            $("img", $container).each(function () {
                ImageVaultUi.ThumbnailUtil.setImageAttributes($(this), self.thumbnailToUse, firstThumbnailWidth);
            });
        },

        /*
         * Set up Masonry with current column width
         */
        setupMasonry: function () {
            var numColumns = $("#stream").attr("data-number-of-columns");
            var colWidthSelector = '#stream[data-number-of-columns="' + numColumns + '"] li';
            // console.log(colWidthSelector);

            var $mediaItemList = $(".media-item-list");
            this.$masonry = $mediaItemList.masonry({
                itemSelector: "li.media-item",
                columnWidth: colWidthSelector,
                transitionDuration: 0
            });
        },

        updateLibraryViewSettings: function () {
            this.setThumbnailSource(true);
            var self = this;

            // Hide the image stream
            if (!self.isTouchDevice) {
                $("#stream ul").css("visibility", "hidden");
            };

            // Reinitialize masonry
            setTimeout(function () {
                self.setupMasonry();
                //Adjust scrollbar
                self.reinitializeScroll();
                // Show the image stream
                $("#stream ul").css("visibility", "visible");
            },
                200);
        },

        //
        // Set/Save selected items state
        //
        setSelectedItems: function (notSelectEmpty) {
            var self = this
            var selectedItems = [];

            $("#stream li.selected").each(function () {
                var mediaItemId = $(this).attr("data-item-id");

                selectedItems.push(mediaItemId);
            });

            if (selectedItems.length || !notSelectEmpty) {
                if (!self.isTouchDevice) {
                    $.bbq.pushState({ "items": selectedItems.join(",") });
                }
            }

            if (selectedItems.length === 0) {
                // Update info panel
                this.infoPanel.show(0);
            } else if (selectedItems.length === 1) {
                $.bbq.pushState({ "pos": this.jScrollPane.data("jsp").getPercentScrolledY() });
            }

            this.printLibraryMessage();

            // Update draggable event
            this.initDraggableEvent();

            // Update toolbar
            this.toolbar.updateToolbar();
        },

        getSelectedLibraryItemIds: function () {
            var items = $.bbq.getState("items");

            // If not items check if item is selected in information view
            if (!items)
                items = $("#details-viewport").attr("data-item-id");

            if (items)
                return items.split(",");

            return null;
        },

        //
        // Print message with number of selected items to library view
        //
        printLibraryMessage: function () {
            var items = this.getSelectedLibraryItemIds();

            if (this.totalCount === null) {
                this.totalCount = 0;
            }

            // Print message to library view
            if (items) {
                var count = (this.usingSearchEngine) ? this.totalCount : $("#stream li").length;
                $(".library-message").text(items.length + " " + translate("common.Of") + " " + count + " " + translate("library.NumberOfSelectedFiles"));
            } else if (this.usingSearchEngine) {
                $(".library-message").text(this.totalCount + " " + translate("library.NumberOfFiles"));
            } else {
                var count = $("#stream li").length;
                $(".library-message").text(count + " " + translate("library.NumberOfFiles"));
            }

            if (!items || items.length === 0 || items[0] === "") {
                $(".add-to-batch-area").hide();
            } else {
                $(".add-to-batch-area").show();
            }
        }
    };
    ns.LibraryView = libraryView;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});