﻿(function($, ns) {
    var lightbox = function(config) {
        this.init(config);
        return this;
    };
    lightbox.prototype = {
        //properties
        $domobject: null,
        leftPos: 0,
        thumbnailFormatId: null,

        //
        // Initialize method
        //
        init: function(config) {
            $.extend(this, config);

            if (this.$domobject === undefined)
                throw "$domobject is not defined in config";
            var self = this;

            // Create droppable event
            self.$domobject.droppable({
                scope: "mediaItem",
                accept: "li",
                hoverClass: "drophover",
                tolerance: "pointer",
                over: function() {
                    $(".drag-items-helper").addClass("over");
                    $(".drag-items-helper").append('<img src="images/icon-add.png" class="helper" />');
                },
                out: function() {
                    $(".drag-items-helper").removeClass("over");
                    $(".drag-items-helper").find("img:last-child").remove();
                },
                drop: function() {
                    self.addToLightbox();
                }
            });

            // Init scrollbars
            this.redrawLightbox();

            // Resize stream height on window resize 
            $(window).resize(function() {
                self.redrawLightbox();
            });

            this.$domobject.find("span.remove").live("click", function() {
                self.removeFromLightbox($(this).closest("li").attr("data-item-id"));
            });

            $("a.clear-batch-area").live("click", function() {
                if ($(this).hasClass("inactive"))
                    return false;
                self.clearLightbox();
                return false;
            });

            this.$domobject.find("li").live("mouseover mouseout", function(event) {
                if (event.type === "mouseover") {
                    $(this).find("span.remove").show();
                } else {
                    $(this).find("span.remove").hide();
                }
            });

            // Add click event to lightbox to select
            this.$domobject.live("click", function(e) {
                if ($(e.target).hasClass("remove"))
                    return false;

                self.$domobject.addClass("selected");

                // Save lightbox selected state
                $.bbq.pushState({ "lightboxSelected": true });

                // Show message that lightbox is selected
                self.printLibraryMessage();

                // Clear selected items
                app.trigger("lightbox:selected");

                return true;
            });

            // Check if lightbox is selected
            if ($.bbq.getState("lightboxSelected") === "true") {
                self.$domobject.addClass("selected");

                self.printLibraryMessage();

                // Update toolbar
                app.trigger("app:openedForInsertChanged");

            } else {
                self.unselectLightbox();
            }

            // Listen for application events
            app.bind("stream:addToLightbox", this.addToLightbox, this);

            // Monitor changes for opener changes
            app.bind("media:versionchange", this.reloadLightbox, this);

            // Event for item selected
            app.bind("item:selected", this.unselectLightbox, this);

            // Remove items from lightbox if removed from delete dialog
            app.bind("deleteDialog:itemsRemoved", this.removeFromLightbox, this);

            // Items is deleted
            app.bind("deleteDialog:fileDeleted", this.reloadLightbox, this);
        },

        //
        // Redraws and initializes the lightbox
        //
        redrawLightbox: function(html) {

            var pane = this.$domobject.find(".pane");
            var jspane = pane.find(".jspPane");
            this.leftPos = jspane.css("left");
            if (html) {
                this.$domobject.html(html);
                pane = this.$domobject.find(".pane");
            }

            this.initializejScrollPane(pane);
            jspane = pane.find(".jspPane");
            jspane.css("left", this.leftPos);

            // Hide or show clear button
            if (this.$domobject.find("li").length) {
                $("a.clear-batch-area").show();
            } else {
                $("a.clear-batch-area").hide();
            }

            //only trigger in case visibility state changes
            if ($("#lightbox li").length) {
                if (!$("body").hasClass("has-batch-items")) {
                    $("body").addClass("has-batch-items");
                    app.trigger("lightbox:hasChanged");
                }
            } else {
                if ($("body").hasClass("has-batch-items")) {
                    $("body").removeClass("has-batch-items");
                    app.trigger("lightbox:hasChanged");
                }
            }

        },

        //
        // Reload lightbox
        //
        reloadLightbox: function() {
            var self = this;
            app.load({
                controller: "Library",
                action: "GetLightbox",
                success: function(data) {
                    self.redrawLightbox(data);
                    app.trigger("lightbox:updateToolbarMenuTemplates", data);
                }
            });
        },

        //
        // Add to lightbox
        //
        addToLightbox: function() {
            var self = this;

            var mediaItemIds = $.bbq.getState("items");

            if (mediaItemIds != undefined)
                mediaItemIds = mediaItemIds.split(",");
            else {
                mediaItemIds = null;
            }

            var loading = new IVNotification(translate("common.Loading"));

            app.load({
                controller: "Library",
                action: "AddToLightBox",
                data: { mediaItemIds: mediaItemIds },
                success: function(data) {
                    self.redrawLightbox(data);
                    app.trigger("lightbox:updateToolbarMenuTemplates", data);
                    app.trigger("lightbox:itemAdded", mediaItemIds);
                    loading.remove();
                    self.redrawLightbox(data);
                }
            });
        },

        //
        // Removes one or more items from the lightbox.
        // @itemIds either an array of id or a single id of the item that should be removed
        // @callback Optional callback function that is invoked when the items is removed from the lightbox successfully.
        //
        removeFromLightbox: function(itemIds, callback) {
            if (!itemIds)
                return;
            // Make sure that it is an array
            if (!$.isArray(itemIds)) {
                itemIds = [itemIds];
            }
            var self = this;

            for (var i = 0; i < itemIds.length; i++) {
                var $figure = $(".pane li[data-item-id=" + itemIds[i] + "]", this.$domobject);
                $figure.remove();
            }

            self.redrawLightbox();

            // Only needed for the remove button since all other replaces the html
            app.load({
                url: "Library/RemoveFromLightBox",
                data: { mediaItemIds: itemIds },
                success: function(data) {
                    //app.trigger("lightbox:updateToolbarMenuTemplates", data);
                    if (callback) {
                        callback();
                    }
                }
            });
        },

        //
        // Clear lightbox
        //
        clearLightbox: function() {
            var self = this;
            app.load("Library", "ClearLightBox", function(data) {
                self.redrawLightbox(data);
                app.trigger("lightbox:itemsCleared");
                self.printLibraryMessage();
            });
        },

        //
        // Reinitialize scroll
        //
        initializejScrollPane: function(elm) {
            var self = this;
            elm.unbind("jsp-initialised");
            elm.bind("jsp-initialised", function(event, isScrollable) {

                if (!isScrollable) {
                    self.leftPos = 0;
                }
            }).jScrollPane({
                showArrows: true
            });
        },

        //
        // Unselect lightbox
        //
        unselectLightbox: function() {
            this.$domobject.removeClass("selected");
            var currentState = $.bbq.getState("lightboxSelected");
            if (currentState)
                $.bbq.pushState({ "lightboxSelected": false });
        },

        // Shows message if lightbox is selected
        printLibraryMessage: function() {
            if ($.bbq.getState("lightboxSelected") === "true") {
                // Print message to library view
                if (this.$domobject.find("li").length)
                    $(".library-message").text(translate("library.LightboxSelected"));
                else {
                    $(".library-message").text("");
                }
            }
        }
    };
    ns.Lightbox = lightbox;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});