﻿(function($, ns) {
    var nav = function(config) {
        this.init(config);
        return this;
    };
    nav.prototype = {
        navLibraryTab: null,
        navCategoriesTab: null,
        navAgreementsTab: null,
        navConsentsTab: null,
        navToolbar: null,
        currentTab: null,
        cookieTimeout: null,
        init: function(config) {
            $.extend(this, config);
            var self = this;

            //Show scrollbar on area hover
            $("#nav").hover(
                function() { $("#nav .scrollbars .track").fadeIn("fast"); },
                function() { $("#nav .scrollbars .track").fadeOut("fast"); }
            );

            this.navToolbar = new ImageVaultUi.NavToolbar({ $domobject: $("div#nav-toolbar") });
            this.navLibraryTab = new ImageVaultUi.NavLibraryTab({ nav: this, $domobject: $("div#library-viewport") });
            this.navAgreementsTab = new ImageVaultUi.NavAgreementsTab({ nav: this, $domobject: $("div#agreements") });
            this.navCategoriesTab = new ImageVaultUi.NavCategoriesTab({ nav: this, $domobject: $("div#categories") });
            this.navConsentsTab = new ImageVaultUi.NavConsentsTab({ nav: this, $domobject: $("div#consents") });

            // reinitialize nav scrollbars
            // $(window).bind("reinitializenavscroll", this.initScrollPane);
            // app.bind("lightbox:hasChanged", this.initScrollPane, this);

            this.initViewport();

            //Navigtation tab events
            $("#nav-tabs a").click(function() {
                //Push state to hash
                var state = {};
                state["tab"] = $(this).attr("class");

                $.bbq.pushState(state);

                return false;
            });

            $(window).bind("hashchange", function() {

                var tab = $.bbq.getState("tab");
                //make sure we have a defined tab (even if no tab is passed on the #)
                if (typeof tab === "undefined" || !tab) {
                    tab = ImageVaultUi.NavigationEvents.tabs.category;
                }
                //ignore selected tabs
                if (MeridiumUtil.endsWith(tab, " selected")) {
                    return;
                }
                self.loadTab(tab);
            });

            // Initiate new scroll
            // $(window).resize(function() {
            //     self.initScrollPane();
            // });
        },
        loadTab: function(tab) {
            var self = this;
            var newTab = undefined;
            if (tab === ImageVaultUi.NavigationEvents.tabs.library) {
                newTab = this.navLibraryTab;
            } else if (tab === ImageVaultUi.NavigationEvents.tabs.category) {
                newTab = this.navCategoriesTab;
            } else if (tab === ImageVaultUi.NavigationEvents.tabs.agreement) {
                newTab = this.navAgreementsTab;
            } else if (tab === ImageVaultUi.NavigationEvents.tabs.consent) {
                newTab = this.navConsentsTab;
            }

            //skip reloading same tab...
            if (newTab === this.currentTab)
                return;

            if (newTab === undefined) {
                throw "undefined tab " + tab;
            }
            $("#nav-tabs a").removeClass("selected");
            if (this.currentTab != undefined) {
                this.currentTab.hide();
            }
            this.currentTab = newTab;
            var $tab = $("#nav-tabs a." + tab);
            $tab.addClass("selected");
            this.currentTab.show();

            self.initViewport();
        },
        initViewport: function() {

            // this.initScrollPane();

            // Resizable on navigation
            $("#nav").resizable({
                minWidth: 250,
                maxWidth: 500,
                handles: "e, se",
                start: function() {
                    var resizeMaxWidth = $("#toolbar").width() - 690 - $("#details").width();
                    resizeMaxWidth = resizeMaxWidth > 500 ? 500 : resizeMaxWidth;
                    $("#nav").resizable("option", "maxWidth", resizeMaxWidth);
                },
                resize: function() {
                    var resizeWidth = $("#nav").width();

                    // Move actions
                    $("ul#actions").css("left", resizeWidth);

                    // Move display options for library
                    $("#display-options").css("left", resizeWidth + "px");

                    clearTimeout(self.cookieTimeout);

                    self.cookieTimeout = setTimeout(function() {
                            // Set cookie for width of navigation column
                            var cookieData = ImageVaultUi.Common.getJsonCookie("ImageVaultCookieData");
                            cookieData["NavigationColumnWidth"] = resizeWidth;
                            ImageVaultUi.Common.setCookie("ImageVaultCookieData", cookieData, 1);
                        },
                        500);

                    // Event for changing column size in library
                    app.trigger("column:changingsize");
                },
                stop: function() {
                    // Reinititialize scrollbars for library
                    app.trigger("column:changedsize");
                }
            }).live("resize", function(e) {
                e.stopPropagation();
            });
        },

        // initScrollPane: function() {
        //     //replaced jscrollpane with flex layout and styled scrollbars
        //     //Calculate height och scrollable area
        //     var height = $("#nav").height() - $("#nav-tabs").height() - $("#nav-toolbar").height();
        //     //$("#nav-viewport").height(height - 10);

        //     //Init scrollbar
        //     $("#nav-viewport").jScrollPane();
        // }
    };
    //export to namespace
    ns.Nav = nav;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});