﻿(function ($, ns, undefined) {
    var navAgreementsTab = function (config) {
        this.init(config);
        return this;
    };
    navAgreementsTab.prototype = {
        // Properties
        nav: null,
        $domobject: undefined,
        skip: 0,
        take: 50,
        canGetMore: true,

        // Methods
        init: function (config) {
            $.extend(this, config);
            if (this.$domobject === undefined)
                throw "$domobject is not defined in config";
            var self = this;

            $("a", this.$domobject).live("click", function () {
                $(this).blur();
                var agreementId = $(this).attr("data-agreement-id");
                self.updateHash(agreementId);
                return false;
            });

            // Search agreements
            $("#searchAgreements", this.$domobject).live("click", function () {
                self.refreshAndSelectAgreements(false, [0]);
                return false;
            });

            // Search agreements by enter key
            $("#agreementsSearchTerm", this.$domobject).live("keydown", function (e) {
                var code = e.keyCode || e.which;
                if (code === 13) {
                    self.refreshAndSelectAgreements(false, [0]);
                }
            });

            // Search agreements by enter key
            $("#agreementsValidToDate", this.$domobject).live("change", function (e) {
                self.refreshAndSelectAgreements(false, [0]);
                return false;
            });

            app.bind("agreementDialog:agreementSaved", this.agreementSaved, this);
            app.bind("agreementDialog:agreementDeleted", this.agreementDeleted, this);

            //Event for agreement selection
            $("input.agreement-checkbox", this.$domobject).live("change", function () {
                var $item = $(this).closest("li");

                var agreementId = $item.attr("data-agreement-id");

                // If only select one agreement
                if ($.bbq.getState("tsma") !== "true") {
                    // If same as existing remove selection
                    var currentSelectedAgreements = self.getSelectedAgreements();
                    if (currentSelectedAgreements && agreementId === currentSelectedAgreements[0])
                        self.saveAgreementsToHash([]);
                    else
                        self.saveAgreementsToHash([agreementId]);

                    self.selectAgreementsFromHash();
                    return;
                }

                if ($(this).is(":checked")) {
                    if (agreementId === "0") {
                        self.saveAgreementsToHash($("#agreements li").map(function () {
                            return $(this).attr("data-agreement-id");
                        }).get());
                    } else {
                        self.addAgreementToHash(agreementId);
                    }
                } else {
                    if (agreementId === "0") {
                        self.saveAgreementsToHash([]);
                    } else {
                        self.removeAgreementsFromHash(agreementId);
                    }
                }
            });

            // Toggle select multiple agreements
            $("#toggleSelectMultipleAgreements", this.$domobject).live("change", function () {
                var $item = $(this);
                if ($item.is(":checked")) {
                    $.bbq.pushState({ tsma: true });

                } else {
                    $.bbq.pushState({ tsma: false });
                }
            });

            $(window).bind("hashchange", function (e) {
                self.updateFromHash();
            });
        },

        /**updateFromHash
         * Update selected values from hash
         * @returns {} 
         */
        updateFromHash: function () {

            if ($.bbq.getState("tab") !== ImageVaultUi.NavigationEvents.tabs.agreement)
                return;

            // Selected agreements from hash
            var agreementIds = this.selectAgreementsFromHash();

            if (agreementIds && agreementIds.length == 1 && agreementIds[0] != "0") {
                // Enable edit button always
                app.trigger(ImageVaultUi.NavigationEvents.navtoolbarEnableButton,
                    ImageVaultUi.NavigationEvents.navtoolButtons.edit);
                // Point to right dialog
                app.unbind(ImageVaultUi.NavigationEvents.navtoolbarEditClick);
                app.bind(ImageVaultUi.NavigationEvents.navtoolbarEditClick, this.openEditDialogForSelectedAgreement, this);
            } else {
                app.trigger(ImageVaultUi.NavigationEvents.navtoolbarDisableButton, ImageVaultUi.NavigationEvents.navtoolButtons.edit);
                app.unbind(ImageVaultUi.NavigationEvents.navtoolbarEditClick);
            }


            // Select select multiple vaults
            if ($.bbq.getState("tsma") === "true") {
                $("#toggleSelectMultipleAgreements").attr("checked", "checked");
                $("#agreements").addClass("select-multiple");
            } else {
                $("#toggleSelectMultipleAgreements").removeAttr("checked");
                $("#agreements").removeClass("select-multiple");
            }
        },

        /**
 * Save agreements to hash
 * @param {} agreements
 * @returns {} 
 */
        saveAgreementsToHash: function (agreements) {
            //Remove key if no agreements left
            if (agreements.length === 0) {
                $.bbq.removeState("agreements");
                return;
            }

            //Push state to hash
            var state = {};
            state["agreements"] = agreements.join(",");
            $.bbq.pushState(state);
        },

        /**
 * Remove agreement from hash
 * @param {} agreementId
 * @returns {} 
 */
        removeAgreementsFromHash: function (agreementId) {
            var agreements = this.getSelectedAgreements();

            // Remove agreement from array.
            for (var i = 0; i < agreements.length; i++) {
                if (agreements[i] === agreementId) {
                    agreements.splice(i, 1);
                    break;
                }
            }
            this.saveAgreementsToHash(agreements);
        },

        /**
* Add agreement to hash
* @param {} agreementId
* @returns {} 
*/
        addAgreementToHash: function (agreementId) {
            var agreements = this.getSelectedAgreements();

            //Add agreement id to array
            agreements.push(agreementId);

            this.saveAgreementsToHash(agreements);
        },

        /**
* Select agreements from hash
* @returns {} 
*/
        selectAgreementsFromHash: function () {
            $("input.agreement-checkbox", this.$domobject).removeAttr("checked");
            $("#agreements li").removeClass("active");

            var agreementIds = this.getSelectedAgreements();
            for (var i in agreementIds) {

                var $listItem = $("li[data-agreement-id=" + agreementIds[i] + "]", this.$domobject);
                var $element = $listItem.children().children("input.agreement-checkbox");

                $element.attr("checked", "checked");
                $listItem.addClass("active");

            }

            if (agreementIds.length === 0) {
                $("li[data-agreement-id=0]").addClass("active");
            }

            return agreementIds;
        },

        /**
 * Get selected agreements
 * @returns {} 
 */
        getSelectedAgreements: function () {
            //using bbq
            var agreementsAsString = $.bbq.getState("agreements");
            if (typeof agreementsAsString === "undefined" || agreementsAsString.length === 0) {
                return new Array();
            }
            return agreementsAsString.split(",");
        },

        // Shows the agreements tab
        show: function () {
            this.$domobject.show();

            var selectedAgreements = this.getSelectedAgreements();

            // Refresh list and select agreements
            this.refreshAndSelectAgreements(false, selectedAgreements, false);

            // Set state of delete button
            app.trigger(ImageVaultUi.NavigationEvents.navtoolbarDeleteState, ImageVaultUi.NavigationEvents.navtoolbarDeleteStates.delete);

            this.updateFromHash();
        },

        // Hides the agreements tab
        hide: function () {
            this.$domobject.hide();
        },

        updateHash: function (agreementId) {
            $.bbq.pushState({ agreementid: agreementId, tab: ImageVaultUi.NavigationEvents.tabs.agreement }, 0);
        },

        // Opens the agreement dialog for the selected agreement
        openEditDialogForSelectedAgreement: function () {
            var agreementId = this.getSelectedAgreements()[0];
            new ImageVaultUi.AgreementDialog({ agreementId: agreementId }).open();
        },

        // Opens the new agreement dialog
        openNewAgreementDialog: function () {
            ImageVaultUi.A.OpenDialog(-1);
        },

        // Callback methods for agreement getting saved
        agreementSaved: function (data) {
            // Get agreement list with new agreement included
            var agreementIds = this.getSelectedAgreements()
            this.refreshAndSelectAgreements(false, agreementIds);
        },

        // Callback method for agreement getting deleted
        agreementDeleted: function (agreementId) {
            this.refreshAndSelectAgreements(false, []);
        },

        // Refreshes the agreements list and selects the agreement with the given id.
        refreshAndSelectAgreements: function (selectAllAgreements, agreementIds, fromScroll) {

            var self = this;

            // If from scroll and already loading or can not get more result
            if (fromScroll && (self.isLoading || !self.canGetMore)) return;

            self.isLoading = true;

            if (!fromScroll)
                self.skip = 0;

            var loading = new IVNotification(translate("common.Loading"), { showOverlay: true });
            app.load({
                controller: "agreement",
                action: "GetAgreementList",
                data:
                {
                    selectedAgreementIds: agreementIds,
                    SearchTerm: $("#agreementsSearchTerm").val(),
                    MediaItemId: "",
                    ValidDateFilter: $("#agreementsValidToDate").val(),
                    Skip: self.skip,
                    Take: self.take
                },
                success: function (data) {
                    // If result contains any agreements it will be greater than 40 chars
                    self.canGetMore = data.length > 40;
                    self.isLoading = false;

                    if (fromScroll) {
                        // Append to agreements list
                        $("#agreementList", self.$domobject).append(data);

                        // Reload scroll iselectAgreementsFromHash f needed
                        // $(window).trigger("reinitializenavscroll");

                        // Remove loader
                        loading.remove();
                    } else {

                        // Update agreements list
                        $("#agreementList", self.$domobject).html(data);

                        // If set active (get value from url)
                        if (selectAllAgreements) {
                            $("#agreements li[data-agreement-id='0'] input", self.$domobject).click();
                        } else {
                            self.saveAgreementsToHash(agreementIds);
                        }

                        // Add scroll if needed
                        // $(window).trigger("reinitializenavscroll");

                        //Event triggered when scrolling
                        $("#nav-viewport").bind("jsp-scroll-y",
                            function (event, scrollPositionY /*, isAtBottom, isAtTop*/) {

                                var contentHeight = $("#nav-viewport ul.list-agreements").outerHeight();

                                var contentPosition = scrollPositionY + $("#nav-viewport").height();

                                //Load more when reaching 60 px from bottom
                                if (contentPosition > contentHeight - 60) {
                                    if (self.isLoading) {
                                        return;
                                    }

                                    self.skip += self.take;

                                    self.refreshAndSelectAgreements(false, agreementIds, true);
                                }
                            });

                        loading.remove();
                    }
                    app.trigger("navAgreementTab:agreementsListLoaded");
                    self.selectAgreementsFromHash();
                }

            });
        }
    };
    ns.NavAgreementsTab = navAgreementsTab;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});