﻿(function($, ns, undefined) {
    var navToolbar = function(config) {
        this.init(config);
        return this;
    };
    navToolbar.prototype = {
        //properties
        $domobject: undefined,
        createPopupMenu: null,
        //method
        init: function(config) {
            $.extend(this, config);
            if (this.$domobject === undefined)
                throw "$domobject is not defined in config";
            this.disableAllButtons();
            var self = this;
            var popupDom = $("#create-menu", this.$domobject);
            this.createPopupMenu = new ImageVaultUi.PopupMenu({ $domobject: popupDom });
            this.createPopupMenu.hide();
            this.createPopupMenu.bind("createVaultClick", function() { ImageVaultUi.VaultDialog.OpenDialog(-1); });
            this.createPopupMenu.bind("createCategoryClick", function() {
                $.bbq.pushState({ 'admin-tab': 'categories' });
                ImageVaultUi.AdminView.OpenDialog();
            });

            this.createPopupMenu.bind("createAgreementClick", function() {
                new ImageVaultUi.AgreementDialog({ agreementId: 0 }).open();
            });
            this.createPopupMenu.bind("createConsentUserClick", function() {
                window.ImageVault.ConsentAgreementTabApp.showCreateConsentUserDialog();
            });

            this.createPopupMenu.bind("createCollectionClick", function() {
                new ImageVaultUi.CollectionDialog({ collectionId: undefined }).open();
            });

            //toggle create popup when click on the create button
            $("a[data-name='create']", this.$domobject).click(function() {
                //don't bubble disabled button events
                if ($(this).hasClass('disabled'))
                    return false;
                self.createPopupMenu.toggle();
                return false;
            });
            //toggle create popup when click on all buttons that isn't create
            $(">ul a[data-name!='create']", this.$domobject).click(function() {
                //don't bubble disabled button events
                if ($(this).hasClass('disabled'))
                    return false;
                var dataName = $(this).attr("data-name");
                app.trigger("navtoolbar:" + dataName + "Click");
                return false;
            });

            if (app.isUserInRole(ImageVaultUi.GlobalRoles.Administrator | ImageVaultUi.GlobalRoles.CategoryAdministrator | ImageVaultUi.GlobalRoles.AgreementsUser)) {
                this.enableButton("create");
            }

            app.bind(ImageVaultUi.NavigationEvents.navtoolbarEnableButton, this.enableButton, this);
            app.bind(ImageVaultUi.NavigationEvents.navtoolbarDisableButton, this.disableButton, this);

        },
        getButtonContainer: function(name) {
            return this.getButton(name).parent();
        },
        getButton: function(name) {
            var button = $("a[data-name='" + name + "']", this.$domobject);
            if (button.length == 0)
                button = $("a#" + name, this.$domobject);
            return button;
        },
        //shows a button
        showButton: function(name) {
            this.getButtonContainer(name).show();
        },
        enableButton: function(name) {
            this.getButton(name).removeClass('disabled');
        },
        disableButton: function(name) {
            this.getButton(name).addClass('disabled');
        },
        disableAllButtons: function() {
            $(">ul li a", this.$domobject).addClass('disabled');
        }
    };
    ns.NavToolbar = navToolbar;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});