﻿(function ($, ns) {
  const toolbar = function (config) {
    this.init(config)
    return this
  }

  toolbar.prototype = {
    downloadPopup: null,
    insertPopup: null,
    movePopup: null,
    sharePopup: null,
    thumbnailFormatId: null,
    libraryView: null,
    maxCount: 0,
    insertMultiple: null,
    deleteState: null,
    linkDialog: null,

    //
    // Initialize method
    //
    init: function (config) {
      $.extend(this, config)
      var self = this;

      if (this.$domobject === undefined) { throw '$domobject is not defined in config' }

      $(window).bind('hashchange', function () {
        if (app.hasStateChanged('items')) {
          // Triggered when the hash changes e.g. user clicks the back button in browser
          self.updateToolbar()
        }
        if (app.hasStateChanged('vaults')) {
          self.updateImportButton($.bbq.getState('vaults'))
        }
      })

      // Append vaultId as querystring parameter when clicking on the import button
      $('a.import', this.$domobject).click(function () {
        if ($(this.parentElement).hasClass('inactive')) {
          return false
        }
        let href = $(this).attr('href')
        const vaults = $.bbq.getState('vaults')
        if (vaults) {
          const vaultId = vaults.split(',')[0]
          if (vaultId) {
            href = href + '?vaultid=' + vaultId
          }
        }
        if (self.libraryView.isTouchDevice) {
          href = href + '?device'
        }
        document.location = href
        return false
      })

      $('.createAgreement-mobile').click(function () {
        new ImageVaultUi.AgreementDialog({ agreementId: 0 }).open()
      })

      $('#actions .download', this.$domobject).click(function () {
        if ($(this).hasClass('inactive')) { return false }
        self.openDownloadMenu(self.getSelectedItemIds())
        return false
      })

      $('#actions .insert', this.$domobject).live('click', function () {
        if ($(this).hasClass('inactive')) { return false }
        self.openInsertMenu(self.getSelectedItemIds())
        return false
      })

      // Event for toggle top menu
      $('#actions .top-menu-button', this.$domobject).live('click', function () {
        const x = document.getElementById('actions')
        if (x.className === 'topnav') {
          x.className += ' responsive'
          $('.move').addClass('hidden')
        } else {
          x.className = 'topnav'
        }

        return false
      })

      $('#actions .move').live('click', function () {
        if ($(this).hasClass('inactive')) { return false }

        const selectedItems = self.getSelectedItems()

        // Find all items that can be moved
        const unMovableItems = self.getSelectedItems(':not(.move)')

        // Can we move all?
        const numberOfUnMovableFiles = unMovableItems.length

        const exceededMaxCountWidthNumberOfFiles = selectedItems.length - self.maxCount

        if (numberOfUnMovableFiles > 0 || exceededMaxCountWidthNumberOfFiles > 0) {
          self.showCannotMovePopup(unMovableItems, exceededMaxCountWidthNumberOfFiles, selectedItems.length)
          return false
        }
        self.openMoveMenu(self.getSelectedItemIds())
        return false
      })

      $('#actions .delete', this.$domobject).click(function () {
        if ($(this).hasClass('inactive')) {
          return false
        }

        const isCollection = self.deleteState === 'removeFromCollection'
        if (isCollection) {
          // don't show dialog, just delete
          const selectedCollections = $('#scope li.collections')
          for (let i = 0; i < selectedCollections.length; i++) {
            collectionId = selectedCollections[i].getAttribute('data-value')
            new ImageVaultUi.DeleteDialog(self.getSelectedItemIds).deleteFromCollection(collectionId, self.getSelectedItemIds())
          };
        } else {
          ImageVaultUi.DeleteDialog.OpenDialog(self.getSelectedItemIds())
        }
        return false
      })

      $('#actions .organize', this.$domobject).live('click', function () {
        // Disable anchor when button is disabled
        if ($(this).hasClass('inactive')) { return false }

        // Find all selected items
        const items = self.getSelectedItemIds()
        // Find all items that can be organized
        const unOrganizableItems = self.getSelectedItems(':not(.contribute)')

        // Can we organize all?
        const numberOfUnOrganizableItems = unOrganizableItems.length
        const numberOverMaxCount = items.length - self.maxCount

        if (numberOfUnOrganizableItems > 0 || numberOverMaxCount > 0) {
          self.showCannotOrganizePopup(unOrganizableItems)
          return false
        }

        window.location.href = app.createPath('organize', 'Items/' + self.getSelectedItemIds()) + window.location.hash

        return false
      })

      $('#actions .share', this.$domobject).click(function () {
        if ($(this).hasClass('inactive')) { return false }
        self.openShareMenu(self.getSelectedItemIds())
        return false
      })

      $('#actions .more-button', this.$domobject)
        .click(function () {
          if ($(this).hasClass('inactive')) {
            return false
          }

          const $item = self.getSelectedItems()[0]
          self.openMoreMenu($item)
          return false
        })

      $('.auth-btn').click(function (event) {
        if ($('.dropdown-card').hasClass('hide')) {
          $('body').bind('click', function (e) {
            const target = (e && e.target) || (event && event.srcElement)

            if ($('.dropdown-card').find(target.length === 0)) {
              $('.dropdown-card').addClass('hide')
            }
          })

          $('.dropdown-card').removeClass('hide')
          event.stopPropagation()
        } else {
          $('body').unbind('click')
          $('.dropdown-card').addClass('hide')
        }
      })

      // Add actions for column buttons
      $('.columns a').click(function () {
        self.changeNumberOfColumns($(this).attr('data-columns'))
        return false
      })

      // Show select items link if tablet or mobile
      const isMobile = navigator.userAgent.match(/(iPhone|iPod|iPad|Android|BlackBerry)/)
      if (isMobile) { $('.select-items-button').show() }

      // Monitor changes for opener changes
      app.bind('app:openedForInsertChanged', this.updateToolbar, this)

      // Update templates for menu
      app.bind('lightbox:updateToolbarMenuTemplates', this.updateMenuTemplates, this)

      // Update state of delete button for collections
      app.bind(ImageVaultUi.NavigationEvents.navtoolbarDeleteState, this.setDeleteState, this)
    },

    //
    // Updates the download, move and cannot-organize menu templates
    //
    updateMenuTemplates: function (data) {
      const element = $(document.createElement('div')).html(data)
      this.$downloadMenuTemplate = $('#download-menu-template', element)
      this.$cannotOrganizePopupTemplate = $('#cannot-organize-menu-template', element)
      this.$cannotMovePopupTemplate = $('#cannot-move-menu-template', element)
      this.$moveMenuTemplate = $('#move-menu-template', element)
      this.$shareMenuTemplate = $('#share-menu-template', element)
    },

    updateImportButton: function (ids) {
      const button = document.querySelector('.import')
      if (!button) {
        return false
      }
      if (!ids || ids.split(',')[0] == '0') {
        button.parentElement.classList.remove('inactive')
      } else {
        app.load({
          controller: 'library',
          action: 'GetVaultAccess',
          data: { vaultIds: ids.split(',') },
          dataType: 'JSON',
          success: function (canContribute) {
            if (canContribute) {
              button.parentElement.classList.remove('inactive')
            } else {
              button.parentElement.classList.add('inactive')
            }
          },
          error: function (error) {
            app.showError(error)
          }
        })
      }
    },
    //
    // Update toolbar
    //
    updateToolbar: function () {
      if (!app.openedForInsert()) {
        $('#actions .insert a #ui-caption').text(translate('library.Publish'))
      } else {
        $('#actions .insert a #ui-caption').text(translate('library.InsertAction'))
      }

      const itemIds = this.getSelectedItemIds()

      $('#stream li').removeClass('selected')

      const selectedItems = []
      let contribute = true
      let enableDownload = true
      let enableMove = true
      let enableShare = true
      const fromLightBox = $.bbq.getState('lightboxSelected') === 'true'

      if (itemIds) {
        for (let i = 0; i < itemIds.length; i++) {
          const $selectedItem = fromLightBox ? $('#lightbox li[data-item-id=' + itemIds[i] + ']') : $('#stream li[data-item-id=' + itemIds[i] + ']')
          selectedItems.push($selectedItem)
          $selectedItem.addClass('selected')

          if (!$selectedItem.hasClass('contribute')) { contribute = false }

          if (!$selectedItem.hasClass('download')) { enableDownload = false }

          if (!$selectedItem.hasClass('move')) { enableMove = false }

          if (!$selectedItem.hasClass('share')) { enableShare = false }
        }
      }

      // Multiple items or batch area
      if (selectedItems.length > 1) {
        this.enableButton('delete', contribute)
        this.enableButton('download', enableDownload)
        this.enableButton('insert', this.insertMultiple && app.openedForInsert())
        this.enableButton('organize', contribute)
        this.enableButton('move', enableMove)
        this.enableButton('share', enableShare)
        this.enableButton('more-button', false)
      }
      // No items selected
      else if (selectedItems.length === 0) {
        this.enableButton('download', false)
        this.enableButton('insert', false)
        this.enableButton('delete', false)
        this.enableButton('organize', false)
        this.enableButton('move', false)
        this.enableButton('share', false)
        this.enableButton('more-button', false)
      }
      // Single item selected
      else if (selectedItems.length === 1) {
        this.enableButton('delete', contribute)
        this.enableButton('insert', true)
        this.enableButton('download', enableDownload)
        this.enableButton('organize', contribute)
        this.enableButton('move', enableMove)
        this.enableButton('share', enableShare)
        this.enableButton('more-button', true)
      }
    },

    //
    // Enables or disables a toolbar button
    //
    enableButton: function (name, enabled) {
      if (enabled === undefined) { enabled = false }
      const $button = $('#actions .' + name, this.$domobject)
      if (enabled) {
        $button.removeClass('inactive')
      } else {
        $button.addClass('inactive')
      }
    },

    cropAndDownload: function (externalLinkModel) {
      const downloadCallback = (effects) => {
        externalLinkModel.Effects = effects
        externalLinkModel.MediaFormatId = 0
        this.openDownloadExternalLinkDialog(externalLinkModel)
        $(window).focus()
      }
      new ImageVaultUi.ImageVaultEditor(externalLinkModel.MediaIds[0], externalLinkModel.FormatId, null, {
        callback: downloadCallback,
        editorOkButtonText: translate('common.Next')
      })
    },

    openDownloadExternalLinkDialog: function (externalLinkModel) {
      const linkDialog = new ImageVaultUi.ExternalLinkDialog({
        externalLinkModel,
        excludeActions: [
          'copyLink',
          'copyEmbedCode'
        ],
        actions: {
          downloadButton: {
            action: () => this.download(externalLinkModel),
            text: translate('common.Download'),
            cssClass: 'ok-action'
          }
        }
      })
      this.linkDialog = linkDialog
      linkDialog.open()

      const externalLinkDialog = void 0
      $('body').append($(externalLinkDialog))
    },

    download: function (externalLinkModel) {
      if (this.linkDialog.requirePublishDetails) {
        $("#publishDetailForm").find(":submit").click();

        // Validate text fields for file usage
        if (!$(".publish-details-text")[0].checkValidity() ||
          !$(".publish-details-url")[0].checkValidity()) return
      }

      const { Effects } = externalLinkModel
      let parsedEffects = ''
      if (Effects) {
        parsedEffects = JSON.parse(Effects)
      }

      const data = JSON.stringify({
        Effects: parsedEffects,
        MediaIds: externalLinkModel.MediaIds,
        FormatId: externalLinkModel.FormatId,
        PublishUrl: $('.publish-details-url').val(),
        PublishText: $('.publish-details-text').val()
      })

      $(".cancel-action").click()

      app.json({
        url: 'api/mediaservice/downloadmediaitem',
        data: data,
        success: function (response) {
          return window.location = `${window.location.origin}${response.Url}?download=1`;
        },
        error: function (err) {
          return app.showError('Error downloading media', `${err?.Message} ${err?.ExceptionMessage}`);
        }
      });

    },

    _openDownloadMenuRunning: false,
    //
    // Open download menu
    //
    openDownloadMenu: function (ids) {
      const self = this
      if (this.downloadPopup) {
        if (this.downloadPopup.isVisible()) {
          this.downloadPopup.hide()
          return false
        } else {
          // New id, throw item and get a new one
          this.downloadPopup.get('$domobject').remove()
        }
      }

      if (this._openDownloadMenuRunning)
        return;
      this._openDownloadMenuRunning = true;
      const loading = new IVNotification(translate('common.Loading'))

      // Download multiple media items
      app.load({
        controller: 'library',
        action: 'GetAvailableMediaFormats',
        data: { mediaItemids: ids },
        dataType: 'JSON',
        success: function (result) {
          try {
            if (!result || !result.length) throw new Error("Assets are removed or you don't have access to them.")

            const isWhiteList = (contentType) => {
              const whiteList = [
                'image'
              ]

              const blackList = [
                "svg+xml"
              ]

              const temp = contentType.split('/')
              const ct1 = temp[0]
              const ct2 = temp[1]
              return blackList.filter(b => b.includes(ct2)).length === 0 && whiteList.filter(w => w.includes(ct1)).length > 0
            }

            const isTouchLayout = () => window.innerWidth < 1010

            const mediaItemIdsAsQuery = 'mediaItemIds=' + ids.join(',')
            const formats = result.map(format => {
              return {
                MediaFormatOutputType: ids.length === 1 && isWhiteList(format.ContentType) && !isTouchLayout() ? format.MediaFormatOutputType : '',
                Url: `library/DownloadMediaItems?formatId=${format.Id}&${mediaItemIdsAsQuery}`,
                MediaFormatName: format.Name,
                MediaFormatId: format.Id,
                Id: ids[0],
                CropTitle: translate('common.CropTitle'),
                DownloadTitle: translate('library.DownloadAction')
              }
            })

            const unavailableFiles = self.getSelectedItems(':not(.download)')
            const unavailableFilesArray = unavailableFiles.map(file => {
              return { Url: file.find('img').attr('src') }
            })

            // Wrap the data to use with jquery template
            const data = [{
              format: formats,
              allUnavailableFiles: unavailableFiles.length === ids.length,
              unavailableFiles: unavailableFilesArray
            }]

            const $popup = $('#download-menu-template').tmpl(data)
              .css('display', 'none')
              // Append template to action list item
              .appendTo($('#actions .download'))

            // Add event handlers for the yes/no buttons
            $("a[data-action='CancelDownload']", $popup).click(function () {
              self.downloadPopup.hide()
              return false
            })

            $("a[data-action='RemoveMediaItemsThatCannotBeDownloaded']", $popup).click(function () {
              self.downloadPopup.hide()
              self.removeItemsFromSelectionAndLightbox(self.getSelectedItemIds(':not(.download)'))
              self.openDownloadMenu(self.getSelectedItemIds())
              return false
            })

            const externalLinkModel = {
              IsDownload: true,
              MediaIds: ids,
              MediaUrlBase: window.location.origin
            }

            const popup = new ImageVaultUi.PopupMenu({ $domobject: $popup })
            popup.bind('downloadClick', ($a) => {
              const formatId = parseInt($a.attr('data-format-id'))
              externalLinkModel.FormatId = formatId
              externalLinkModel.MediaFormatId = formatId
              externalLinkModel.dialogClass = externalLinkModel.MediaIds.length > 1 && 'small-wide'
              self.openDownloadExternalLinkDialog(externalLinkModel)
              popup.hide()
            })

            popup.bind('edit-downloadClick', ($link) => {
              const formatId = parseInt($link.prev().attr('data-format-id'))
              externalLinkModel.FormatId = formatId
              self.cropAndDownload(externalLinkModel)
              popup.hide()
            })

            popup.show()

            self.downloadPopup = popup

            const maxHeight = Math.ceil($('#stream').height() / 1.7);
            $('#download-action-scroll').css('max-height', maxHeight)
            $('#download-action-scroll').jScrollPane()

            $('#download-action-scroll .jspDrag').click(function (e) {
              // Prevent popup menu from closing when dragging the scrollbar
              if (e.stopPropagation) { e.stopPropagation() } else { e.cancelBubble = true }
            })

            if ($('#download-action-scroll').height() < maxHeight) { $('#download-action-scroll .jspVerticalBar').hide() }
          } finally {
            self._openDownloadMenuRunning = false;
            loading.remove()
          }
        },
        error: function (error) {
          self._openDownloadMenuRunning = false;
          loading.remove()
          app.showError('Error loading available MediaFormats for items', error)
        }
      })

      return true
    },
    _openMoveMenuRunning: false,
    //
    // Open move menu
    //
    openMoveMenu: function (itemIds) {
      const self = this

      if (this.movePopup) {
        if (this.movePopup.isVisible()) {
          // Menu open, hide
          this.movePopup.hide()
          return false
        } else {
          this.movePopup.get('$domobject').remove()
        }
      }
      if (this._openMoveMenuRunning)
        return;
      this._openMoveMenuRunning = true;
      const loading = new IVNotification(translate('common.Loading'))

      app.load({
        controller: 'library',
        action: 'GetMoveableVaults',
        data: { mediaItemIds: itemIds },
        dataType: 'JSON',
        success: function (result) {
          try {
            if (!result || !result.length) { throw "Assets are removed or you don't have access to them." }

            const data = [{
              vault: result,
              itemIds: itemIds
            }]

            // var position = $("#actions .move").width() / 2 - 100;
            const $popup = $('#move-menu-template').tmpl(data).css('display', 'none')
              .appendTo('#actions .move')
            // .css("left", position);

            const popup = new ImageVaultUi.PopupMenu({ $domobject: $popup })
            popup.bind('popup:linkClicked',
              function ($a) {
                popup.hide()
                window.location = $a.attr('href')
                return false
              })

            popup.show()
            self.movePopup = popup


            // Add hash to all move menu items
            $('#move-menu ul a').each(function () {
              $(this).attr('href', $(this).attr('href') + window.location.hash)
            })

            const maxHeight = Math.ceil($('#stream').height() / 1.7);

            $('#move-action-scroll').css('max-height', maxHeight)

            $('#move-action-scroll').jScrollPane()

            $('#move-action-scroll .jspDrag').click(function (e) {
              // Prevent popup menu from closing when dragging the scrollbar
              if (e.stopPropagation) { e.stopPropagation() } else { e.cancelBubble = true }
            })

            if ($('#move-action-scroll').height() < maxHeight) { $('#move-action-scroll .jspVerticalBar').hide() }
          } finally {
            self._openMoveMenuRunning = false;
            loading.remove()
          }
        },
        error: function (error) {
          self._openMoveMenuRunning = false;
          loading.remove()
          app.showError('Error loading moveable vaults', error)
        }
      })

      return true
    },
    _openInsertMenuRunning: false,
    // _openInsertMenuTimes:0,
    //
    // Open insert menu
    //
    openInsertMenu: function (ids) {
      const self = this;

      // hide popup if visible
      if (this.insertPopup && this.insertPopup.isVisible()) {
        this.insertPopup.hide();
        return false
      }

      // If format id is specified, and app is opened for insert or multiple files are selected???
      if (this.thumbnailFormatId && (ids.length > 1 || app.openedForInsert())) {
        if (!self.libraryView.insertMode || self.libraryView.insertMode === 0 || ids.length > 1) {
          return this.insertItem(ids, this.thumbnailFormatId)
        } else if (app.openedForInsert()) {
          return self.libraryView.showEditor(ids[0], this.thumbnailFormatId)
        }
      }

      if (this.insertPopup) {
        // New id, throw item and get a new one
        this.insertPopup.get('$domobject').remove()
      }

      //menu is already loading, wait until complete
      if (this._openInsertMenuRunning) {
        return;
      }
      this._openInsertMenuRunning = true;
      const loading = new IVNotification(translate('common.Loading'))
      app.load({
        controller: 'library',
        action: 'GetAvailableFormatsForPublish',
        data: {
          mediaItemIds: ids,
          mediaUrlBase: window.location.origin
        },
        dataType: 'JSON',
        success: function (result) {
          // self._openInsertMenuTimes++;
          try {
            if (!result || !result.length) { throw "Assets are removed or you don't have access to them." }

            const isWhiteList = (contentType) => {
              const whiteList = [
                'image'
              ]

              const blackList = [
                "svg+xml"
              ]

              const temp = contentType.split('/')
              const ct1 = temp[0]
              const ct2 = temp[1]
              return blackList.filter(b => b.includes(ct2)).length === 0 && whiteList.filter(w => w.includes(ct1)).length > 0
            }

            const isTouchLayout = () => window.innerWidth < 1010

            for (var i = 0; i < result.length; i++) {
              var item = result[i];
              //item.MediaFormatOutputType = i > 0 && isWhiteList(item.ContentType) && !isTouchLayout()
              //    ? item.MediaFormatOutputType
              //    : '';
              item.MediaFormatOutputType = i > 0 && isWhiteList(item.ContentType) && !isTouchLayout()
                ? '1'
                : '';
            }

            const data = [{
              format: result
            }]
            // var position = $("#actions .insert").width() / 2 - 100;
            const $popup = $('#insert-menu-template').tmpl(data)
              .appendTo($('#actions .insert'))
              .css({
                display: 'none'
                // "left": position
              })
            const firstItemOriginal = result[0]

            const insertPublishAction = function (formatId, croplinkClicked) {

              //shall we open editor or not?
              var showEditor = croplinkClicked;
              // If chosen format is original and contentType is not video or image
              if ((formatId === firstItemOriginal.MediaFormatId &&
                firstItemOriginal.ContentType.indexOf('video') === -1 &&
                firstItemOriginal.ContentType.indexOf('image') === -1)) {
                showEditor = false;
              }
              //if insertMode is 1 (open editor), then show the editor
              if (app.openedForInsert() && self.libraryView.insertMode === 1) {
                showEditor = true;
              }
              //if we have a Play video, disable editor
              if (firstItemOriginal.DirectRendererId == "D958AB20-FEFA-4DD3-A7DE-BDAE90D32E6D") {
                showEditor = false;
              }
              //we cannot show editor if we selected more than one item
              if (ids.length > 1)
                showEditor = false;

              if (app.openedForInsert()) {
                if (showEditor) {
                  self.libraryView.showEditor(ids[0], formatId)
                } else {
                  self.insertItem(ids, self.thumbnailFormatId ? self.thumbnailFormatId : formatId)
                }
              } else {
                if (showEditor) {
                  const editor = new ImageVaultUi.ImageVaultEditor(ids[0], formatId, loading, { lang: app.getPageLang() })
                } else {
                  self.showExternalLinkDialog(ids[0], formatId)
                }
              }
            }

            // If only one element, expect that it is file to insert
            if (result.length === 1) {
              insertPublishAction(result[0].MediaFormatId, false)
            } else {
              const popup = new ImageVaultUi.PopupMenu({ $domobject: $popup })
              popup.bind('edit-insertClick', ($link) => {
                const formatId = parseInt($link.prev().attr('data-format-id'));
                insertPublishAction(formatId, true);
                popup.hide();
              });
              popup.bind('insertClick', ($a) => {
                const formatId = parseInt($a.attr('data-format-id'));
                insertPublishAction(formatId, false);
                popup.hide();
              });

              // app.log(self._openInsertMenuTimes+ " Open popup");
              popup.show()
              self.insertPopup = popup

              const maxHeight = Math.ceil($('#stream').height() / 1.7);
              // app.log(self._openInsertMenuTimes+ " Setting max-height to "+maxHeight);
              $('#insert-action-scroll').css('max-height', maxHeight);
              // app.log(self._openInsertMenuTimes+ " Activating jScrollPane");
              $('#insert-action-scroll').jScrollPane();
              // app.log(self._openInsertMenuTimes+ " Activated jScrollPane");

              $('#insert-action-scroll .jspDrag').click(function (e) {
                // Prevent popup menu from closing when dragging the scrollbar
                if (e.stopPropagation) { e.stopPropagation() } else { e.cancelBubble = true }
              })

              if ($('#insert-action-scroll').height() < maxHeight) { $('#insert-action-scroll .jspVerticalBar').hide() }
            }
          } catch (e) {
            // app.log(self._openInsertMenuTimes+ " exception");
            app.log(e);
          } finally {
            // app.log(self._openInsertMenuTimes+ " completed");
            loading.remove()
            self._openInsertMenuRunning = false;
          }
        },
        error: function (error) {
          loading.remove()
          self._openInsertMenuRunning = false;
          app.showError('Error loading available formats for MediaItem', error)
        }
      });
      return true
    },

    /* *
         * Show external link dialog (to copy external link)
         * @param {} mediaItemId
         * @param {} mediaFormatId
         * @returns {}
         */
    showExternalLinkDialog: function (mediaItemId, mediaFormatId) {
      app.json({
        controller: 'library',
        action: 'GetMediaItemInformation',
        datatype: 'JSON',
        data: { mediaItemId: mediaItemId, mediaFormatId: mediaFormatId },
        success: function (result) {
          try {
            const data = result.MediaConversions[0]
            const iconData = result.MediaConversions[1]

            // Model for showing external link view
            const externalLinkModel = {
              MediaId: result.Id,
              ExternalLink: data.Url,
              Name: data.Name,
              Html: data.Html,
              IconHtml: iconData.Html,
              VaultId: data.VaultId,
              MediaFormatId: mediaFormatId
            }

            // Show dialog with link and embed code to media
            new ImageVaultUi.ExternalLinkDialog({
              externalLinkModel: externalLinkModel
            }).open()

            const externalLinkDialog = void 0
            $('body').append($(externalLinkDialog))
          } catch (err) {
            alert('Cannot insert media.\n[Error:' + err + ']')
          }
        }
      })
    },

    //
    // Insert item
    //
    insertItem: function (itemIds, cfId) {
      app.json({
        controller: 'library',
        action: 'GetInsertMediaInformation',
        datatype: 'JSON',
        data: {
          MediaIds: itemIds,
          MediaFormatId: cfId
        },
        success: function (data) {
          try {
            app.insertCallback(data)
          } catch (err) {
            alert('Cannot insert media.\n[Error:' + err + ']')
          }
        }
      })
      return true
    },

    _openShareMenuRunning: false,
    //
    // Open share menu
    //
    openShareMenu: function (ids) {
      const self = this
      if (this.sharePopup) {
        if (this.sharePopup.isVisible()) {
          this.sharePopup.hide()
          return false
        } else {
          // New id, throw item and get a new one
          this.sharePopup.get('$domobject').remove()
        }
      }
      // this should not happen since we do not light the shareMenu button if any non shareable file is selected
      const unavailableShareFiles = self.getSelectedItemIds(':not(.share)')
      if (unavailableShareFiles.length) {
        alert('Cannot share all selected files')
        return false
      }
      if (this._openShareMenuRunning)
        return;
      this._openShareMenuRunning = true;
      // Display loading notification
      const loading = new IVNotification(translate('common.Loading'))

      // Get available conversion formats for media item from server
      app.load({
        controller: 'library',
        action: 'GetAvailableMediaFormats',
        data: { mediaItemIds: ids },
        dataType: 'JSON',
        success: function (result) {
          try {
            if (!result || !result.length) { throw "Assets are removed or you don't have access to them." }

            if (result.length === 1) {
              new ImageVaultUi.ShareDialog({ mediaFormatId: result[0].Id, mediaItemIds: ids }).open()
            } else {
              // Wrap the data to use with jquery template
              const data = {
                format: result
              }

              // Calculate position for the menu
              // var position = $("#actions .share").width() / 2 - 100;

              // Calculate position for the menu
              const $shareButton = $('#actions .share', self.$domobject)

              // Load template with data
              if (!self.$shareLightboxMenuTemplate) { self.$shareLightboxMenuTemplate = $('#share-menu-template') }

              const $popup = self.$shareLightboxMenuTemplate.tmpl(data)
                .css({
                  display: 'none'
                  // "left": position
                })

                // Append template to action list item
                .appendTo($shareButton)

              // Prevent closing menu on click
              const popup = new ImageVaultUi.PopupMenu({ $domobject: $popup })
              popup.bind('shareClick',
                function ($a) {
                  popup.hide()
                  const formatId = $a.attr('data-format-id')
                  new ImageVaultUi.ShareDialog({ mediaFormatId: formatId, mediaItemIds: ids }).open()
                  return false
                })
              popup.show()

              self.sharePopup = popup
            }
            const maxHeight = Math.ceil($('#stream').height() / 1.7);

            $('#share-scroll').css('max-height', maxHeight)
            $('#share-scroll').jScrollPane()

            $('#share-scroll .jspDrag').click(function (e) {
              // Prevent popup menu from closing when dragging the scrollbar
              if (e.stopPropagation) { e.stopPropagation() } else { e.cancelBubble = true }
            });
          } finally {
            self._openShareMenuRunning = false;
            loading.remove();
          }
        },
        error: function (error) {
          self._openShareMenuRunning = false;
          loading.remove()
          app.showError('Error loading available formats for MediaItems', error)
        }
      })

      return true
    },

    //
    // Open more menu
    //
    openMoreMenu: function ($item) {
      if (!$item) return false;
      const self = this;
      const id = $item.attr('data-item-id')

      if (this.morePopup) {
        if (this.morePopup.isVisible()) {
          // Menu open, hide
          this.morePopup.hide()
          return false
        } else {
          this.morePopup.get('$domobject').remove()
        }
      }

      const data = {
        id: id,
        version: true,
        shares: false,
        isAzureVideo: false,
        isPlayVideo: false,
        isContributor: false,
        isAgreementAdmin: false
      }

      if ($item.hasClass('shared')) {
        data.shares = true;
      }
      if ($item.hasClass('azurevideo')) {
        data.isAzureVideo = true;
      }
      if ($item.hasClass('playvideo')) {
        data.isPlayVideo = true;
      }
      if ($item.hasClass('contribute')) {
        data.isContributor = true;
      }
      if (app.isUserInRole(ImageVaultUi.GlobalRoles.Administrator | ImageVaultUi.GlobalRoles.AgreementsUser)) {
        data.isAgreementAdmin = true;
      }
      data.publishes = true

      // var position = $("#actions .more-button").width() / 2 - 100;
      const $popup = $('#more-menu-template')
        .tmpl(data)
        .appendTo('#actions .more-button')
        .css({
          display: 'none'
          // "left": position
        })

      const popup = new ImageVaultUi.PopupMenu({ $domobject: $popup, MediaItemId: id })
      popup.bind('popup:linkClicked', function ($a) {
        popup.hide()

        // Handle different menu items
        switch ($a.attr('id')) {
          case 'more-shares':
            (new ImageVaultUi.ViewSharesDialog({ mediaItemId: parseInt($a.attr('data-media-id')) })).open()
            break
          case 'more-versions':
            (new ImageVaultUi.VersionsDialog({ mediaItemId: parseInt($a.attr('data-media-id')) })).open()
            break
          case 'more-publishes':
            (new ImageVaultUi.PublishesDialog({ mediaItemId: parseInt($a.attr('data-media-id')) })).open()
            break
          case 'subtitles':
            (new ImageVaultUi.SubtitlesDialog({ mediaItemId: parseInt($a.attr('data-media-id')) })).open()
            break
          case 'more-agreement-history':
            ImageVault.ImageVaultLibraryApp.showMoreAgreementHistoryDialog($a.attr('data-media-id'));
            break
          default:
            break
        }
        return false
      });

      popup.show()
      self.morePopup = popup

      return true
    },

    //
    // Change number of columns to show in library
    //
    changeNumberOfColumns: function (columns) {
      const self = this
      if (columns === null || columns < 1) { columns = 2 }

      // Set cookie with number of columns value
      const cookieData = ImageVaultUi.Common.getJsonCookie('ImageVaultCookieData')
      cookieData.Columns = columns
      ImageVaultUi.Common.setCookie('ImageVaultCookieData', cookieData, 1)

      // Set number of columns to dom
      $('#stream').attr('data-number-of-columns', columns)

      // Set current choice to active
      $('.columns a').removeClass('active')
      $('a[data-columns=' + columns + ']').addClass('active')

      // Update images depending on highest width or height
      self.libraryView.updateLibraryViewSettings()
    },

    //
    // Get selected itemids in library or lightbox
    //
    getSelectedItemIds: function (classname) {
      const items = []

      // Check if lightbox is selected else take selected items
      if ($.bbq.getState('lightboxSelected') === 'true') {
        const $lightboxItems = $('#lightbox.selected li' + (classname != null ? classname : ''))

        for (let i = 0; i < $lightboxItems.length; i++) { items.push($lightboxItems.eq(i).attr('data-item-id')) }
      } else {
        const $libraryItems = $('#stream li.selected' + (classname != null ? classname : ''))

        for (let j = 0; j < $libraryItems.length; j++) { items.push($libraryItems.eq(j).attr('data-item-id')) }
      }

      return items
    },

    //
    // Get selected items in library or lightbox
    //
    getSelectedItems: function (classname) {
      const fromLightBox = $.bbq.getState('lightboxSelected') === 'true'

      const itemIds = this.getSelectedItemIds(classname)

      const $selectedItems = []
      for (let i = 0; i < itemIds.length; i++) {
        const $item = (fromLightBox
          ? $('#lightbox.selected li[data-item-id=' + itemIds[i] + ']')
          : $('#stream li[data-item-id=' + itemIds[i] + ']'))

        if ($item.length) { $selectedItems.push($item) }
      }

      return $selectedItems
    },

    //
    // Remove items from selection and lightbox
    //
    removeItemsFromSelectionAndLightbox: function (itemsToRemove) {
      this.libraryView.lightbox.removeFromLightbox(itemsToRemove)
      this.libraryView.unSelectItems(itemsToRemove)
    },

    //
    // Show popup for cannot organize
    //
    showCannotOrganizePopup: function (unorganizableFiles) {
      const self = this
      if (this.cannotOrganizePopup) {
        if (this.cannotOrganizePopup.isVisible()) {
          this.cannotOrganizePopup.hide()
          return false
        } else {
          // new id, throw item and get a new one
          this.cannotOrganizePopup.get('$domobject').remove()
        }
      }

      // Calculate position for the menu
      const $organizeButton = $('#actions .organize', self.$domobject)
      // var position = $("#actions .organize").width() / 2 - 100;

      // Load template with data
      if (self.$cannotOrganizePopupTemplate == undefined || self.$cannotOrganizePopupTemplate.length === 0) { self.$cannotOrganizePopupTemplate = $('#cannot-organize-menu-template') }

      const items = self.getSelectedItemIds()

      const unorganizableFilesArray = []

      for (let i = 0; i < unorganizableFiles.length; i++) {
        unorganizableFilesArray.push({ Url: unorganizableFiles[i].find('img').attr('src') })
      };

      const data = {
        numberOfItems: items.length,
        maxCount: self.maxCount,
        numberOfUnorganizableFiles: unorganizableFiles.length,
        unorganizableFiles: unorganizableFilesArray,
        numberOfItemsOverLimit: items.length - self.maxCount
      }

      const $popup = self.$cannotOrganizePopupTemplate.tmpl(data)
        .css({
          display: 'none'
          // "left": position
        })

        // Append template to action list item
        .appendTo($organizeButton)

      // Add event handlers for the yes/no buttons
      $("a[data-action='CancelOrganize']", $popup).click(function () {
        self.cannotOrganizePopup.hide()
        return false
      })

      $("a[data-action='RemoveMediaItemsThatCannotBeOrganized']", $popup).click(function () {
        self.cannotOrganizePopup.hide()
        self.removeItemsFromSelectionAndLightbox(self.getSelectedItemIds(':not(.contribute)'))

        return false
      })

      const popup = new ImageVaultUi.PopupMenu({ $domobject: $popup })
      popup.show()

      self.cannotOrganizePopup = popup

      return true
    },

    //
    // Show cannot move popup
    //
    showCannotMovePopup: function (unMovableItems, exceededMaxCountWidthNumberOfFiles, numberOfItems) {
      const self = this
      if (this.cannotMovePopup) {
        if (this.cannotMovePopup.isVisible()) {
          this.cannotMovePopup.hide()
          return false
        } else {
          this.cannotMovePopup.get('$domobject').remove()
        }
      }

      // Calculate position for the menu
      const $moveButton = $('#actions .move', self.$domobject)
      // var position = $("#actions .move").width() / 2 - 100;

      // Load template with data
      if (self.$cannotMovePopupTemplate == undefined || self.$cannotMovePopupTemplate.length === 0) { self.$cannotMovePopupTemplate = $('#cannot-move-menu-template') }

      const itemsData = []

      for (let i = 0; i < unMovableItems.length; i++) {
        itemsData.push({ Url: unMovableItems[i].find('img').attr('src') })
      }

      const data = {
        toManyItemsSelected: exceededMaxCountWidthNumberOfFiles > 0,
        numberOfItems: numberOfItems,
        unMovableItems: itemsData,
        numberOfItemsOverLimit: numberOfItems - self.maxCount,
        maxCount: self.maxCount
      }

      const $popup = self.$cannotMovePopupTemplate.tmpl(data)
        .css({
          display: 'none'
          // "left": position
        })
        // Append template to action list item
        .appendTo($moveButton)

      // Add event handlers for the yes/no buttons
      $("a[data-action='CancelMove']", $popup).click(function () {
        self.cannotMovePopup.hide()
        return false
      })

      $("a[data-action='RemoveMediaItemsThatCannotBeMoved']", $popup).click(function () {
        self.cannotMovePopup.hide()

        self.removeItemsFromSelectionAndLightbox(self.getSelectedItemIds(':not(.move)'))

        self.openMoveMenu(self.getSelectedItemIds())

        return false
      })

      const popup = new ImageVaultUi.PopupMenu({ $domobject: $popup })
      popup.show()

      self.cannotMovePopup = popup

      return true
    },
    setDeleteState: function (state) {
      const $deleteTextSpan = $('#actions .delete a .inner-text')[0]
      this.deleteState = state
      switch (state) {
        case ImageVaultUi.NavigationEvents.navtoolbarDeleteStates.delete:
          // do stuff
          $deleteTextSpan.innerText = translate('library.DeleteAction')
          break
        case ImageVaultUi.NavigationEvents.navtoolbarDeleteStates.removeFromCollection:
          $deleteTextSpan.innerText = translate('library.DeleteFromCollection')
          break
        default:
          break
      }
    }
  }
  ns.Toolbar = toolbar
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {})
