﻿(function ($, ns) {
    var organizeView = function (config) {
        this.init(config);
        this.checkIfListIsEmpty();
        return this;
    };
    organizeView.prototype = {
        currentSelection: null,
        init: function (config) {
            //map external functions
            $.extend(this, config);
            var self = this;
            var organizeToolbar = new ImageVaultUi.OrganizeAllItemsToolbar({
                $domobject: $('#organize-toolbar'),
            });

            app.bind('category:edited', this.refreshCategoryList, this);
            app.bind('category:added', this.refreshCategoryList, this);
            app.bind('category:deleted', this.refreshCategoryList, this);

            var $form = $('form');
            //			// disable organize anchor
            //			$('a.organize').click(function (e) {
            //				if ($(this).hasClass('inactive')) {
            //					e.preventDefault();
            //				}
            //			});

            $form.submit(function () {
                $(this).find(':submit').css('opacity', '0.5');
                $(':submit', this).click(function () {
                    return false;
                });
            });

            this.boundBlurOnTag = this.blurOnTag.bind(this);
            this.boundKeyUpOnTag = this.keyUpOnTag.bind(this);
            this.boundClickNewTag = this.clickNewTag.bind(this);

            $(function () {

                // Init category menus for all items
                $('div.category-tree', $form).each(function () {
                    // Ignore "all" menu since it is setup separately
                    if (this.id === 'category-tree-all') return;
                    const $dropdown = $(this);
                    const popup = new ImageVaultUi.OrganizeCategoryPopupMenu({
                        $domobject: $dropdown
                    });
                });

                $('.ai-data>.description-container').each(function () {
                    var textarea = this.querySelector('textarea');
                    textarea.addEventListener("blur", function () { self.updateHiddenField(textarea) });;
                });

                $('.ai-data>.analyze-btn').click(function () {
                    var id = this.getAttribute('data-versionid');
                    var tagscontainer = this.parentElement.querySelector('.tags-container');
                    var descriptioncontainer = this.parentElement.querySelector('.description-container');
                    var loader = tagscontainer.querySelector('.loader');
                    var list = tagscontainer.querySelector('.tagslist');
                    this.classList.remove('visible');
                    var descriptionText = descriptioncontainer.querySelector('textarea');
                    descriptionText.disabled = true;
                    descriptioncontainer.classList.add('visible');
                    $(list).hide();
                    $(tagscontainer).show();
                    $(loader).show();
                    self.fetchTags(id, function (res) {
                        try {
                            $(loader).hide();
                            $(list).show();
                            list.classList.add('visible');
                            if (typeof res === "string") {
                                self.setErrorMessage(tagscontainer, '.tags-error', res)
                            } else if (res.tags === undefined || !res.tags.length) {
                                self.setErrorMessage(tagscontainer, '.tags-error', translate('organize.NoTagsFound'))
                                if (!res.description) {
                                    self.setErrorMessage(descriptioncontainer, '.description-error', translate('organize.DescriptionError'))
                                }
                            } else if (Array.isArray(res.tags)) {

                                const oldTags = Array.from(list.querySelectorAll('.tag')).map(function (tag) {
                                    return tag.textContent.trim()
                                })

                                let tags = [];
                                oldTags.length
                                    ? tags = res.tags.filter(function (tag) { return !oldTags.includes(tag) })
                                    : tags = res.tags

                                tags.forEach(function (tagname) {
                                    ImageVaultUi.CreateTagHelper.createTag(tagname, list)
                                });

                                self.addDescription(res.description, descriptionText, descriptioncontainer);
                            }
                        } finally {
                            descriptionText.disabled = false;
                        }
                    });
                });

                $('#analyze-all-items').click(function () {
                    var buttons = document.querySelectorAll('.ai-data>.analyze-btn');
                    for (var i = 0; i < buttons.length; i++) {
                        if (buttons[i].classList.contains('visible')) buttons[i].click();
                    }
                    this.classList.remove('analyze-btn');
                    this.classList.add('disable-tags-btn');
                });

                var tagIcons = document.querySelectorAll('.tagslist>.add-tag');
                for (var i = 0; i < tagIcons.length; i++) {
                    tagIcons[i].addEventListener('click', self.boundClickNewTag);
                }

                var tagInputs = document.querySelectorAll('.add-tag>input');
                for (var i = 0; i < tagInputs.length; i++) {
                    tagInputs[i].addEventListener('blur', self.boundBlurOnTag);
                    tagInputs[i].addEventListener('keydown', self.boundKeyUpOnTag);
                }

                $('span.remove').click(function () {
                    ImageVaultUi.CreateTagHelper.removeTag(this);
                });


                $('body').delegate('input, select', 'keydown', function (e) {
                    if (e.keyCode === 13) {
                        var self = $(this), form = self.parents('form:eq(0)'), focusable, next;
                        //do not handle enter for tags
                        if (self.parents("ul.tagslist").length > 0) return true;
                        //include all visible inputs
                        focusable = form.find(':input').filter(':visible');
                        next = focusable.eq(focusable.index(this) + 1);
                        if (next.length) {
                            next.focus();
                        }
                        return false;
                    }
                });
            });

            // remove single duplicate from the organize batch
            var $removeSingleDuplicateButton = $('.duplicatewrapper a.delete');
            $removeSingleDuplicateButton.click(function (event) {
                var $mediaId = parseInt($(event.target).attr('data-media-id'), 10);
                self.removeMediaItems([$mediaId]);
                return false;
            });

            // remove all duplicates from the organize batch
            var $removeAllDuplicateButton = $('#remove-duplicates-button');
            if ($removeAllDuplicateButton) {
                $removeAllDuplicateButton.click(function () {
                    var $medias = $('.duplicatewrapper a.delete')
                        .map(function () {
                            return parseInt($(this).attr('data-media-id'), 10);
                        })
                        .get();
                    if ($medias && $medias.length) {
                        self.removeMediaItems($medias);
                    }
                    return false;
                });
            }

            var userLang = $('body').attr('data-ui-culture');

            var options = $.extend({}, $.datepicker.regional[userLang], {
                showOn: 'button',
                buttonText: '',
                dateFormat: 'yy-mm-dd',
            });

            $.datepicker.setDefaults(options);

            // Add date picker
            $('.date-picker').datepicker();

            // Add hash to cancel buttons
            $('.cancel').each(function () {
                $(this).attr('href', $(this).attr('href') + window.location.hash);
            });

            // Add hash to form
            $('form').attr('action', $('form').attr('action') + window.location.hash);
        },
        blurOnTag: function (e) {
            var ul = e.target.parentElement.parentElement;
            ImageVaultUi.CreateTagHelper.removeTag(e.target, false)
            document.getElementById('additional-save').removeAttribute('disabled');
            document.getElementById('save').removeAttribute('disabled');
            this.appendAdderTag(ul, e.target.maxLength);
        },
        keyUpOnTag: function (e) {
            if (e.keyCode === 13) {
                e.target.removeEventListener('blur', this.boundBlurOnTag, true);
                e.target.nextElementSibling.click();
                e.stopPropagation();
                e.preventDefault();
                return false;
            } else if (e.keyCode === 27) {
                e.target.blur();
                e.stopPropagation();
                e.preventDefault();
                return false;
            }
        },
        clickNewTag: function (e) {
            e.stopPropagation();
            var input = e.target.parentElement.querySelector('input');
            if (input.value !== '') {
                ImageVaultUi.CreateTagHelper.createTag(
                    input.value.charAt(0).toUpperCase() + input.value.slice(1),
                    e.target.parentElement.parentElement
                );
                input.value = '';
                input.classList.remove('visible');

                document.getElementById('additional-save').removeAttribute('disabled');
                document.getElementById('save').removeAttribute('disabled');
                input.blur();
            } else {
                input.classList.add('visible');
                input.focus();
                document
                    .getElementById('additional-save')
                    .setAttribute('disabled', 'disabled');
                document.getElementById('save').setAttribute('disabled', 'disabled');
            }
        },
        appendAdderTag: function (ul, maxlen) {
            var adderTag = document.createElement('li');
            adderTag.classList.add('add-tag');
            var i = document.createElement('input');
            i.setAttribute('type', 'text');
            i.setAttribute('data-lpignore', 'true');
            i.setAttribute('maxlength', maxlen);
            i.addEventListener('keydown', this.boundKeyUpOnTag);
            i.addEventListener('blur', this.boundBlurOnTag);
            var s = document.createElement('span');
            s.setAttribute('title', translate('organize.AddTag'));
            s.classList.add('icon');
            s.classList.add('icon-plus');
            adderTag.appendChild(i);
            adderTag.appendChild(s);
            adderTag.addEventListener('click', this.boundClickNewTag);
            ul.appendChild(adderTag);
        },
        // deletes and removes media items from the organize batch
        removeMediaItems: function (mediaIds) {
            var self = this;
            app.load({
                controller: 'organize',
                action: 'removeduplicates',
                data: {
                    mediaIds: mediaIds,
                    performRedirect: false,
                },
                success: function (data) {
                    if (data) {
                        for (var i = 0; i < mediaIds.length; i++) {
                            $('li.item-' + mediaIds[i]).remove();
                        }

                        // Refresh input names
                        self.regenerateInputNumbersInNames();
                        self.hideRemoveDuplicatesButtonIfNoDuplicatesAreLeft();
                        self.checkIfListIsEmpty();
                    }
                },
            });
        },
        hideRemoveDuplicatesButtonIfNoDuplicatesAreLeft: function () {
            if (!$('.duplicatewrapper a.delete').length) {
                $('#remove-duplicates-button').hide();
            }
        },
        checkIfListIsEmpty: function () {
            if (!$('.media-item').length) {
                $('#NoItems').show();
                $('#dialog-buttons').remove();

                $('#bottom-without-items').removeClass("hide");
                $('#bottom-with-items').remove();

                $("[data-go-to]").click(function () {
                    window.location = $(this).attr("data-go-to");
                });
            }
        },

        refreshCategoryList: function () {
            app.load({
                controller: 'organize',
                action: 'refreshcategorytree',
                success: function (data) {
                    app.trigger('organize:categoriesChanged', data);
                }
            });
        },

        regenerateInputNumbersInNames: function () {
            var rowCounter = 0;

            // Loop throught every row
            $('form li.media-item').each(function () {
                var $listItem = $('form li.media-item').eq(rowCounter);

                var $formElements = $listItem.find('input, textarea, select');

                // Find all inputs and replace number in name
                $formElements.each(function (inputIndex) {
                    var $input = $formElements.eq(inputIndex);
                    var currentInputName = $input.attr('name');

                    if (currentInputName != undefined) {
                        var replacedName = currentInputName.replace(
                            new RegExp('[0-9]+'),
                            rowCounter.toString()
                        );

                        $input.attr('name', replacedName);
                    }
                });

                rowCounter++;
            });
        },

        fetchTags: function (id, callback) {
            var result;
            var check = function (res) {
                if (res.queuedOperationId) {
                    app.getJson({
                        url: 'api/queuedoperations?$filter=id eq ' + res.queuedOperationId,
                        success: function (data) {
                            if (data['@odata.count'] > 0) {
                                setTimeout(function () {
                                    check(res);
                                }, 1000);
                            } else {
                                app.load({
                                    controller: 'organize',
                                    action: 'AnalyzeImage',
                                    data: {
                                        versionId: id,
                                    },
                                    success: function (data) {
                                        result = JSON.parse(data);
                                        callback(result);
                                    },
                                    error: function (e) {
                                        callback('Error: ' + e.Message);
                                    },
                                });
                            }
                        },
                        error: function (e) {
                            callback('Error: ' + e.Message);
                        },
                    });
                } else if (res.tags || res.description) {
                    let combinedResponse = {};
                    combinedResponse.tags = res.tags;
                    combinedResponse.description = res.description;
                    callback(combinedResponse);
                }
            };
            // start the loop
            app.load({
                controller: 'organize',
                action: 'AnalyzeImage',
                data: {
                    versionId: id,
                },
                success: function (data) {
                    result = JSON.parse(data);
                    check(result);
                },
                error: function (e) {
                    callback('Error: ' + e);
                },
            });
        },

        addDescription: function (description, ta, container) {
            if (description) {
                ta.innerHTML = description;
                this.updateHiddenField(ta);
            } else {
                container.querySelector('.description-error').style.visibility = 'visible'
            }
        },

        updateHiddenField: function (target) {
            var hiddenField = document.querySelector('li.item-' + target.getAttribute("data-mediaid") + ' .metadatadescription');
            hiddenField.value = target.value;
        },

        setErrorMessage: function (container, target, errorText) {
            container.querySelector(target).innerText = errorText
            container.querySelector(target).style.visibility = 'visible'
        },

        //  updateDetailsNotification: function (detailsElement, count) {
        //    if (detailsElement) {
        //      let notification = detailsElement.querySelector("summary span.collapsable-notification");
        //      if (count && notification) {
        //        notification.innerText = count;
        //      } else if (notification) {
        //        notification.innerText = null;
        //      }
        //    }
        //  },
    };
    ns.OrganizeView = organizeView;
})(jQuery, (window.ImageVaultUi = window.ImageVaultUi || {}));
