﻿(function ($, ns, undefined) {
    var organizeAllItemsToolbar = Backbone.Model.extend({
        categoryDropDown: null,


        /**
         * Initializes the object. Run on creation
         * @returns {} 
         */
        initialize: function () {
            var self = this;
            var $domobject = this.get("$domobject");
            if ($domobject === undefined)
                throw "$domobject is not defined in config";
            //if toolbar is hidden, ignore the rest
            if ($domobject.length == 0)
                return;

            //initialization code here
            //Metadata dropdown
            var $metadatas = $(".metadatas", $domobject);
            var $metadataButton = $(".metadatas a.grey-button");
            if (!$metadataButton.hasClass("inactive")) {
                $metadataButton.unbind('click');
                var $mddrop = $metadatas.find(".dropdown");
                var metadataDropDown = new ImageVaultUi.PopupMenu({ $domobject: $mddrop });
                $metadataButton.click(function () {
                    metadataDropDown.toggle();
                    $(".page-section > ul").toggleClass("disabled");
                    return false;
                });
                //connect events for the metadata dropdown
                $metadatas.find("input[type=checkbox]").change(function () {
                    var $checkbox = $("form input[data-metadata-id=" + $(this).attr("data-metadata-id") + "]");
                    if ($(this).is(":checked")) {
                        $checkbox.prop("checked", true).trigger("change");
                    } else {
                        $checkbox.prop("checked", false).trigger("change");
                    }
                });
                $metadatas.find("input[type=text]").change(function () {
                    $("input[data-metadata-id=" + $(this).attr("data-metadata-id") + "]").val(this.value);
                });
                $metadatas.find("textarea").change(function () {
                    $("textarea[data-metadata-id=" + $(this).attr("data-metadata-id") + "]").val(this.value);
                });

                document.querySelector('.all-description-input')
                    .addEventListener('change', self.addDescriptonToAllContainers)
                document.querySelector('.all-tags-button').addEventListener('click', self.addTagToContainers)
                document.querySelector('.all-tags-input').addEventListener('focus', self.disableSaveButton)
                document.querySelector('.all-tags-input').addEventListener('blur', self.enableSaveButton)
                document.querySelector('.all-tags-input').addEventListener('keyup',
                    function (e) {
                        if (e.keyCode === 13) {
                            self.addTagToContainers(e);
                        }
                    })

            } else {
                //disable button
                $metadataButton.click(function () { return false; });
            }

            // Category dropdown
            var $drop = $('#category-tree-all');
            var categoryDropDown = new ImageVaultUi.OrganizeCategoryPopupMenu({ $domobject: $drop });
            this.categoryDropDown = categoryDropDown;
            this.initCategoryPopup();
        },

        addDescriptonToAllContainers: function (e) {
            const textAreas = Array.from(document.querySelectorAll('.description-text'));
            textAreas.forEach(function (textArea) {
                textArea.textContent = e.target.value;
                const metadataId = textArea.getAttribute('data-mediaid');
                const hiddenField = document.querySelector('li.item-' + metadataId + ' .metadatadescription');
                hiddenField.value = e.target.value;
            })
        },

        addTagToContainers: function (e) {
            e.preventDefault();
            const inputValue = document.querySelector('.all-tags-input');
            if (inputValue.value !== '') {
                const allContainers = document.querySelectorAll('.tagslist');
                Array.from(allContainers).forEach(function (container) {
                    ImageVaultUi.CreateTagHelper.createTag(inputValue.value, container);
                })
                inputValue.value = '';
            }
        },

        enableSaveButton: function () {
            document.getElementById('additional-save').removeAttribute('disabled');
            document.getElementById('save').removeAttribute('disabled');
        },

        disableSaveButton: function () {
            document.getElementById('additional-save').setAttribute('disabled', 'disabled');
            document.getElementById('save').setAttribute('disabled', 'disabled');
        },

        /**
         * Initializes the category popup
         * @returns {} 
         */
        initCategoryPopup: function () {
            const dropDown = this.categoryDropDown;
            const $domobject = dropDown.get("$domobject");
            $("input[type=checkbox]", $domobject).removeAttr("checked");
            this.bindCategoryEvents();
        },

        /**
         * Binds events for the category popup
         * Makes other items in the organize menu react to the top 'all' menu changes
         * @returns {} 
         */
        bindCategoryEvents: function () {
            const dropDown = this.categoryDropDown;
            const $domobject = dropDown.get("$domobject");
            //All items categories click event.
            $("input[type=checkbox]", $domobject).bind("change.categoryDropDown",
                function () {
                    var $checkbox = $("form li.media-item input[data-category-id=" +
                        $(this).attr("data-category-id") +
                        "]");
                    if ($(this).is(":checked")) {
                        // set property on remote categories and trigger change event
                        $checkbox.prop("checked", true).trigger("change");
                        // set all ancestors
                        $(this).parentsUntil("div.dropdown").children("input[type=checkbox]")
                            .attr("checked", "checked");
                    } else {
                        //Clear all categories below unselected.
                        $(this).siblings("ul").find("input[type=checkbox]").removeAttr("checked");
                        // uncheck and trigger change event
                        $checkbox.prop("checked", false).trigger("change");
                    }
                });
        },

        /**
         * Unbinds events for the category popup
         * @returns {} 
         */
        unbindCategoryEvents: function () {
            var dropDown = this.categoryDropDown;
            var $domobject = dropDown.get("$domobject");
            //undbind the events
            $("input[type=checkbox]", $domobject).unbind("change.categoryDropDown");
        },

        /**
         * Moves cursor to the end of input or textarea
         * @param {} $el 
         * @returns {} 
         */
        moveCursorToEnd: function ($el) {
            var strLength = $el.val().length;
            $el.focus();
            $el[0].setSelectionRange(strLength, strLength);
        }
    });
    ns.OrganizeAllItemsToolbar = organizeAllItemsToolbar;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {});