﻿(function ($, ns, undefined) {

    const organizeCategoryPopupMenu = ImageVaultUi.PopupMenu.extend({
        initialize: function() {
            // base class initializer
            ImageVaultUi.PopupMenu.prototype.initialize({ self: this });
            // initialization code here
            // listen for the organize event that informs that the categories has been changed
            app.bind('organize:categoriesChanged', this.refreshCategoryList, this);
            this.bindUiEvents();
            this.initDetailsNotification();
        },
        bindUiEvents: function() {
            const self = this;
            const $domobject = this.get('$domobject');

            // check|uncheck parents and trigger change event
            $('input[type=checkbox]', $domobject).change(function() {
                if ($(this).is(':checked')) {
                    // If category selected then select all it's ancestors, e.g. dogs also belongs to mammals and animals.
                    $(this).parentsUntil($domobject).children('input[type=checkbox]').attr('checked', 'checked')
                } else {
                    // Clear all categories below unselected.
                    $(this).removeAttr('checked').siblings('ul').find('input[type=checkbox]').removeAttr('checked')
                }
                self.trigger('category:changed');
            });

            $('.large-checkbox', $domobject).click(function() {
                $(this).siblings('input[type=checkbox]').trigger('click');
            });

            $('li label', $domobject).hover(function(e) {
                $(this).prev('span.large-checkbox').toggleClass('hover');
            });

            $('.categorySearchTerm', $domobject).bind('keyup',
                function(e) {
                    const $ul = $(e.target.parentNode.parentNode)
                    ImageVaultUi.CategorySearchHelper.searchCategories($ul, e.target.value, true)
                });

            // expand|unexpand child nodes
            $('li span.expand', $domobject).click(function() {
                if ($(this).hasClass('expanded')) {
                    $(this).removeClass('expanded')
                    $(this).parent().children('ul').hide()
                } else {
                    $(this).addClass('expanded')
                    $(this).parent().children('ul').show()
                }
            })
            if (app.isUserInRole(
                ImageVaultUi.GlobalRoles.Administrator | ImageVaultUi.GlobalRoles.CategoryAdministrator)) {
                $("a[data-action='editCategories']", $domobject)
                    .show()
                    .click(function() {
                        $.bbq.pushState({ 'admin-tab': 'categories' })
                        ImageVaultUi.AdminView.OpenDialog()
                        return false
                    })
            }
        },
        getDisplayText: function() {
            const $domobject = this.get('$domobject')
            const $checkboxes = $('input[type=checkbox]:checked', $domobject)
            if ($checkboxes.length == 0) {
                // TODO: Language
                return null
            }
            if ($checkboxes.length <= 2) {
                let anchorText = ''
                $checkboxes.each(function() {
                    anchorText += $(this).next('label').text() + ', '
                })
                anchorText = anchorText.slice(0, -2)
                return anchorText
            }
            // TODO: Language
            return $checkboxes.length + ' categories selected'
        },

        // extend OrganizeCategoryPopupMenu with the _updateAnchorText method
        updateAnchorText: function($anchor) {
            const text = this.getDisplayText()
            if (text) {
                $('span', $anchor).text(text)
                $anchor.removeClass('empty')
            } else {
                $('span', $anchor).text(translate('organize.SelectCategories'))
                $anchor.addClass('empty')
            }
        },
        // refreshes the category list
        refreshCategoryList: function(data) {
            const $domobject = this.get('$domobject');

            // store all expanded categories
            const expandedCategories = this.getExpandedCategories();
            let selectedCategories = this.getSelectedCategories();

            // get id of the media item
            const idstr = $domobject.attr('data-mediaitem-id');
            if (idstr !== undefined) {
                const id = parseInt(idstr)
                // if id>0, change names of items
                if (id > 0) {
                    data = data.replace(/Items\[\].Category\[\].0\-/g, 'Items[].Category[].' + id + '-');
                    data = data.replace(/id-0\-/g, 'id-' + id + '-');
                }
            }
            // update vault list
            $domobject.html(data)
            // filter the selected categories that are left (filter out anyone that is deleted)
            const noOfSelectedCategories = selectedCategories.length
            const availableCategories = this.getAvailableCategories()
            selectedCategories = _.intersection(selectedCategories, availableCategories)

            // restore expanded state
            this.expandCategories(expandedCategories)
            // select the categories that should be selected
            this.selectCategories(selectedCategories)

            this.moveCursorToEnd($('.categorySearchTerm'))
            this.bindUiEvents()

            // if selection has changed, trigger event
            if (noOfSelectedCategories != selectedCategories.length) {
                this.trigger('category:changed')
            }
        },
        // Gets selected categories from hash fragment and returns as array
        getSelectedCategories: function() {
            const $domobject = this.get('$domobject')

            return $('input:checked', $domobject).map(function() {
                return $(this).attr('data-category-id')
            }).get()
        },
        // gets all expanded categories(id)
        getExpandedCategories: function() {
            const $domobject = this.get('$domobject')
            return $('ul span.expanded + input:checkbox', $domobject).map(function() {
                return $(this).attr('data-category-id')
            }).get()
        },
        // gets all available categories (id)
        getAvailableCategories: function() {
            const $domobject = this.get('$domobject')
            return $('ul input:checkbox', $domobject).map(function() {
                return $(this).attr('data-category-id')
            }).get()
        },
        // Expands the supplied categories (list of id)
        expandCategories: function(list) {
            for (let i = 0; i < list.length; i++) {
                this.expandCategory(list[i])
            }
        },
        // expands the selected category (id)
        expandCategory: function(categoryId) {
            const $domobject = this.get('$domobject')
            const $element = $("input:checkbox[data-category-id='" + categoryId + "']", $domobject).parent()
                .find('>span.expand')
            $element.addClass('expanded')
            $element.siblings('ul').show()
        },
        selectCategories: function(list) {
            for (let i = 0; i < list.length; i++) {
                this.selectCategory(list[i])
            }
        },
        selectCategory: function(id) {
            const $domobject = this.get('$domobject')
            $("input:checkbox[data-category-id='" + id + "']", $domobject).attr('checked', 'checked')
        },
        initDetailsNotification: function() {
            const self = this;
            const $domobject = this.get('$domobject');
            const detailsElement = $domobject.closest('details')[0];
            self.bind('category:changed',
                function() {
                    self.updateDetailsNotification(detailsElement, self.getSelectedCategories().length);

                    // Update the model's SelectedCategories string in the hidden input manually
                    $domobject
                        .next("input[type='hidden']")
                        .val(self.getSelectedCategories().join());
                });
            self.updateDetailsNotification(detailsElement, self.getSelectedCategories().length);
        },
        updateDetailsNotification: function (detailsElement, count) {
            if (detailsElement) {
                const notification = detailsElement.querySelector('summary span.collapsable-notification');
                if (count && notification) {
                    notification.innerText = count;
                } else if (notification) {
                    notification.innerText = null;
                }
            }
        },
        /**
         * Moves cursor to the end of input or textarea
         * @param {} $el
         * @returns {}
         */
        moveCursorToEnd: function($el) {
            const strLength = $el.val().length
            $el.focus()
            $el[0].setSelectionRange(strLength, strLength);
        }
    });
    ns.OrganizeCategoryPopupMenu = organizeCategoryPopupMenu;
})(jQuery, window.ImageVaultUi = window.ImageVaultUi || {})
