﻿#Make all errors stop execution
$ErrorActionPreference = "Continue"

function XmlDocTransform($xml, $xdt)
{
    if (!$xml -or !(Test-Path -path $xml -PathType Leaf)) {
        throw "File not found. $xml";
    }
    if (!$xdt -or !(Test-Path -path $xdt -PathType Leaf)) {
        throw "File not found. $xdt";
    }
	echo "Loading configuration $xml"
    $xmldoc = New-Object Microsoft.Web.XmlTransform.XmlTransformableDocument;
    $xmldoc.PreserveWhitespace = $true
    $xmldoc.Load($xml);

    echo "Applying transformation $xdt"
    $transf = New-Object Microsoft.Web.XmlTransform.XmlTransformation($xdt);
    if ($transf.Apply($xmldoc) -eq $false)
    {
        throw "Transformation failed."
    }
    $xmldoc.Save($xml);
	echo "Changes saved to $xml"
}

function UpdateConfig($name){
	$webFile = Join-Path $webrootFolder $name
	if(!(Test-Path $webFile)) {
		$name = [System.IO.Path]::GetFileNameWithoutExtension($webFile)
		$extension = [System.IO.Path]::GetExtension($webFile)
		$defaultFile = Join-Path $updateFolder "$name.default$extension"
		if(!(Test-Path $defaultFile)) {
			throw "Default config file $defaultFile is missing"
		}
		Copy-Item $defaultFile $webFile
	}
}

#Updates the web.config with the latest changes
$updateFolder = split-path -parent $MyInvocation.MyCommand.Definition
$xmldll = Join-Path $updateFolder "Microsoft.Web.XmlTransform.dll"
$webrootFolder = Split-Path -Parent $updateFolder

if(!(Test-Path $xmldll)) {
	throw "Missing dll $xmldll"
}
[Reflection.Assembly]::LoadFile($xmldll)>$null

XmlDocTransform (Join-Path $webrootFolder "web.config") (Join-Path $updateFolder "web.config.install.xdt")

#update application insigths with the lastest changes
UpdateConfig "ApplicationInsights.config"
XmlDocTransform (Join-Path $webrootFolder "ApplicationInsights.config") (Join-Path $updateFolder "ApplicationInsights.config.install.xdt")

$robotsTxtPath = (Join-Path $webrootFolder "robots.txt")
$orgRobotsTxtPath = (Join-Path $updateFolder "robots.txt")

#add robots.txt if missing
if(!(Test-Path $robotsTxtPath)) {
    echo "copy robots.txt to $robotsTxtPath"
    copy-item $orgRobotsTxtPath $robotsTxtPath
} else {
    echo "robots.txt already exists $robotsTxtPath"
}