﻿
using System;
using System.Web;
using System.Web.Mvc;
using System.Web.Script.Serialization;
using ImageVault.UI.Mvc.Models;
using Meriworks.CookieStorage;

namespace ImageVault.UI.Mvc.Views;

/// <summary>
/// Base view model
/// </summary>
/// <typeparam name="TModel"></typeparam>
public abstract class BaseViewModel<TModel> : WebViewPage<TModel>
{
    private CookieData _imageVaultCookie;

    /// <summary>
    /// CookieData
    /// </summary>
    public CookieData ImageVaultCookie
    {
        get
        {
            //reuse previously calculated cookie data
            if (_imageVaultCookie != null) 
                return _imageVaultCookie;

            //try to fetch from request
            var serializer = new JavaScriptSerializer();
            var requestCookie = Request.Cookies["ImageVaultCookieData"];
            if (requestCookie != null)
            {
                _imageVaultCookie = serializer.Deserialize<CookieData>(requestCookie.Value);
                return _imageVaultCookie;
            }
            //otherwise, create a new
            var cookieData = new CookieData();
            var cookie = new HttpCookie("ImageVaultCookieData", serializer.Serialize(cookieData))
            {
                Expires = DateTime.Now.AddYears(1),
                Secure = HttpCookieSettingsUtil.Secure,
                SameSite = HttpCookieSettingsUtil.SameSite.ToSystemWebSameSiteMode(),
            };

            Response.Cookies.Add(cookie);

            _imageVaultCookie = cookieData;

            return _imageVaultCookie;

        }
    }
}